/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.electricitygrid.generators;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerCoalGenerator;
import electrodynamics.common.reloadlistener.CoalGeneratorFuelRegister;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.common.tile.electricitygrid.generators.GenericGeneratorTile;
import electrodynamics.prefab.utilities.ElectricityUtils;
import electrodynamics.registers.ElectrodynamicsTiles;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ForgeHooks;
import voltaic.common.block.states.VoltaicBlockStates;
import voltaic.common.item.subtype.SubtypeItemUpgrade;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.prefab.utilities.object.TargetValue;
import voltaic.prefab.utilities.object.TransferPack;

public class TileCoalGenerator
extends GenericGeneratorTile {
    protected CachedTileOutput output;
    protected TransferPack currentOutput = TransferPack.EMPTY;
    public TargetValue.PropertyTargetValue heat = new TargetValue.PropertyTargetValue((SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "heat", (Object)27.0)));
    public SingleProperty<Integer> burnTime = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "burnTime", (Object)0));
    public SingleProperty<Integer> maxBurnTime = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "maxBurnTime", (Object)1));
    private SingleProperty<Double> multiplier = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "multiplier", (Object)1.0));
    private SingleProperty<Boolean> hasRedstoneSignal = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "redstonesignal", (Object)false));

    public TileCoalGenerator(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_COALGENERATOR.get(), worldPosition, blockState, 1.0, new SubtypeItemUpgrade[0]);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickClient(this::tickClient).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, true, false).setOutputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(1)).setDirectionsBySlot(Integer.valueOf(0), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP, BlockEntityUtils.MachineDirection.BOTTOM, BlockEntityUtils.MachineDirection.FRONT, BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.RIGHT}).valid((index, stack, i) -> TileCoalGenerator.getValidItems().contains(stack.m_41720_())));
        this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.coalgenerator.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerCoalGenerator((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    protected void tickServer(ComponentTickable tickable) {
        boolean greaterBurnTime;
        if ((Integer)this.burnTime.getValue() > 0) {
            this.burnTime.setValue((Object)((Integer)this.burnTime.getValue() - 1));
        }
        if (((Boolean)this.hasRedstoneSignal.getValue()).booleanValue()) {
            return;
        }
        Direction facing = this.getFacing();
        if (this.output == null) {
            this.output = new CachedTileOutput(this.f_58857_, this.f_58858_.m_121945_(facing.m_122424_()));
        }
        if (tickable.getTicks() % 20L == 0L) {
            this.output.update(this.f_58858_.m_121945_(facing.m_122424_()));
        }
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ItemStack fuel = inv.m_8020_(0);
        if ((Integer)this.burnTime.getValue() <= 0 && !fuel.m_41619_()) {
            this.burnTime.setValue((Object)ForgeHooks.getBurnTime((ItemStack)fuel, null));
            fuel.m_41774_(1);
            this.maxBurnTime.setValue((Object)Math.max((Integer)this.burnTime.getValue(), 1));
        }
        boolean bl = greaterBurnTime = (Integer)this.burnTime.getValue() > 0;
        if (BlockEntityUtils.isLit((GenericTile)this) ^ greaterBurnTime) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)greaterBurnTime);
        }
        if (this.heat.getValue() > 27.0 && this.output.valid()) {
            ElectricityUtils.receivePower((BlockEntity)this.output.getSafe(), facing, this.currentOutput, false);
        }
        this.heat.rangeParameterize(27.0, 3000.0, (Integer)this.burnTime.getValue() > 0 ? 3000.0 : 27.0, this.heat.getValue(), 600).flush();
        this.currentOutput = this.getProduced();
    }

    protected void tickClient(ComponentTickable tickable) {
        if (((Boolean)this.m_58900_().m_61143_((Property)VoltaicBlockStates.LIT)).booleanValue()) {
            Direction dir = this.getFacing();
            if (this.f_58857_.f_46441_.m_188503_(10) == 0) {
                this.f_58857_.m_7785_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, SoundEvents.f_11784_, SoundSource.BLOCKS, 0.5f + this.f_58857_.f_46441_.m_188501_(), this.f_58857_.f_46441_.m_188501_() * 0.7f + 0.6f, false);
            }
            if (this.f_58857_.f_46441_.m_188503_(10) == 0) {
                for (int i = 0; i < this.f_58857_.f_46441_.m_188503_(1) + 1; ++i) {
                    this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123756_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, (double)dir.m_122429_(), 0.0, (double)dir.m_122431_());
                }
            }
        }
    }

    public double getMultiplier() {
        return (Double)this.multiplier.getValue();
    }

    public void setMultiplier(double val) {
        this.multiplier.setValue((Object)val);
    }

    public TransferPack getProduced() {
        return TransferPack.ampsVoltage((double)((Double)this.multiplier.getValue() * ElectroConstants.COALGENERATOR_AMPERAGE * ((this.heat.getValue() - 27.0) / 2973.0)), (double)120.0);
    }

    public static List<Item> getValidItems() {
        return new ArrayList<Item>(CoalGeneratorFuelRegister.INSTANCE.getFuels());
    }

    public int getComparatorSignal() {
        return (int)(this.heat.getValue() / 3000.0 * 15.0);
    }

    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.hasRedstoneSignal.setValue((Object)this.f_58857_.m_276867_(this.m_58899_()));
    }
}

