/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.electricitygrid.generators;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerCreativePowerSource;
import electrodynamics.prefab.utilities.ElectricityUtils;
import electrodynamics.registers.ElectrodynamicsTiles;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.prefab.utilities.object.TransferPack;

public class TileCreativePowerSource
extends GenericTile {
    private static final int POWER_MULTIPLIER = 1000000;
    public final SingleProperty<Integer> voltage = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "setvoltage", (Object)0));
    public final SingleProperty<Double> power = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "setpower", (Object)0.0));
    private final SingleProperty<Boolean> hasRedstoneSignal = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "redstonesignal", (Object)false));
    protected List<CachedTileOutput> outputs;

    public TileCreativePowerSource(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_CREATIVEPOWERSOURCE.get(), worldPos, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, true, false).setOutputDirections(BlockEntityUtils.MachineDirection.values()).voltage(-1.0));
        this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.creativepowersource.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerCreativePowerSource((int)id, (Inventory)player, (ContainerData)this.getCoordsArray())));
    }

    private void tickServer(ComponentTickable tick) {
        if (((Boolean)this.hasRedstoneSignal.getValue()).booleanValue()) {
            return;
        }
        if (this.outputs == null) {
            this.outputs = new ArrayList<CachedTileOutput>();
            for (Direction dir : Direction.values()) {
                this.outputs.add(new CachedTileOutput(this.f_58857_, this.f_58858_.m_121945_(dir)));
            }
        }
        if (tick.getTicks() % 40L == 0L) {
            for (int i = 0; i < Direction.values().length; ++i) {
                CachedTileOutput cache = this.outputs.get(i);
                cache.update(this.f_58858_.m_121945_(Direction.values()[i]));
            }
        }
        if ((Integer)this.voltage.getValue() <= 0) {
            return;
        }
        TransferPack output = TransferPack.joulesVoltage((double)((Double)this.power.getValue() * 1000000.0 / 20.0), (double)((Integer)this.voltage.getValue()).intValue());
        for (int i = 0; i < this.outputs.size(); ++i) {
            Direction dir;
            CachedTileOutput cache = this.outputs.get(i);
            dir = Direction.values()[i];
            if (!cache.valid()) continue;
            ElectricityUtils.receivePower((BlockEntity)cache.getSafe(), dir.m_122424_(), output, false);
        }
    }

    public int getComparatorSignal() {
        return (Double)this.power.getValue() > 0.0 ? 15 : 0;
    }

    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.hasRedstoneSignal.setValue((Object)this.f_58857_.m_276867_(this.m_58899_()));
    }
}

