/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.electricitygrid.generators;

import electrodynamics.common.reloadlistener.ThermoelectricGeneratorHeatRegister;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.prefab.utilities.ElectricityUtils;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.object.CachedTileOutput;
import voltaic.prefab.utilities.object.TransferPack;

public class TileThermoelectricGenerator
extends GenericTile {
    protected CachedTileOutput output;
    public SingleProperty<Boolean> hasHeat = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "hasheat", (Object)false));
    public SingleProperty<Double> heatMultipler = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.DOUBLE, "multiplier", (Object)0.0));
    private SingleProperty<Boolean> hasRedstoneSignal = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "redstonesignal", (Object)false));

    public TileThermoelectricGenerator(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_THERMOELECTRICGENERATOR.get(), worldPosition, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, true, false).setOutputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP}));
    }

    protected void tickServer(ComponentTickable tickable) {
        if (((Boolean)this.hasRedstoneSignal.getValue()).booleanValue()) {
            return;
        }
        if (this.output == null) {
            this.output = new CachedTileOutput(this.f_58857_, this.f_58858_.m_121945_(Direction.UP));
        }
        Direction facing = this.getFacing();
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        if (tickable.getTicks() % 60L == 0L) {
            Fluid fluid = this.f_58857_.m_6425_(this.f_58858_.m_121945_(facing.m_122424_())).m_76152_();
            this.hasHeat.setValue((Object)ThermoelectricGeneratorHeatRegister.INSTANCE.isHeatSource(fluid));
            this.heatMultipler.setValue((Object)ThermoelectricGeneratorHeatRegister.INSTANCE.getHeatMultiplier(fluid));
            this.output.update(this.f_58858_.m_121945_(Direction.UP));
        }
        if (((Boolean)this.hasHeat.getValue()).booleanValue() && this.output.valid()) {
            ElectricityUtils.receivePower((BlockEntity)this.output.getSafe(), Direction.DOWN, TransferPack.ampsVoltage((double)(ElectroConstants.THERMOELECTRICGENERATOR_AMPERAGE * (double)this.f_58857_.m_6425_(this.f_58858_.m_121945_(facing.m_122424_())).m_76186_() / 8.0 * (Double)this.heatMultipler.getValue()), (double)electro.getVoltage()), false);
        }
    }

    public int getComparatorSignal() {
        return (Boolean)this.hasHeat.getValue() != false ? 15 : 0;
    }

    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.hasRedstoneSignal.setValue((Object)this.f_58857_.m_276867_(this.m_58899_()));
    }
}

