/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.machines;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.registers.ElectrodynamicsRecipies;
import electrodynamics.registers.ElectrodynamicsSounds;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.api.particle.ParticleAPI;
import voltaic.common.inventory.container.ContainerO2OProcessor;
import voltaic.prefab.sound.ITickableSound;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public class TileLathe
extends GenericTile
implements ITickableSound {
    private boolean isSoundPlaying = false;

    public TileLathe(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_LATHE.get(), worldPosition, blockState);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickClient(this::tickClient));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}).voltage(240.0));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().processors(1, 1, 1, 1).upgrades(3)).valid(TileLathe.machineValidator()).setDirectionsBySlot(Integer.valueOf(0), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.RIGHT, BlockEntityUtils.MachineDirection.TOP, BlockEntityUtils.MachineDirection.FRONT}).setDirectionsBySlot(Integer.valueOf(1), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.BOTTOM}).setDirectionsBySlot(Integer.valueOf(2), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.BOTTOM}));
        this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.lathe.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerO2OProcessor(id.intValue(), player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
        this.addComponent((IComponent)new ComponentProcessor((GenericTile)this).canProcess((component, procNumber) -> component.canProcessItem2ItemRecipe(procNumber.intValue(), (RecipeType)ElectrodynamicsRecipies.LATHE_TYPE.get())).process(ComponentProcessor::processItem2ItemRecipe));
    }

    protected void tickClient(ComponentTickable tickable) {
        if (!((ComponentProcessor)this.getComponent(IComponentType.Processor)).isActive(0)) {
            return;
        }
        Direction direction = this.getFacing();
        if (this.f_58857_.f_46441_.m_188500_() < 0.1) {
            for (int i = 0; i < 5; ++i) {
                double d4 = this.f_58857_.f_46441_.m_188500_() * 4.0 / 16.0 + 0.5 - 0.125;
                double d6 = this.f_58857_.f_46441_.m_188500_() * 4.0 / 16.0 + 0.5 - 0.125;
                ParticleAPI.addGrindedParticle((Level)this.f_58857_, (double)((double)this.f_58858_.m_123341_() + d4 + (double)direction.m_122429_() * 0.2), (double)((double)this.f_58858_.m_123342_() + 0.7), (double)((double)this.f_58858_.m_123343_() + d6 + (double)direction.m_122431_() * 0.2), (double)0.0, (double)0.0, (double)0.0, (BlockState)Blocks.f_50075_.m_49966_(), (BlockPos)this.f_58858_);
            }
        }
        if (!this.isSoundPlaying) {
            this.isSoundPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)((SoundEvent)ElectrodynamicsSounds.SOUND_LATHEPLAYING.get()), (BlockEntity)this, (boolean)true);
        }
    }

    public void setNotPlaying() {
        this.isSoundPlaying = false;
    }

    public boolean shouldPlaySound() {
        return ((ComponentProcessor)this.getComponent(IComponentType.Processor)).isAnyActive();
    }

    public int getComparatorSignal() {
        return (int)((double)((ComponentProcessor)this.getComponent(IComponentType.Processor)).getTotalActive() / (double)Math.max(1, ((ComponentProcessor)this.getComponent(IComponentType.Processor)).getProcessorCount()) * 15.0);
    }
}

