/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.machines.charger;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerChargerGeneric;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.registers.ElectrodynamicsItems;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import voltaic.api.item.IItemElectric;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.prefab.utilities.object.TransferPack;

public abstract class GenericTileCharger
extends GenericTile {
    private static final int BATTERY_COUNT = 3;

    protected GenericTileCharger(BlockEntityType<?> typeIn, int voltageMultiplier, SubtypeMachine machine, BlockPos worldPosition, BlockState blockState) {
        super(typeIn, worldPosition, blockState);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BACK}).voltage(120.0 * (double)voltageMultiplier).maxJoules(2000.0 * (double)voltageMultiplier));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().inputs(4).outputs(1)).valid(GenericTileCharger.machineValidator()).setDirectionsBySlot(Integer.valueOf(0), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.RIGHT, BlockEntityUtils.MachineDirection.TOP}).setDirectionsBySlot(Integer.valueOf(4), new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.LEFT, BlockEntityUtils.MachineDirection.BOTTOM}));
        this.addComponent((IComponent)new ComponentContainerProvider(machine.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerChargerGeneric((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    public void tickServer(ComponentTickable tickable) {
        ComponentInventory inventory = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        ItemStack itemInput = inventory.m_8020_(0);
        if (itemInput.m_41619_()) {
            return;
        }
        Item item = itemInput.m_41720_();
        if (item instanceof IItemElectric) {
            IItemElectric electricItem = (IItemElectric)item;
            if (inventory.inputs() > 1 && this.drainBatterySlots(inventory, electro)) {
                return;
            }
            double room = electricItem.getMaximumCapacity(itemInput) - electricItem.getJoulesStored(itemInput);
            if (electro.getJoulesStored() <= 0.0 || room <= 0.0) {
                return;
            }
            double recieveVoltage = electricItem.getElectricProperties().receive.getVoltage();
            double machineVoltage = electro.getVoltage();
            if (machineVoltage > recieveVoltage) {
                electricItem.overVoltage(TransferPack.joulesVoltage((double)electricItem.getElectricProperties().receive.getJoules(), (double)machineVoltage));
                this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50016_.m_49966_());
                this.f_58857_.m_254849_(null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), 2.0f, Level.ExplosionInteraction.BLOCK);
            } else if (machineVoltage == recieveVoltage) {
                electro.joules(electro.getJoulesStored() - electricItem.receivePower(itemInput, TransferPack.joulesVoltage((double)electro.getJoulesStored(), (double)machineVoltage), false).getJoules());
            } else {
                float underVoltRatio = (float)((double)((float)machineVoltage) / recieveVoltage);
                float itemStoredRatio = (float)((double)((float)electricItem.getJoulesStored(itemInput)) / electricItem.getMaximumCapacity(itemInput));
                float x = Math.abs(itemStoredRatio / (itemStoredRatio - underVoltRatio + 1.0E-8f));
                float reductionCoef = GenericTileCharger.getRationalFunctionValue(x);
                if (itemStoredRatio >= underVoltRatio) {
                    electricItem.extractPower(itemInput, electro.getJoulesStored() * (double)reductionCoef, false);
                } else {
                    electro.joules(electro.getJoulesStored() - electricItem.receivePower(itemInput, TransferPack.joulesVoltage((double)(electro.getJoulesStored() * (double)reductionCoef), (double)recieveVoltage), false).getJoules());
                }
            }
            if (electricItem.getJoulesStored(itemInput) == electricItem.getMaximumCapacity(itemInput) && inventory.m_8020_(4).m_41619_()) {
                inventory.m_6836_(4, inventory.m_8020_(0).m_41777_());
                inventory.m_8020_(0).m_41774_(1);
            }
            inventory.m_6596_();
        } else if (itemInput.getCapability(ForgeCapabilities.ENERGY).orElse((Object)CapabilityUtils.EMPTY_FE) != CapabilityUtils.EMPTY_FE) {
            IEnergyStorage storage = (IEnergyStorage)itemInput.getCapability(ForgeCapabilities.ENERGY).orElse((Object)CapabilityUtils.EMPTY_FE);
            if (inventory.inputs() > 1 && this.drainBatterySlots(inventory, electro) || !storage.canReceive()) {
                return;
            }
            int room = storage.receiveEnergy(Integer.MAX_VALUE, true);
            if (electro.getJoulesStored() <= 0.0 || room <= 0) {
                return;
            }
            double machineVoltage = electro.getVoltage();
            if (machineVoltage > 120.0) {
                this.f_58857_.m_46597_(this.f_58858_, Blocks.f_50016_.m_49966_());
                this.f_58857_.m_254849_(null, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), 2.0f, Level.ExplosionInteraction.BLOCK);
                return;
            }
            int accepted = (int)Math.min(electro.getJoulesStored(), (double)room);
            storage.receiveEnergy(accepted, false);
            electro.joules(electro.getJoulesStored() - (double)accepted);
            inventory.m_6596_();
        }
    }

    private static float getRationalFunctionValue(float x) {
        if (x >= 100.0f) {
            return 0.0f;
        }
        if (x <= 1.0f) {
            return 1.0f;
        }
        return 1.0f / x;
    }

    private boolean drainBatterySlots(ComponentInventory inv, ComponentElectrodynamic electro) {
        double machineVoltage = electro.getVoltage();
        double battVoltage = 0.0;
        for (int i = 0; i < 3; ++i) {
            Item item;
            ItemStack battery = inv.m_8020_(i + 1);
            if (battery.m_41619_() || !((item = battery.m_41720_()) instanceof IItemElectric)) continue;
            IItemElectric electricItem = (IItemElectric)item;
            battVoltage = electricItem.getElectricProperties().receive.getVoltage();
            if (battVoltage < machineVoltage) {
                inv.m_6836_(i + 1, new ItemStack((ItemLike)ElectrodynamicsItems.ITEM_SLAG.get()).m_41777_());
                this.m_58904_().m_5594_(null, this.m_58899_(), SoundEvents.f_11913_, SoundSource.BLOCKS, 1.0f, 1.0f);
                continue;
            }
            if (battVoltage > machineVoltage) {
                electro.overVoltage(TransferPack.joulesVoltage((double)electro.getJoulesStored(), (double)battVoltage));
                return true;
            }
            if (!(electro.getMaxJoulesStored() - electro.getJoulesStored() > 0.0)) continue;
            electro.joules(electro.getJoulesStored() + electricItem.extractPower(battery, ElectroConstants.CHARGER_USAGE_PER_TICK, false).getJoules());
        }
        return false;
    }
}

