/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.machines.quarry;

import electrodynamics.common.item.ItemDrillHead;
import electrodynamics.common.tile.machines.quarry.TileQuarry;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import voltaic.client.model.block.modelproperties.ModelPropertyConnections;
import voltaic.common.block.connect.EnumConnectType;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.tile.types.IConnectTile;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.prefab.utilities.Scheduler;

public class TileLogisticalManager
extends GenericTile
implements IConnectTile {
    private TileQuarry[] quarries = new TileQuarry[6];
    private BlockEntity[] inventories = new BlockEntity[6];
    public static final int DOWN_MASK = 15;
    public static final int UP_MASK = 240;
    public static final int NORTH_MASK = 3840;
    public static final int SOUTH_MASK = 61440;
    public static final int WEST_MASK = 983040;
    public static final int EAST_MASK = 0xF00000;
    public final SingleProperty<Integer> connections = (SingleProperty)((SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "connections", (Object)0).onChange((property, old) -> {
        this.requestModelDataUpdate();
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 8);
        }
    }).onTileLoaded(property -> this.requestModelDataUpdate()))).setShouldUpdateOnChange();

    public TileLogisticalManager(BlockPos pos, BlockState state) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_LOGISTICALMANAGER.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
    }

    private void tickServer(ComponentTickable tick) {
        for (int i = 0; i < 6; ++i) {
            IItemHandler invHandler;
            BlockEntity inventory = this.inventories[i];
            if (inventory == null || (invHandler = (IItemHandler)inventory.getCapability(ForgeCapabilities.ITEM_HANDLER, Direction.values()[i].m_122424_()).orElse((Object)CapabilityUtils.EMPTY_ITEM_HANDLER)) == CapabilityUtils.EMPTY_ITEM_HANDLER) continue;
            for (TileQuarry quarry : this.quarries) {
                if (quarry == null) continue;
                TileLogisticalManager.manipulateItems((ComponentInventory)quarry.getComponent(IComponentType.Inventory), invHandler);
            }
        }
    }

    public void onNeightborChanged(BlockPos neighbor, boolean blockStateTrigger) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.refreshConnections();
    }

    public void onPlace(BlockState oldState, boolean isMoving) {
        super.onPlace(oldState, isMoving);
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.refreshConnections();
    }

    public void refreshConnections() {
        this.quarries = new TileQuarry[6];
        this.inventories = new BlockEntity[6];
        for (Direction dir : Direction.values()) {
            BlockEntity entity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(dir));
            if (entity == null) continue;
            if (entity instanceof TileQuarry) {
                TileQuarry quarry;
                this.quarries[dir.ordinal()] = quarry = (TileQuarry)entity;
                continue;
            }
            if (entity.getCapability(ForgeCapabilities.ITEM_HANDLER, dir.m_122424_()).orElse((Object)CapabilityUtils.EMPTY_ITEM_HANDLER) == CapabilityUtils.EMPTY_ITEM_HANDLER) continue;
            this.inventories[dir.ordinal()] = entity;
        }
    }

    public void onLoad() {
        super.onLoad();
        Scheduler.schedule((int)1, this::refreshConnections);
    }

    private static void manipulateItems(ComponentInventory quarryInventory, IItemHandler handler) {
        if (quarryInventory.m_8020_(0).m_41619_()) {
            TileLogisticalManager.restockDrillHead(quarryInventory, handler);
        }
        TileLogisticalManager.addItemsToInventory(quarryInventory, handler);
    }

    private static void restockDrillHead(ComponentInventory quarryInventory, IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof ItemDrillHead)) continue;
            quarryInventory.m_6836_(0, stack.m_41777_());
            handler.extractItem(i, stack.m_41741_(), false);
            break;
        }
    }

    private static void addItemsToInventory(ComponentInventory quarryInventory, IItemHandler handler) {
        block0: for (int i = 0; i < quarryInventory.outputs(); ++i) {
            int index = i + quarryInventory.getOutputStartIndex();
            ItemStack mined = quarryInventory.m_8020_(index);
            if (mined.m_41619_()) continue;
            for (int j = 0; j < handler.getSlots(); ++j) {
                mined = handler.insertItem(j, mined, false);
                quarryInventory.m_6836_(index, mined);
                quarryInventory.setChanged(index);
                if (mined.m_41619_()) continue block0;
            }
        }
    }

    public static boolean isQuarry(BlockPos pos, LevelReader world) {
        BlockEntity entity = world.m_7702_(pos);
        return entity instanceof TileQuarry;
    }

    public static boolean isValidInventory(BlockPos pos, LevelReader world, Direction dir) {
        BlockEntity entity = world.m_7702_(pos);
        if (entity == null) {
            return false;
        }
        if (entity.getCapability(ForgeCapabilities.ITEM_HANDLER, dir).orElse((Object)CapabilityUtils.EMPTY_ITEM_HANDLER) != CapabilityUtils.EMPTY_ITEM_HANDLER) {
            return true;
        }
        return entity instanceof Container;
    }

    public EnumConnectType readConnection(Direction dir) {
        int connectionData = (Integer)this.connections.getValue();
        if (connectionData == 0) {
            return EnumConnectType.NONE;
        }
        int extracted = 0;
        switch (dir) {
            case DOWN: {
                extracted = connectionData & 0xF;
                break;
            }
            case UP: {
                extracted = connectionData & 0xF0;
                break;
            }
            case NORTH: {
                extracted = connectionData & 0xF00;
                break;
            }
            case SOUTH: {
                extracted = connectionData & 0xF000;
                break;
            }
            case WEST: {
                extracted = connectionData & 0xF0000;
                break;
            }
            case EAST: {
                extracted = connectionData & 0xF00000;
                break;
            }
        }
        return EnumConnectType.values()[extracted >> dir.ordinal() * 4];
    }

    public void writeConnection(Direction dir, EnumConnectType connection) {
        int connectionData = (Integer)this.connections.getValue();
        this.connections.setValue((Object)((switch (dir) {
            case Direction.DOWN -> connectionData & 0xFFFFFFF0;
            case Direction.UP -> connectionData & 0xFFFFFF0F;
            case Direction.NORTH -> connectionData & 0xFFFFF0FF;
            case Direction.SOUTH -> connectionData & 0xFFFF0FFF;
            case Direction.WEST -> connectionData & 0xFFF0FFFF;
            case Direction.EAST -> connectionData & 0xFF0FFFFF;
            default -> 0;
        }) | connection.ordinal() << dir.ordinal() * 4));
    }

    public EnumConnectType[] readConnections() {
        EnumConnectType[] connections = new EnumConnectType[6];
        for (Direction dir : Direction.values()) {
            connections[dir.ordinal()] = this.readConnection(dir);
        }
        return connections;
    }

    @NotNull
    public ModelData getModelData() {
        return ModelData.builder().with((ModelProperty)ModelPropertyConnections.INSTANCE, () -> this.readConnections()).build();
    }
}

