/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.machines.quarry;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerSeismicRelay;
import electrodynamics.common.tile.machines.quarry.TileSeismicMarker;
import electrodynamics.registers.ElectrodynamicsItems;
import electrodynamics.registers.ElectrodynamicsTiles;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.ListProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.ItemUtils;

public class TileSeismicRelay
extends GenericTile {
    public ListProperty<BlockPos> markerLocs = (ListProperty)this.property((AbstractProperty)new ListProperty(PropertyTypes.BLOCK_POS_LIST, "markerlocs", new ArrayList()));
    public boolean cornerOnRight = false;

    public TileSeismicRelay(BlockPos worldPosition, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_SEISMICRELAY.get(), worldPosition, blockState);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().outputs(1)).valid((slot, stack, i) -> ItemUtils.testItems((Item)stack.m_41720_(), (Item[])new Item[]{(Item)ElectrodynamicsItems.ITEM_SEISMICMARKER.get()})));
        this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.seismicrelay.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerSeismicRelay((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    private void tickServer(ComponentTickable tickable) {
        if (((List)this.markerLocs.getValue()).size() < 4) {
            Direction facing = this.getFacing().m_122424_();
            Level world = this.m_58904_();
            BlockEntity tile = world.m_7702_(this.m_58899_().m_121945_(facing));
            if (tile != null && tile instanceof TileSeismicMarker) {
                TileSeismicMarker marker = (TileSeismicMarker)tile;
                this.getMarkers(marker, facing);
            }
        }
    }

    private void getMarkers(TileSeismicMarker marker, Direction facing) {
        this.markerLocs.wipeList();
        BlockPos frontMarker = TileSeismicRelay.getMarker(facing, marker.m_58899_(), marker.m_58904_());
        BlockPos sideMarker = null;
        BlockPos cornerMarker = null;
        if (frontMarker != null) {
            sideMarker = TileSeismicRelay.getMarker(facing.m_122427_(), marker.m_58899_(), marker.m_58904_());
            if (sideMarker != null) {
                this.cornerOnRight = true;
                cornerMarker = TileSeismicRelay.getMarker(facing, sideMarker, marker.m_58904_());
            } else {
                sideMarker = TileSeismicRelay.getMarker(facing.m_122428_(), marker.m_58899_(), marker.m_58904_());
                if (sideMarker != null) {
                    cornerMarker = TileSeismicRelay.getMarker(facing, sideMarker, marker.m_58904_());
                }
            }
        }
        this.markerLocs.addValue((Object)marker.m_58899_());
        if (frontMarker != null) {
            this.markerLocs.addValue((Object)frontMarker);
        }
        if (sideMarker != null) {
            this.markerLocs.addValue((Object)sideMarker);
        }
        if (cornerMarker != null) {
            this.markerLocs.addValue(cornerMarker);
        }
        if (((List)this.markerLocs.getValue()).size() > 3) {
            this.collectMarkers();
            this.m_58904_().m_5594_(null, this.m_58899_(), SoundEvents.f_11669_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static BlockPos getMarker(Direction facing, BlockPos blockPos, Level level) {
        for (int i = 0; i <= TileSeismicMarker.MAX_RADIUS; ++i) {
            BlockEntity marker = level.m_7702_(blockPos = blockPos.m_121945_(facing));
            if (!(marker instanceof TileSeismicMarker) || i <= 0) continue;
            return marker.m_58899_();
        }
        return null;
    }

    private void collectMarkers() {
        block3: {
            ItemStack input;
            block2: {
                ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
                input = (ItemStack)inv.getOutputContents().get(0);
                if (!input.m_41619_()) break block2;
                inv.m_6836_(0, new ItemStack((ItemLike)ElectrodynamicsItems.ITEM_SEISMICMARKER.get(), ((List)this.markerLocs.getValue()).size()).m_41777_());
                for (BlockPos pos : (List)this.markerLocs.getValue()) {
                    this.m_58904_().m_46597_(pos, Blocks.f_50016_.m_49966_());
                }
                break block3;
            }
            if (!ItemUtils.testItems((Item)input.m_41720_(), (Item[])new Item[]{(Item)ElectrodynamicsItems.ITEM_SEISMICMARKER.get()})) break block3;
            int room = input.m_41741_() - input.m_41613_();
            int accepted = Math.min(room, ((List)this.markerLocs.getValue()).size());
            input.m_41769_(accepted);
            for (BlockPos pos : (List)this.markerLocs.getValue()) {
                this.m_58904_().m_46597_(pos, Blocks.f_50016_.m_49966_());
            }
        }
    }

    public boolean hasMarkers() {
        return ((List)this.markerLocs.getValue()).size() > 3;
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128379_("onRight", this.cornerOnRight);
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.cornerOnRight = compound.m_128471_("onRight");
    }
}

