/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.pipelines.fluid;

import electrodynamics.common.inventory.container.tile.ContainerFluidPipeFilter;
import electrodynamics.registers.ElectrodynamicsTiles;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.CapabilityUtils;

public class TileFluidPipeFilter
extends GenericTile {
    public static final BlockEntityUtils.MachineDirection INPUT_DIR = BlockEntityUtils.MachineDirection.FRONT;
    public static final BlockEntityUtils.MachineDirection OUTPUT_DIR = BlockEntityUtils.MachineDirection.BACK;
    private boolean isLocked = false;
    public final SingleProperty[] filteredFluids = new SingleProperty[]{(SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.FLUID_STACK, "fluidone", (Object)FluidStack.EMPTY)), (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.FLUID_STACK, "fluidtwo", (Object)FluidStack.EMPTY)), (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.FLUID_STACK, "fluidthree", (Object)FluidStack.EMPTY)), (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.FLUID_STACK, "fluidfour", (Object)FluidStack.EMPTY))};
    public final SingleProperty<Boolean> isWhitelist = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.BOOLEAN, "iswhitelist", (Object)false));

    public TileFluidPipeFilter(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_FLUIDPIPEFILTER.get(), worldPos, blockState);
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentContainerProvider("fluidpipefilter", (GenericTile)this).createMenu((id, inv) -> new ContainerFluidPipeFilter((int)id, (Inventory)inv, (ContainerData)this.getCoordsArray())));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap != ForgeCapabilities.FLUID_HANDLER || side == null || this.isLocked) {
            return LazyOptional.empty();
        }
        Direction facing = this.getFacing();
        if (side == BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)TileFluidPipeFilter.OUTPUT_DIR.mappedDir)) {
            return LazyOptional.of(() -> CapabilityUtils.EMPTY_FLUID).cast();
        }
        if (side == BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)TileFluidPipeFilter.INPUT_DIR.mappedDir)) {
            BlockEntity output = this.f_58857_.m_7702_(this.m_58899_().m_121945_(side.m_122424_()));
            if (output == null) {
                return LazyOptional.of(() -> CapabilityUtils.EMPTY_FLUID).cast();
            }
            this.isLocked = true;
            IFluidHandler fluid = (IFluidHandler)output.getCapability(ForgeCapabilities.FLUID_HANDLER, side).orElse((Object)CapabilityUtils.EMPTY_FLUID);
            this.isLocked = false;
            return fluid == CapabilityUtils.EMPTY_FLUID ? LazyOptional.of(() -> CapabilityUtils.EMPTY_FLUID).cast() : LazyOptional.of(() -> new FilteredFluidCap(fluid, this.getFilteredFluids(), (Boolean)this.isWhitelist.getValue())).cast();
        }
        return LazyOptional.empty();
    }

    private List<Fluid> getFilteredFluids() {
        ArrayList<Fluid> fluids = new ArrayList<Fluid>();
        for (SingleProperty prop : this.filteredFluids) {
            if (((FluidStack)prop.getValue()).isEmpty()) continue;
            fluids.add(((FluidStack)prop.getValue()).getFluid());
        }
        return fluids;
    }

    private class FilteredFluidCap
    implements IFluidHandler {
        private final IFluidHandler outputCap;
        private final List<Fluid> validFluids;
        private final boolean whitelist;

        private FilteredFluidCap(IFluidHandler outputCap, List<Fluid> validFluids, boolean whitelist) {
            this.outputCap = outputCap;
            this.validFluids = validFluids;
            this.whitelist = whitelist;
        }

        public int getTanks() {
            if (TileFluidPipeFilter.this.isLocked) {
                return 0;
            }
            TileFluidPipeFilter.this.isLocked = true;
            int count = this.outputCap.getTanks();
            TileFluidPipeFilter.this.isLocked = false;
            return count;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            if (TileFluidPipeFilter.this.isLocked) {
                return FluidStack.EMPTY;
            }
            TileFluidPipeFilter.this.isLocked = true;
            FluidStack stack = this.outputCap.getFluidInTank(tank);
            TileFluidPipeFilter.this.isLocked = false;
            return stack;
        }

        public int getTankCapacity(int tank) {
            if (TileFluidPipeFilter.this.isLocked) {
                return 0;
            }
            TileFluidPipeFilter.this.isLocked = true;
            int cap = this.outputCap.getTankCapacity(tank);
            TileFluidPipeFilter.this.isLocked = false;
            return cap;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            if (TileFluidPipeFilter.this.isLocked) {
                return false;
            }
            if (this.whitelist) {
                if (this.validFluids.isEmpty()) {
                    return false;
                }
                if (this.validFluids.contains(stack.getFluid())) {
                    TileFluidPipeFilter.this.isLocked = true;
                    boolean valid = this.outputCap.isFluidValid(tank, stack);
                    TileFluidPipeFilter.this.isLocked = false;
                    return valid;
                }
                return false;
            }
            if (this.validFluids.isEmpty() || !this.validFluids.contains(stack.getFluid())) {
                TileFluidPipeFilter.this.isLocked = true;
                boolean valid = this.outputCap.isFluidValid(tank, stack);
                TileFluidPipeFilter.this.isLocked = false;
                return valid;
            }
            return false;
        }

        public int fill(FluidStack stack, IFluidHandler.FluidAction action) {
            if (TileFluidPipeFilter.this.isLocked) {
                return 0;
            }
            if (this.isFluidValid(this.getTanks(), stack)) {
                TileFluidPipeFilter.this.isLocked = true;
                int fill = this.outputCap.fill(stack, action);
                TileFluidPipeFilter.this.isLocked = false;
                return fill;
            }
            return 0;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            TileFluidPipeFilter.this.isLocked = true;
            FluidStack drain = this.outputCap.drain(resource, action);
            TileFluidPipeFilter.this.isLocked = false;
            return drain;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            TileFluidPipeFilter.this.isLocked = true;
            FluidStack drain = this.outputCap.drain(maxDrain, action);
            TileFluidPipeFilter.this.isLocked = false;
            return drain;
        }
    }
}

