/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.pipelines.fluid;

import electrodynamics.common.inventory.container.tile.ContainerFluidPipePump;
import electrodynamics.common.network.type.FluidNetwork;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.common.tile.pipelines.fluid.TileFluidPipe;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import voltaic.prefab.properties.types.PropertyTypes;
import voltaic.prefab.properties.variant.AbstractProperty;
import voltaic.prefab.properties.variant.SingleProperty;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.CapabilityUtils;

public class TileFluidPipePump
extends GenericTile {
    public static final BlockEntityUtils.MachineDirection INPUT_DIR = BlockEntityUtils.MachineDirection.FRONT;
    public static final BlockEntityUtils.MachineDirection OUTPUT_DIR = BlockEntityUtils.MachineDirection.BACK;
    private boolean isLocked = false;
    public final SingleProperty<Integer> priority = (SingleProperty)this.property((AbstractProperty)new SingleProperty(PropertyTypes.INTEGER, "pumppriority", (Object)0).onChange((prop, oldval) -> {
        TileFluidPipe pipe;
        FluidNetwork network;
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        BlockEntity entity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(this.getFacing()));
        if (entity != null && entity instanceof TileFluidPipe && (network = (FluidNetwork)(pipe = (TileFluidPipe)entity).getNetwork()) != null) {
            network.updateFluidPipePumpStats(this, (Integer)prop.getValue(), (int)oldval);
        }
    }));

    public TileFluidPipePump(BlockPos pos, BlockState state) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_FLUIDPIPEPUMP.get(), pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).voltage(120.0).maxJoules(ElectroConstants.PIPE_PUMP_USAGE_PER_TICK * 10.0).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.LEFT}));
        this.addComponent((IComponent)new ComponentContainerProvider("fluidpipepump", (GenericTile)this).createMenu((id, inv) -> new ContainerFluidPipePump((int)id, (Inventory)inv, (ContainerData)this.getCoordsArray())));
    }

    public void tickServer(ComponentTickable tick) {
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        electro.joules(Math.max(electro.getJoulesStored() - ElectroConstants.PIPE_PUMP_USAGE_PER_TICK, 0.0));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap != ForgeCapabilities.FLUID_HANDLER || side == null || this.isLocked) {
            return super.getCapability(cap, side);
        }
        Direction facing = this.getFacing();
        if (side == BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)TileFluidPipePump.OUTPUT_DIR.mappedDir)) {
            return LazyOptional.of(() -> CapabilityUtils.EMPTY_FLUID).cast();
        }
        if (side == BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)TileFluidPipePump.INPUT_DIR.mappedDir)) {
            BlockEntity output = this.f_58857_.m_7702_(this.f_58858_.m_121945_(side.m_122424_()));
            if (output == null) {
                return LazyOptional.of(() -> CapabilityUtils.EMPTY_FLUID).cast();
            }
            this.isLocked = true;
            IFluidHandler fluid = (IFluidHandler)output.getCapability(ForgeCapabilities.FLUID_HANDLER, side).orElse((Object)CapabilityUtils.EMPTY_FLUID);
            this.isLocked = false;
            return fluid == CapabilityUtils.EMPTY_FLUID ? LazyOptional.of(() -> CapabilityUtils.EMPTY_FLUID).cast() : LazyOptional.of(() -> fluid).cast();
        }
        return LazyOptional.empty();
    }

    public boolean isPowered() {
        return ((ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic)).getJoulesStored() >= ElectroConstants.PIPE_PUMP_USAGE_PER_TICK;
    }
}

