/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.pipelines.fluid;

import electrodynamics.common.tile.pipelines.GenericTileValve;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.CapabilityUtils;

public class TileFluidValve
extends GenericTileValve {
    private boolean isLocked = false;

    public TileFluidValve(BlockPos pos, BlockState state) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_FLUIDVALVE.get(), pos, state);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap != ForgeCapabilities.FLUID_HANDLER || side == null || this.isLocked) {
            return LazyOptional.empty();
        }
        Direction facing = this.getFacing();
        if (BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)TileFluidValve.INPUT_DIR.mappedDir) == side || BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)TileFluidValve.OUTPUT_DIR.mappedDir) == side) {
            BlockEntity relative = this.f_58857_.m_7702_(this.f_58858_.m_121945_(side.m_122424_()));
            if (relative == null) {
                return LazyOptional.of(() -> CapabilityUtils.EMPTY_FLUID).cast();
            }
            this.isLocked = true;
            IFluidHandler fluid = (IFluidHandler)relative.getCapability(ForgeCapabilities.FLUID_HANDLER, side).orElse((Object)CapabilityUtils.EMPTY_FLUID);
            this.isLocked = false;
            return fluid == CapabilityUtils.EMPTY_FLUID ? LazyOptional.of(() -> CapabilityUtils.EMPTY_FLUID).cast() : LazyOptional.of(() -> new CapDispatcher(fluid)).cast();
        }
        return LazyOptional.empty();
    }

    private class CapDispatcher
    implements IFluidHandler {
        private final IFluidHandler parent;

        private CapDispatcher(IFluidHandler parent) {
            this.parent = parent;
        }

        public int getTanks() {
            if (TileFluidValve.this.isClosed || TileFluidValve.this.isLocked) {
                return 1;
            }
            TileFluidValve.this.isLocked = true;
            int tanks = this.parent.getTanks();
            TileFluidValve.this.isLocked = false;
            return tanks;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            if (TileFluidValve.this.isClosed || TileFluidValve.this.isLocked) {
                return FluidStack.EMPTY;
            }
            TileFluidValve.this.isLocked = true;
            FluidStack stack = this.parent.getFluidInTank(tank);
            TileFluidValve.this.isLocked = false;
            return stack;
        }

        public int getTankCapacity(int tank) {
            if (TileFluidValve.this.isClosed || TileFluidValve.this.isLocked) {
                return 0;
            }
            TileFluidValve.this.isLocked = true;
            int cap = this.parent.getTankCapacity(tank);
            TileFluidValve.this.isLocked = false;
            return cap;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            if (TileFluidValve.this.isClosed || TileFluidValve.this.isLocked) {
                return false;
            }
            TileFluidValve.this.isLocked = true;
            boolean valid = this.parent.isFluidValid(tank, stack);
            TileFluidValve.this.isLocked = false;
            return valid;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (TileFluidValve.this.isClosed || TileFluidValve.this.isLocked) {
                return 0;
            }
            TileFluidValve.this.isLocked = true;
            int fill = this.parent.fill(resource, action);
            TileFluidValve.this.isLocked = false;
            return fill;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (TileFluidValve.this.isClosed || TileFluidValve.this.isLocked) {
                return FluidStack.EMPTY;
            }
            TileFluidValve.this.isLocked = true;
            FluidStack drain = this.parent.drain(resource, action);
            TileFluidValve.this.isLocked = false;
            return drain;
        }

        @NotNull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (TileFluidValve.this.isClosed || TileFluidValve.this.isLocked) {
                return FluidStack.EMPTY;
            }
            TileFluidValve.this.isLocked = true;
            FluidStack drain = this.parent.drain(maxDrain, action);
            TileFluidValve.this.isLocked = false;
            return drain;
        }
    }
}

