/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.pipelines.fluid.tank;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerFluidTankGeneric;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import voltaic.common.network.utils.FluidUtilities;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentFluidHandlerSimple;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.tile.types.GenericMaterialTile;
import voltaic.prefab.utilities.BlockEntityUtils;

public class GenericTileFluidTank
extends GenericMaterialTile {
    public GenericTileFluidTank(BlockEntityType<?> tile, int capacity, SubtypeMachine machine, BlockPos pos, BlockState state) {
        super(tile, pos, state);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentFluidHandlerSimple(capacity, (GenericTile)this, "").setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.TOP}).setOutputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().bucketInputs(1).bucketOutputs(1)).valid(GenericTileFluidTank.machineValidator()));
        this.addComponent((IComponent)new ComponentContainerProvider(machine.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerFluidTankGeneric((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    public void tickServer(ComponentTickable tick) {
        ComponentFluidHandlerSimple handler = (ComponentFluidHandlerSimple)this.getComponent(IComponentType.FluidHandler);
        FluidUtilities.drainItem((GenericTile)this, (FluidTank[])handler.toArray());
        FluidUtilities.fillItem((GenericTile)this, (FluidTank[])handler.toArray());
        FluidUtilities.outputToPipe((GenericTile)this, (FluidTank[])handler.toArray(), (Direction[])handler.outputDirections);
        BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_7495_());
        if (blockEntity instanceof GenericTileFluidTank) {
            GenericTileFluidTank tankBelow = (GenericTileFluidTank)blockEntity;
            ComponentFluidHandlerSimple belowHandler = (ComponentFluidHandlerSimple)tankBelow.getComponent(IComponentType.FluidHandler);
            handler.drain(belowHandler.fill(handler.getFluid(), IFluidHandler.FluidAction.EXECUTE), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    public int getComparatorSignal() {
        ComponentFluidHandlerSimple handler = (ComponentFluidHandlerSimple)this.getComponent(IComponentType.FluidHandler);
        return (int)((double)handler.getFluidAmount() / (double)Math.max(1, handler.getCapacity()) * 15.0);
    }
}

