/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.pipelines.gas;

import electrodynamics.common.block.subtype.SubtypeMachine;
import electrodynamics.common.inventory.container.tile.ContainerCreativeGasSource;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.IGasHandler;
import voltaic.api.gas.IGasHandlerItem;
import voltaic.api.gas.PropertyGasTank;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentGasHandlerSimple;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentPacketHandler;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.registers.VoltaicCapabilities;

public class TileCreativeGasSource
extends GenericTile {
    public TileCreativeGasSource(BlockPos worldPos, BlockState blockState) {
        super((BlockEntityType)ElectrodynamicsTiles.TILE_CREATIVEGASSOURCE.get(), worldPos, blockState);
        this.addComponent((IComponent)new ComponentTickable((GenericTile)this).tickServer(this::tickServer));
        this.addComponent((IComponent)new ComponentPacketHandler((GenericTile)this));
        this.addComponent((IComponent)new ComponentGasHandlerSimple((GenericTile)this, "", 128000, 1000000, 1000000).setOutputDirections(BlockEntityUtils.MachineDirection.values()));
        this.addComponent((IComponent)new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().gasInputs(1).gasOutputs(1)).valid((slot, stack, i) -> stack.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM) != null));
        this.addComponent((IComponent)new ComponentContainerProvider(SubtypeMachine.creativegassource.tag(), (GenericTile)this).createMenu((id, player) -> new ContainerCreativeGasSource((int)id, (Inventory)player, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray())));
    }

    private void tickServer(ComponentTickable tick) {
        IGasHandlerItem handler;
        ComponentGasHandlerSimple simple = (ComponentGasHandlerSimple)this.getComponent(IComponentType.GasHandler);
        ComponentInventory inv = (ComponentInventory)this.getComponent(IComponentType.Inventory);
        ItemStack input = inv.m_8020_(0);
        ItemStack output = inv.m_8020_(1);
        simple.setGas(new GasStack(simple.getGas().getGas(), simple.getCapacity(), simple.getGas().getTemperature(), simple.getGas().getPressure()));
        if (!input.m_41619_() && (handler = (IGasHandlerItem)input.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_GAS_ITEM)) != CapabilityUtils.EMPTY_GAS_ITEM) {
            GasStack contained = handler.drain(Integer.MAX_VALUE, GasAction.SIMULATE);
            simple.setGas(new GasStack(contained.getGas(), simple.getCapacity(), contained.getTemperature(), contained.getPressure()));
        }
        if (!output.m_41619_() && (handler = (IGasHandlerItem)output.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_GAS_ITEM)) != CapabilityUtils.EMPTY_GAS_ITEM) {
            handler.fill(simple.getGas().copy(), GasAction.EXECUTE);
            inv.m_6836_(1, handler.getContainer());
        }
        Direction facing = this.getFacing();
        for (Direction relative : simple.outputDirections) {
            IGasHandler handler2;
            Direction direction = BlockEntityUtils.getRelativeSide((Direction)facing, (Direction)relative.m_122424_());
            BlockPos face = this.m_58899_().m_121945_(direction.m_122424_());
            BlockEntity faceTile = this.m_58904_().m_7702_(face);
            if (faceTile == null || (handler2 = (IGasHandler)faceTile.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_BLOCK, direction).orElse((Object)CapabilityUtils.EMPTY_GAS)) == CapabilityUtils.EMPTY_GAS) continue;
            for (PropertyGasTank gasTank : simple.asArray()) {
                GasStack tankGas = gasTank.getGas();
                handler2.fill(tankGas, GasAction.EXECUTE);
            }
        }
    }
}

