/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.pipelines.gas.gastransformer.compressor;

import electrodynamics.common.inventory.container.tile.ContainerCompressor;
import electrodynamics.common.inventory.container.tile.ContainerDecompressor;
import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.common.tile.pipelines.gas.gastransformer.IAddonTankManager;
import electrodynamics.common.tile.pipelines.gas.gastransformer.TileGasTransformerAddonTank;
import electrodynamics.common.tile.pipelines.gas.gastransformer.compressor.GenericTileCompressor;
import electrodynamics.registers.ElectrodynamicsBlocks;
import electrodynamics.registers.ElectrodynamicsSounds;
import electrodynamics.registers.ElectrodynamicsTiles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentContainerProvider;
import voltaic.prefab.tile.components.type.ComponentGasHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public abstract class GenericTileBasicCompressor
extends GenericTileCompressor
implements IAddonTankManager {
    public GenericTileBasicCompressor(BlockEntityType<?> type, BlockPos worldPos, BlockState blockState) {
        super(type, worldPos, blockState);
    }

    @Override
    public void tickClient(ComponentTickable tickable) {
        super.tickClient(tickable);
        if (this.f_58857_.m_213780_().m_188500_() < 0.15) {
            // empty if block
        }
    }

    @Override
    public void updateTankCount() {
        BlockEntity aboveTile;
        BlockPos abovePos = this.m_58899_().m_7494_();
        BlockState aboveState = this.m_58904_().m_8055_(abovePos);
        int tankCount = 0;
        for (int i = 0; i < ElectroConstants.GAS_TRANSFORMER_ADDON_TANK_LIMIT && aboveState.m_60713_((Block)ElectrodynamicsBlocks.BLOCK_COMPRESSOR_ADDONTANK.get()) && (aboveTile = this.m_58904_().m_7702_(abovePos)) != null && aboveTile instanceof TileGasTransformerAddonTank; ++i) {
            TileGasTransformerAddonTank tank = (TileGasTransformerAddonTank)aboveTile;
            abovePos = abovePos.m_7494_();
            aboveState = this.m_58904_().m_8055_(abovePos);
            tank.setOwnerPos(this.m_58899_());
            ++tankCount;
        }
        ComponentGasHandlerMulti handler = (ComponentGasHandlerMulti)this.getComponent(IComponentType.GasHandler);
        handler.getInputTanks()[0].setCapacity(ElectroConstants.GAS_TRANSFORMER_BASE_INPUT_CAPCITY + ElectroConstants.GAS_TRANSFORMER_ADDON_TANK_CAPCITY * tankCount);
        handler.getOutputTanks()[0].setCapacity(ElectroConstants.GAS_TRANSFORMER_BASE_OUTPUT_CAPCITY + ElectroConstants.GAS_TRANSFORMER_ADDON_TANK_CAPCITY * tankCount);
    }

    @Override
    public void outputToPipe(ComponentProcessor processor, ComponentGasHandlerMulti multi, Direction facing) {
        processor.outputToGasPipe();
    }

    @Override
    public void updateLit(boolean isHeating, Direction facing) {
        if (BlockEntityUtils.isLit((GenericTile)this) ^ isHeating) {
            BlockEntityUtils.updateLit((GenericTile)this, (Boolean)isHeating);
        }
    }

    public static class TileDecompressor
    extends GenericTileBasicCompressor {
        public TileDecompressor(BlockPos worldPos, BlockState blockState) {
            super((BlockEntityType)ElectrodynamicsTiles.TILE_DECOMPRESSOR.get(), worldPos, blockState);
        }

        @Override
        public double getPressureMultiplier() {
            return 0.5;
        }

        @Override
        public SoundEvent getSound() {
            return (SoundEvent)ElectrodynamicsSounds.SOUND_DECOMPRESSORRUNNING.get();
        }

        @Override
        public ComponentContainerProvider getContainerProvider() {
            return new ComponentContainerProvider("container.decompressor", (GenericTile)this).createMenu((id, inv) -> new ContainerDecompressor((int)id, (Inventory)inv, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray()));
        }

        @Override
        public double getUsagePerTick() {
            return ElectroConstants.DECOMPRESSOR_USAGE_PER_TICK;
        }

        @Override
        public int getConversionRate() {
            return ElectroConstants.DECOMPRESSOR_CONVERSION_RATE;
        }
    }

    public static class TileCompressor
    extends GenericTileBasicCompressor {
        public TileCompressor(BlockPos worldPos, BlockState blockState) {
            super((BlockEntityType)ElectrodynamicsTiles.TILE_COMPRESSOR.get(), worldPos, blockState);
        }

        @Override
        public double getPressureMultiplier() {
            return 2.0;
        }

        @Override
        public SoundEvent getSound() {
            return (SoundEvent)ElectrodynamicsSounds.SOUND_COMPRESSORRUNNING.get();
        }

        @Override
        public ComponentContainerProvider getContainerProvider() {
            return new ComponentContainerProvider("container.compressor", (GenericTile)this).createMenu((id, inv) -> new ContainerCompressor((int)id, (Inventory)inv, (Container)this.getComponent(IComponentType.Inventory), (ContainerData)this.getCoordsArray()));
        }

        @Override
        public double getUsagePerTick() {
            return ElectroConstants.COMPRESSOR_USAGE_PER_TICK;
        }

        @Override
        public int getConversionRate() {
            return ElectroConstants.COMPRESSOR_CONVERSION_RATE;
        }
    }
}

