/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.tile.pipelines.gas.gastransformer.compressor;

import electrodynamics.common.inventory.container.tile.ContainerCompressor;
import electrodynamics.common.tile.pipelines.gas.gastransformer.GenericTileGasTransformer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.PropertyGasTank;
import voltaic.prefab.sound.SoundBarrierMethods;
import voltaic.prefab.tile.GenericTile;
import voltaic.prefab.tile.components.IComponent;
import voltaic.prefab.tile.components.IComponentType;
import voltaic.prefab.tile.components.type.ComponentElectrodynamic;
import voltaic.prefab.tile.components.type.ComponentGasHandlerMulti;
import voltaic.prefab.tile.components.type.ComponentInventory;
import voltaic.prefab.tile.components.type.ComponentProcessor;
import voltaic.prefab.tile.components.type.ComponentTickable;
import voltaic.prefab.utilities.BlockEntityUtils;

public abstract class GenericTileCompressor
extends GenericTileGasTransformer {
    public GenericTileCompressor(BlockEntityType<?> type, BlockPos worldPos, BlockState blockState) {
        super(type, worldPos, blockState);
        this.addComponent((IComponent)new ComponentElectrodynamic((GenericTile)this, false, true).setInputDirections(new BlockEntityUtils.MachineDirection[]{BlockEntityUtils.MachineDirection.BOTTOM}).voltage(120.0).maxJoules(this.getUsagePerTick() * 10.0));
    }

    @Override
    public void tickClient(ComponentTickable tickable) {
        if (!this.isSoundPlaying && this.shouldPlaySound()) {
            this.isSoundPlaying = true;
            SoundBarrierMethods.playTileSound((SoundEvent)this.getSound(), (BlockEntity)this, (boolean)true);
        }
    }

    @Override
    public boolean canProcess(ComponentProcessor processor, int procNumber) {
        ComponentGasHandlerMulti gasHandler = (ComponentGasHandlerMulti)this.getComponent(IComponentType.GasHandler);
        processor.consumeGasCylinder();
        processor.dispenseGasCylinder();
        Direction facing = this.getFacing();
        this.outputToPipe(processor, gasHandler, facing);
        boolean canProcess = this.checkConditions(processor);
        this.updateLit(canProcess, facing);
        return canProcess;
    }

    private boolean checkConditions(ComponentProcessor processor) {
        ComponentGasHandlerMulti gasHandler = (ComponentGasHandlerMulti)this.getComponent(IComponentType.GasHandler);
        PropertyGasTank inputTank = gasHandler.getInputTanks()[0];
        PropertyGasTank outputTank = gasHandler.getOutputTanks()[0];
        if (inputTank.isEmpty()) {
            return false;
        }
        ComponentElectrodynamic electro = (ComponentElectrodynamic)this.getComponent(IComponentType.Electrodynamic);
        if (electro.getJoulesStored() < this.getUsagePerTick() * (Double)processor.operatingSpeed.getValue()) {
            return false;
        }
        if (outputTank.getGasAmount() >= outputTank.getCapacity()) {
            return false;
        }
        if (!outputTank.isEmpty() && !outputTank.getGas().isSameGas(inputTank.getGas())) {
            return false;
        }
        return !(this.getPressureMultiplier() < 1.0) || inputTank.getGas().getPressure() > 1;
    }

    @Override
    public void process(ComponentProcessor processor, int procNumber) {
        int conversionRate = (int)((double)this.getConversionRate() * (Double)processor.operatingSpeed.getValue());
        ComponentGasHandlerMulti gasHandler = (ComponentGasHandlerMulti)this.getComponent(IComponentType.GasHandler);
        PropertyGasTank inputTank = gasHandler.getInputTanks()[0];
        PropertyGasTank outputTank = gasHandler.getOutputTanks()[0];
        int currPressure = inputTank.getGas().getPressure();
        int newPressure = (int)((double)currPressure * this.getPressureMultiplier());
        GasStack toTake = new GasStack(inputTank.getGas().getGas(), Math.min(conversionRate, inputTank.getGasAmount()), inputTank.getGas().getTemperature(), inputTank.getGas().getPressure());
        toTake.bringPressureTo(newPressure);
        int taken = outputTank.fill(toTake.copy(), GasAction.EXECUTE);
        if (taken == 0) {
            return;
        }
        toTake.setAmount(taken);
        toTake.bringPressureTo(currPressure);
        inputTank.drain(toTake.getAmount(), GasAction.EXECUTE);
    }

    @Override
    public ComponentInventory getInventory() {
        return new ComponentInventory((GenericTile)this, ComponentInventory.InventoryBuilder.newInv().gasInputs(1).gasOutputs(1).upgrades(3)).valid(GenericTileCompressor.machineValidator()).validUpgrades(ContainerCompressor.VALID_UPGRADES);
    }

    public abstract double getPressureMultiplier();

    public abstract void outputToPipe(ComponentProcessor var1, ComponentGasHandlerMulti var2, Direction var3);

    public abstract void updateLit(boolean var1, Direction var2);

    public abstract SoundEvent getSound();
}

