/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.common.world.ruletests;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import electrodynamics.common.block.BlockOre;
import electrodynamics.common.block.subtype.SubtypeOre;
import electrodynamics.common.block.subtype.SubtypeOreDeepslate;
import electrodynamics.common.settings.OreConfig;
import electrodynamics.registers.ElectrodynamicsBlocks;
import electrodynamics.registers.ElectrodynamicsRuleTestTypes;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTestType;

public class RuleTestOre
extends RuleTest {
    @Nullable
    private final SubtypeOre thisOre;
    @Nullable
    private final SubtypeOreDeepslate thisDeepOre;
    private final TagKey<Block> canSpawnIn;
    public static final Codec<RuleTestOre> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_256975_.m_194605_().fieldOf("block").forGetter(instance0 -> {
        if (instance0.thisOre != null) {
            return (Block)ElectrodynamicsBlocks.BLOCKS_ORE.getValue((Object)instance0.thisOre);
        }
        if (instance0.thisDeepOre != null) {
            return (Block)ElectrodynamicsBlocks.BLOCKS_DEEPSLATEORE.getValue((Object)instance0.thisDeepOre);
        }
        return Blocks.f_50016_;
    }), (App)TagKey.m_203877_((ResourceKey)Registries.f_256747_).fieldOf("canspawnintag").forGetter(instance0 -> instance0.canSpawnIn)).apply((Applicative)instance, (block, tag) -> {
        if (block instanceof BlockOre) {
            BlockOre ore = (BlockOre)((Object)((Object)block));
            return new RuleTestOre(ore.ore, ore.deepOre, (TagKey<Block>)tag);
        }
        return new RuleTestOre(null, null, (TagKey<Block>)tag);
    }));

    public RuleTestOre(SubtypeOre thisOre, SubtypeOreDeepslate thisDeepOre, TagKey<Block> canSpawnIn) {
        this.thisOre = thisOre;
        this.thisDeepOre = thisDeepOre;
        this.canSpawnIn = canSpawnIn;
    }

    public boolean m_213865_(BlockState state, RandomSource random) {
        return this.isEnabled() && state.m_204336_(this.canSpawnIn);
    }

    private boolean isEnabled() {
        if (OreConfig.DISABLE_ALL_ORES) {
            return false;
        }
        if (this.thisOre != null) {
            if (OreConfig.DISABLE_STONE_ORES) {
                return false;
            }
            return switch (this.thisOre) {
                case SubtypeOre.aluminum -> OreConfig.SPAWN_ALUMINUM_ORE;
                case SubtypeOre.chromium -> OreConfig.SPAWN_CHROMIUM_ORE;
                case SubtypeOre.fluorite -> OreConfig.SPAWN_FLUORITE_ORE;
                case SubtypeOre.lead -> OreConfig.SPAWN_LEAD_ORE;
                case SubtypeOre.lithium -> OreConfig.SPAWN_LITHIUM_ORE;
                case SubtypeOre.molybdenum -> OreConfig.SPAWN_MOLYBDENUM_ORE;
                case SubtypeOre.monazite -> OreConfig.SPAWN_MONAZITE_ORE;
                case SubtypeOre.niter -> OreConfig.SPAWN_NITER_ORE;
                case SubtypeOre.salt -> OreConfig.SPAWN_SALT_ORE;
                case SubtypeOre.silver -> OreConfig.SPAWN_SILVER_ORE;
                case SubtypeOre.sulfur -> OreConfig.SPAWN_SULFUR_ORE;
                case SubtypeOre.sylvite -> OreConfig.SPAWN_SYLVITE_ORE;
                case SubtypeOre.thorium -> OreConfig.SPAWN_THORIUM_ORE;
                case SubtypeOre.tin -> OreConfig.SPAWN_TIN_ORE;
                case SubtypeOre.titanium -> OreConfig.SPAWN_TITANIUM_ORE;
                case SubtypeOre.uranium -> OreConfig.SPAWN_URANIUM_ORE;
                case SubtypeOre.vanadium -> OreConfig.SPAWN_VANADIUM_ORE;
                default -> false;
            };
        }
        if (this.thisDeepOre != null) {
            if (OreConfig.DISABLE_DEEPSLATE_ORES) {
                return false;
            }
            return switch (this.thisDeepOre) {
                case SubtypeOreDeepslate.aluminum -> OreConfig.SPAWN_DEEP_ALUMINUM_ORE;
                case SubtypeOreDeepslate.chromium -> OreConfig.SPAWN_DEEP_CHROMIUM_ORE;
                case SubtypeOreDeepslate.fluorite -> OreConfig.SPAWN_DEEP_FLUORITE_ORE;
                case SubtypeOreDeepslate.lead -> OreConfig.SPAWN_DEEP_LEAD_ORE;
                case SubtypeOreDeepslate.lithium -> OreConfig.SPAWN_DEEP_LITHIUM_ORE;
                case SubtypeOreDeepslate.molybdenum -> OreConfig.SPAWN_DEEP_MOLYBDENUM_ORE;
                case SubtypeOreDeepslate.monazite -> OreConfig.SPAWN_DEEP_MONAZITE_ORE;
                case SubtypeOreDeepslate.niter -> OreConfig.SPAWN_DEEP_NITER_ORE;
                case SubtypeOreDeepslate.salt -> OreConfig.SPAWN_DEEP_SALT_ORE;
                case SubtypeOreDeepslate.silver -> OreConfig.SPAWN_DEEP_SILVER_ORE;
                case SubtypeOreDeepslate.sulfur -> OreConfig.SPAWN_DEEP_SULFUR_ORE;
                case SubtypeOreDeepslate.sylvite -> OreConfig.SPAWN_DEEP_SYLVITE_ORE;
                case SubtypeOreDeepslate.thorium -> OreConfig.SPAWN_DEEP_THORIUM_ORE;
                case SubtypeOreDeepslate.tin -> OreConfig.SPAWN_DEEP_TIN_ORE;
                case SubtypeOreDeepslate.titanium -> OreConfig.SPAWN_DEEP_TITANIUM_ORE;
                case SubtypeOreDeepslate.uranium -> OreConfig.SPAWN_DEEP_URANIUM_ORE;
                case SubtypeOreDeepslate.vanadium -> OreConfig.SPAWN_DEEP_VANADIUM_ORE;
                default -> false;
            };
        }
        return false;
    }

    protected RuleTestType<?> m_7319_() {
        return (RuleTestType)ElectrodynamicsRuleTestTypes.TEST_CONFIG_ORESPAWN.get();
    }
}

