/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.compatibility.jei.recipecategories.thermomanipulator;

import electrodynamics.common.settings.ElectroConstants;
import electrodynamics.compatibility.jei.recipecategories.utils.psuedorecipes.types.PsuedoGas2FluidRecipe;
import electrodynamics.prefab.utilities.ElectroTextUtils;
import electrodynamics.registers.ElectrodynamicsBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fluids.FluidStack;
import voltaic.api.electricity.formatting.ChatFormatter;
import voltaic.api.electricity.formatting.DisplayUnits;
import voltaic.api.electricity.formatting.IDisplayUnit;
import voltaic.api.gas.GasStack;
import voltaic.api.screen.ITexture;
import voltaic.common.recipe.recipeutils.GasIngredient;
import voltaic.compatibility.jei.recipecategories.AbstractRecipeCategory;
import voltaic.compatibility.jei.utils.gui.JeiTextures;
import voltaic.compatibility.jei.utils.gui.ScreenObject;
import voltaic.compatibility.jei.utils.gui.types.BackgroundObject;
import voltaic.compatibility.jei.utils.gui.types.fluidgauge.AbstractFluidGaugeObject;
import voltaic.compatibility.jei.utils.gui.types.fluidgauge.FluidGaugeObject;
import voltaic.compatibility.jei.utils.gui.types.gasgauge.AbstractGasGaugeObject;
import voltaic.compatibility.jei.utils.gui.types.gasgauge.GasGaugeObject;
import voltaic.compatibility.jei.utils.label.AbstractLabelWrapper;
import voltaic.compatibility.jei.utils.label.types.PowerLabelWrapperConstant;
import voltaic.prefab.utilities.math.Color;

public class CondensingGasRecipeCategory
extends AbstractRecipeCategory<PsuedoGas2FluidRecipe> {
    private static final BackgroundObject BACK_WRAP = new BackgroundObject(132, 70);
    private static final ScreenObject CONDENSER_COLUMN = new ScreenObject((ITexture)ITexture.Textures.CONDENSER_COLUMN, 50, 6);
    private static final ScreenObject IN_FLUID_GAUGE = new ScreenObject((ITexture)JeiTextures.FLUID_GAUGE_DEFAULT, 10, 5);
    private static final FluidGaugeObject OUT_FLUID_GAUGE = new FluidGaugeObject(88, 5);
    private static final GasGaugeObject IN_GAS_GAUGE = new GasGaugeObject(30, 5);
    private static final ScreenObject OUT_GAS_GAUGE = new ScreenObject((ITexture)JeiTextures.FAKE_GAS_GAUGE, 108, 5);
    private static final PowerLabelWrapperConstant POWER_LABEL = new PowerLabelWrapperConstant(2, 60, ElectroConstants.THERMOELECTRIC_MANIPULATOR_USAGE_PER_TICK, 120);
    private static final AbstractLabelWrapper TEMPERATURE_LABEL = new AbstractLabelWrapper(Color.JEI_TEXT_GRAY, 60, 130, true){

        public Component getComponent(AbstractRecipeCategory<?> category, Object recipe) {
            PsuedoGas2FluidRecipe psuedo = (PsuedoGas2FluidRecipe)recipe;
            return Component.m_237113_((String)"<= ").m_7220_((Component)ChatFormatter.getChatDisplayShort((double)psuedo.inputs.get(0).getGasStack().getTemperature(), (IDisplayUnit)DisplayUnits.TEMPERATURE_KELVIN));
        }
    };
    private static final int ANIM_TIME = 50;
    public static final String RECIPE_GROUP = "gas_condensing";
    public static ItemStack INPUT_MACHINE = new ItemStack((ItemLike)ElectrodynamicsBlocks.BLOCK_THERMOELECTRICMANIPULATOR.get());
    public static final RecipeType<PsuedoGas2FluidRecipe> RECIPE_TYPE = RecipeType.create((String)"electrodynamics", (String)"gas_condensing", PsuedoGas2FluidRecipe.class);

    public CondensingGasRecipeCategory(IGuiHelper guiHelper) {
        super(guiHelper, (Component)ElectroTextUtils.jeiTranslated(RECIPE_GROUP, new Object[0]), INPUT_MACHINE, BACK_WRAP, RECIPE_TYPE, 50);
        this.setGasInputs(guiHelper, new AbstractGasGaugeObject[]{IN_GAS_GAUGE});
        this.setFluidOutputs(guiHelper, new AbstractFluidGaugeObject[]{OUT_FLUID_GAUGE});
        this.setScreenObjects(guiHelper, new ScreenObject[]{IN_FLUID_GAUGE, OUT_GAS_GAUGE, CONDENSER_COLUMN});
        this.setLabels(new AbstractLabelWrapper[]{POWER_LABEL, TEMPERATURE_LABEL});
    }

    public List<List<GasStack>> getGasInputs(PsuedoGas2FluidRecipe recipe) {
        ArrayList gases = new ArrayList();
        for (GasIngredient ing : recipe.inputs) {
            gases.addAll(ing.getMatchingGases());
        }
        return Arrays.asList(gases);
    }

    public List<FluidStack> getFluidOutputs(PsuedoGas2FluidRecipe recipe) {
        return Arrays.asList(recipe.output);
    }

    public List<List<ItemStack>> getItemInputs(PsuedoGas2FluidRecipe recipe) {
        if (recipe.inputCylinder.m_41619_()) {
            return Collections.emptyList();
        }
        return Arrays.asList(Arrays.asList(recipe.inputCylinder));
    }

    public List<ItemStack> getItemOutputs(PsuedoGas2FluidRecipe recipe) {
        if (recipe.outputBucket.m_41619_()) {
            return Collections.emptyList();
        }
        return Arrays.asList(recipe.outputBucket);
    }
}

