/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.compatibility.jei.recipecategories.utils.psuedorecipes;

import electrodynamics.compatibility.jei.recipecategories.utils.psuedorecipes.types.PsuedoFluid2GasRecipe;
import electrodynamics.compatibility.jei.recipecategories.utils.psuedorecipes.types.PsuedoGas2FluidRecipe;
import electrodynamics.registers.ElectrodynamicsItems;
import java.util.Arrays;
import java.util.HashSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import voltaic.api.gas.Gas;
import voltaic.api.gas.GasAction;
import voltaic.api.gas.GasStack;
import voltaic.api.gas.IGasHandlerItem;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.registers.VoltaicCapabilities;
import voltaic.registers.VoltaicGases;
import voltaic.registers.VoltaicRegistries;

public class ElectrodynamicsPsuedoRecipes {
    public static final HashSet<PsuedoFluid2GasRecipe> EVAPORATION_RECIPES = new HashSet();
    public static final HashSet<PsuedoGas2FluidRecipe> CONDENSATION_RECIPES = new HashSet();

    public static void initRecipes() {
        EVAPORATION_RECIPES.clear();
        CONDENSATION_RECIPES.clear();
        for (Gas gas2 : VoltaicRegistries.gasRegistry().getValues()) {
            if (gas2.isEmpty() || gas2.getCondensedFluid().m_6212_(Fluids.f_76191_)) continue;
            ItemStack inputCylinder = new ItemStack((ItemLike)ElectrodynamicsItems.ITEM_PORTABLECYLINDER.get());
            IGasHandlerItem inputHandler = (IGasHandlerItem)inputCylinder.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_GAS_ITEM);
            inputHandler.fill(new GasStack(gas2, 1000, gas2.getCondensationTemp() + 1, 1), GasAction.EXECUTE);
            ItemStack outputBucket = new ItemStack((ItemLike)gas2.getCondensedFluid().m_6859_());
            IFluidHandlerItem outputHandler = (IFluidHandlerItem)outputBucket.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_FLUID_ITEM);
            if (outputHandler == CapabilityUtils.EMPTY_FLUID_ITEM) continue;
            outputHandler.fill(new FluidStack(gas2.getCondensedFluid(), 1000), IFluidHandler.FluidAction.EXECUTE);
            outputBucket = outputHandler.getContainer();
            CONDENSATION_RECIPES.add(new PsuedoGas2FluidRecipe(Arrays.asList(new GasStack(gas2, 1000, gas2.getCondensationTemp(), 1)), new FluidStack(gas2.getCondensedFluid(), 1000), inputCylinder, outputBucket));
        }
        VoltaicGases.MAPPED_GASSES.forEach((fluid, gas) -> {
            if (fluid.m_6212_(Fluids.f_76191_)) {
                return;
            }
            ItemStack inputBucket = new ItemStack((ItemLike)fluid.m_6859_());
            IFluidHandlerItem inputHandler = (IFluidHandlerItem)inputBucket.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_FLUID_ITEM);
            if (inputHandler != CapabilityUtils.EMPTY_FLUID_ITEM) {
                inputHandler.fill(new FluidStack(fluid, 1000), IFluidHandler.FluidAction.EXECUTE);
                inputBucket = inputHandler.getContainer();
            }
            ItemStack outputCylinder = new ItemStack((ItemLike)ElectrodynamicsItems.ITEM_PORTABLECYLINDER.get());
            IGasHandlerItem outputHandler = (IGasHandlerItem)outputCylinder.getCapability(VoltaicCapabilities.CAPABILITY_GASHANDLER_ITEM).orElse((Object)CapabilityUtils.EMPTY_GAS_ITEM);
            outputHandler.fill(new GasStack(gas, 1000, gas.getCondensationTemp() + 1, 1), GasAction.EXECUTE);
            outputCylinder = outputHandler.getContainer();
            EVAPORATION_RECIPES.add(new PsuedoFluid2GasRecipe(Arrays.asList(new FluidStack(fluid, 1000)), new GasStack(gas, 1000, gas.getCondensationTemp(), 1), inputBucket, outputCylinder));
        });
    }
}

