/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.datagen.server.recipe.types.custom.item2item;

import electrodynamics.common.item.subtype.SubtypeCrystal;
import electrodynamics.common.item.subtype.SubtypeDust;
import electrodynamics.common.item.subtype.SubtypeImpureDust;
import electrodynamics.common.item.subtype.SubtypeIngot;
import electrodynamics.common.item.subtype.SubtypeRawOre;
import electrodynamics.registers.ElectrodynamicsItems;
import electrodynamics.registers.ElectrodynamicsRecipies;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import voltaic.common.recipe.recipeutils.ProbableItem;
import voltaic.common.tags.VoltaicTags;
import voltaic.datagen.utils.server.recipe.AbstractRecipeGenerator;
import voltaic.datagen.utils.server.recipe.FinishedRecipeBase;
import voltaic.datagen.utils.server.recipe.FinishedRecipeItemOutput;

public class ElectrodynamicsMineralGrinderRecipes
extends AbstractRecipeGenerator {
    public static double MINERALGRINDER_USAGE_PER_TICK = 350.0;
    public static int MINERALGRINDER_REQUIRED_TICKS = 200;
    private final String modID;

    public ElectrodynamicsMineralGrinderRecipes(String modID) {
        this.modID = modID;
    }

    public ElectrodynamicsMineralGrinderRecipes() {
        this("electrodynamics");
    }

    public void addRecipes(Consumer<FinishedRecipe> consumer) {
        for (SubtypeIngot subtypeIngot : SubtypeIngot.values()) {
            if (subtypeIngot.grindedDust == null) continue;
            this.newRecipe(new ItemStack((ItemLike)subtypeIngot.grindedDust.get()), 0.0f, 200, 350.0, "dust_" + subtypeIngot.name() + "_from_ingot").addItemTagInput(subtypeIngot.tag, 1).complete(consumer);
        }
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.iron)), 0.0f, 200, 350.0, "dust_iron_from_ingot").addItemTagInput(Tags.Items.INGOTS_IRON, 1).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.gold)), 0.0f, 200, 350.0, "dust_gold_from_ingot").addItemTagInput(Tags.Items.INGOTS_GOLD, 1).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.copper)), 0.0f, 200, 350.0, "dust_copper_from_ingot").addItemTagInput(Tags.Items.INGOTS_COPPER, 1).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.netherite)), 0.0f, 200, 350.0, "dust_netherite_from_scrap").addItemStackInput(new ItemStack((ItemLike)Items.f_42419_)).complete(consumer);
        for (Enum enum_ : SubtypeImpureDust.values()) {
            this.newRecipe(new ItemStack((ItemLike)((SubtypeImpureDust)enum_).grindedDust.get()), 0.1f, 200, 350.0, "dust_" + enum_.name() + "_from_imp_dust").addItemTagInput(((SubtypeImpureDust)enum_).tag, 1).complete(consumer);
        }
        for (Enum enum_ : SubtypeRawOre.values()) {
            if (((SubtypeRawOre)enum_).grindedItem == null) continue;
            this.newRecipe(new ItemStack((ItemLike)((SubtypeRawOre)enum_).grindedItem.get(), 2), 0.1f, 200, 350.0, "dust_" + enum_.name() + "_from_raw_ore").addItemTagInput(((SubtypeRawOre)enum_).tag, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_42594_), 0.1)).complete(consumer);
        }
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.copper), 2), 0.1f, 200, 350.0, "dust_copper_from_raw_ore").addItemTagInput(Tags.Items.RAW_MATERIALS_COPPER, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_42594_), 0.1)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.iron), 2), 0.1f, 200, 350.0, "dust_iron_from_raw_ore").addItemTagInput(Tags.Items.RAW_MATERIALS_IRON, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_42594_), 0.1)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.gold), 2), 0.1f, 200, 350.0, "dust_gold_from_raw_ore").addItemTagInput(Tags.Items.RAW_MATERIALS_GOLD, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_42594_), 0.1)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.copper), 2), 0.1f, 200, 350.0, "dust_copper_from_ore").addItemTagInput(ItemTags.f_144318_, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_42594_), 0.1)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.gold), 2), 0.5f, 200, 350.0, "dust_gold_from_ore").addItemTagInput(ItemTags.f_13152_, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_42594_), 0.1)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.iron), 2), 0.3f, 200, 350.0, "dust_iron_from_ore").addItemTagInput(ItemTags.f_144312_, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_42594_), 0.1)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.lead), 2), 0.3f, 200, 350.0, "dust_lead_from_ore").addItemTagInput(VoltaicTags.Items.ORE_LEAD, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_42594_), 0.1)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.molybdenum), 2), 0.3f, 200, 350.0, "dust_molybdenum_from_ore").addItemTagInput(VoltaicTags.Items.ORE_MOLYBDENUM, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_42594_), 0.1)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.netherite), 2), 1.0f, 200, 350.0, "dust_netherite_from_ore").addItemTagInput(Tags.Items.ORES_NETHERITE_SCRAP, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_42594_), 0.1)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.silver), 2), 0.5f, 200, 350.0, "dust_silver_from_ore").addItemTagInput(VoltaicTags.Items.ORE_SILVER, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_42594_), 0.1)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.tin), 2), 0.1f, 200, 350.0, "dust_tin_from_ore").addItemTagInput(VoltaicTags.Items.ORE_TIN, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_42594_), 0.1)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.vanadium), 2), 0.1f, 200, 350.0, "dust_vanadium_from_ore").addItemTagInput(VoltaicTags.Items.ORE_VANADIUM, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_42594_), 0.1)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)Items.f_42413_, 3), 0.3f, 200, 350.0, "gem_coal_from_ore").addItemTagInput(ItemTags.f_144316_, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_42415_), 0.05)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)Items.f_42415_, 3), 1.0f, 200, 350.0, "gem_diamond_from_ore").addItemTagInput(ItemTags.f_144313_, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_42413_), 0.1)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)Items.f_42616_, 3), 1.0f, 200, 350.0, "gem_emerald_from_ore").addItemTagInput(ItemTags.f_144317_, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_42415_), 0.1)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)Items.f_42534_, 9), 0.4f, 200, 350.0, "gem_lapis_from_ore").addItemTagInput(ItemTags.f_144315_, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_42415_), 0.1)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)Items.f_42692_, 7), 0.7f, 200, 350.0, "gem_quartz_from_ore").addItemTagInput(Tags.Items.ORES_QUARTZ, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_42413_), 0.1)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.endereye), 2), 1.0f, 200, 350.0, "dust_ender_eye").addItemTagInput(Tags.Items.ENDER_PEARLS, 1).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.niter), 3), 0.1f, 200, 350.0, "dust_niter_from_ore").addItemTagInput(VoltaicTags.Items.ORE_SALTPETER, 1).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_CRYSTAL.getValue((Object)SubtypeCrystal.potassiumchloride), 3), 0.3f, 200, 350.0, "pot_chloride_from_ore").addItemTagInput(VoltaicTags.Items.ORE_POTASSIUMCHLORIDE, 1).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)Items.f_42451_, 6), 0.4f, 200, 350.0, "dust_redstone_from_ore").addItemTagInput(ItemTags.f_144314_, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_42415_), 0.05)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_DUST.getValue((Object)SubtypeDust.sulfur), 3), 0.2f, 200, 350.0, "dust_sulfur_from_ore").addItemTagInput(VoltaicTags.Items.ORE_SULFUR, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_42413_), 0.05)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)Items.f_42594_, 1), 0.01f, 200, 350.0, "cobblestone_from_stone").addItemTagInput(Tags.Items.STONE, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_41832_), 0.4)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)Items.f_41832_, 1), 0.01f, 200, 350.0, "gravel_from_cobblestone").addItemTagInput(Tags.Items.COBBLESTONE, 1).addItemBiproduct(new ProbableItem(new ItemStack((ItemLike)Items.f_41830_), 0.4)).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)Items.f_41830_, 1), 0.01f, 200, 350.0, "sand_from_gravel").addItemTagInput(Tags.Items.GRAVEL, 1).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_CRYSTAL.getValue((Object)SubtypeCrystal.halite), 3), 0.1f, 200, 350.0, "halite_cystal_from_halite_ore").addItemTagInput(VoltaicTags.Items.ORE_SALT, 1).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_RAWORE.getValue((Object)SubtypeRawOre.uranium)), 0.1f, 200, 350.0, "raw_uranium_from_uranium_ore").addItemTagInput(VoltaicTags.Items.ORE_URANIUM, 1).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_RAWORE.getValue((Object)SubtypeRawOre.thorium)), 0.1f, 200, 350.0, "raw_thorium_from_thorium_ore").addItemTagInput(VoltaicTags.Items.ORE_THORIUM, 1).complete(consumer);
        this.newRecipe(new ItemStack((ItemLike)ElectrodynamicsItems.ITEMS_RAWORE.getValue((Object)SubtypeRawOre.fluorite)), 0.1f, 200, 350.0, "fluorite_crystal_from_fluorite_ore").addItemTagInput(VoltaicTags.Items.ORE_FLUORITE, 1).complete(consumer);
    }

    public FinishedRecipeItemOutput newRecipe(ItemStack stack, float xp, int ticks, double usagePerTick, String name) {
        return FinishedRecipeItemOutput.of((RecipeSerializer)((RecipeSerializer)ElectrodynamicsRecipies.MINERAL_GRINDER_SERIALIZER.get()), (ItemStack)stack, (double)xp, (int)ticks, (double)usagePerTick).name(FinishedRecipeBase.RecipeCategory.ITEM_2_ITEM, this.modID, "mineral_grinder/" + name);
    }
}

