/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.datagen.utils;

import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class SimpleOreFeatureProvider {
    @Nullable
    private TagKey<Biome> tag;
    @Nullable
    private Biome biome;
    private RegistryObject<PlacedFeature> feature;
    private GenerationStep.Decoration decoration;
    private BiomeModifierType modifierType;

    private SimpleOreFeatureProvider(RegistryObject<PlacedFeature> feature, BiomeModifierType type) {
        this.feature = feature;
        this.modifierType = type;
    }

    public SimpleOreFeatureProvider biomeTag(TagKey<Biome> tag) {
        if (this.biome != null) {
            throw new UnsupportedOperationException("Specific biome already specified; cannot use tag!");
        }
        this.tag = tag;
        return this;
    }

    public SimpleOreFeatureProvider specificBiome(Biome biome) {
        if (this.tag != null) {
            throw new UnsupportedOperationException("Biome tag already specified; cannot use specific biome!");
        }
        this.biome = biome;
        return this;
    }

    public SimpleOreFeatureProvider decoration(GenerationStep.Decoration decoration) {
        this.decoration = decoration;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        String modifierName = switch (this.modifierType) {
            case BiomeModifierType.NONE_BIOME -> ForgeMod.NONE_BIOME_MODIFIER_TYPE.getId().toString();
            case BiomeModifierType.ADD_FEATURES -> ForgeMod.ADD_FEATURES_BIOME_MODIFIER_TYPE.getId().toString();
            case BiomeModifierType.REMOVE_FEATURES -> ForgeMod.REMOVE_FEATURES_BIOME_MODIFIER_TYPE.getId().toString();
            case BiomeModifierType.ADD_SPAWNS -> ForgeMod.ADD_SPAWNS_BIOME_MODIFIER_TYPE.getId().toString();
            case BiomeModifierType.REMOVE_SPAWNS -> ForgeMod.REMOVE_SPAWNS_BIOME_MODIFIER_TYPE.getId().toString();
            case BiomeModifierType.NONE_STRUCTURE -> ForgeMod.NONE_STRUCTURE_MODIFIER_TYPE.getId().toString();
            default -> ForgeMod.NONE_BIOME_MODIFIER_TYPE.getId().toString();
        };
        json.addProperty("type", modifierName);
        Object biomeName = this.tag == null ? ForgeRegistries.BIOMES.getKey((Object)this.biome).toString() : "#" + this.tag.f_203868_().toString();
        json.addProperty("biomes", (String)biomeName);
        json.addProperty("features", this.feature.getId().toString());
        json.addProperty("step", this.decoration.m_224194_());
        return json;
    }

    public static SimpleOreFeatureProvider of(RegistryObject<PlacedFeature> feature, BiomeModifierType modifier) {
        return new SimpleOreFeatureProvider(feature, modifier);
    }

    public static enum BiomeModifierType {
        NONE_BIOME,
        ADD_FEATURES,
        REMOVE_FEATURES,
        ADD_SPAWNS,
        REMOVE_SPAWNS,
        NONE_STRUCTURE;

    }
}

