/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.prefab.utilities;

import electrodynamics.common.tile.electricitygrid.GenericTileWire;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import voltaic.api.electricity.ICapabilityElectrodynamic;
import voltaic.api.network.cable.type.IWire;
import voltaic.common.tags.VoltaicTags;
import voltaic.prefab.utilities.CapabilityUtils;
import voltaic.prefab.utilities.ItemUtils;
import voltaic.prefab.utilities.object.TransferPack;
import voltaic.registers.VoltaicCapabilities;
import voltaic.registers.VoltaicDamageTypes;

public class ElectricityUtils {
    public static void electrecuteEntity(Entity entity, TransferPack transfer) {
        if (transfer.getVoltage() <= 960.0) {
            Ingredient insulatingItems = Ingredient.m_204132_((TagKey)VoltaicTags.Items.INSULATES_PLAYER_FEET);
            for (ItemStack armor : entity.m_6168_()) {
                if (!ItemUtils.isIngredientMember((Ingredient)insulatingItems, (Item)armor.m_41720_())) continue;
                float damage = (float)transfer.getAmps() / 10.0f;
                if (Math.random() < (double)damage) {
                    int integerDamage = (int)Math.max(1.0f, damage);
                    if (armor.m_41773_() > armor.m_41776_() || armor.m_220157_(integerDamage, entity.m_9236_().f_46441_, null)) {
                        armor.m_41764_(0);
                    }
                }
                return;
            }
        }
        entity.m_6469_(entity.m_269291_().m_269298_(VoltaicDamageTypes.ELECTRICITY, entity), (float)Math.min(9999.0, Math.max(0.0, transfer.getAmps())));
    }

    public static boolean isElectricReceiver(BlockEntity tile, Direction dir) {
        return tile != null && (tile.getCapability(VoltaicCapabilities.CAPABILITY_ELECTRODYNAMIC_BLOCK, dir).orElse((Object)CapabilityUtils.EMPTY_ELECTRO) != CapabilityUtils.EMPTY_ELECTRO || tile.getCapability(ForgeCapabilities.ENERGY, dir).orElse((Object)CapabilityUtils.EMPTY_FE) != CapabilityUtils.EMPTY_FE);
    }

    public static boolean isConductor(BlockEntity acceptor, GenericTileWire requesterWire) {
        if (acceptor instanceof GenericTileWire) {
            GenericTileWire conductor = (GenericTileWire)acceptor;
            return ((IWire)conductor.getCableType()).isDefaultColor() || ((IWire)requesterWire.getCableType()).isDefaultColor() || conductor.getWireColor() == requesterWire.getWireColor();
        }
        return false;
    }

    public static TransferPack receivePower(BlockEntity tile, Direction direction, TransferPack transfer, boolean debug) {
        if (tile == null) {
            return TransferPack.EMPTY;
        }
        ICapabilityElectrodynamic electro = (ICapabilityElectrodynamic)tile.getCapability(VoltaicCapabilities.CAPABILITY_ELECTRODYNAMIC_BLOCK, direction).orElse((Object)CapabilityUtils.EMPTY_ELECTRO);
        if (electro != CapabilityUtils.EMPTY_ELECTRO) {
            return electro.receivePower(transfer, debug);
        }
        IEnergyStorage fe = (IEnergyStorage)tile.getCapability(ForgeCapabilities.ENERGY, direction).orElse((Object)CapabilityUtils.EMPTY_FE);
        if (fe != CapabilityUtils.EMPTY_FE) {
            TransferPack returner = TransferPack.joulesVoltage((double)fe.receiveEnergy((int)Math.min(2.147483647E9, transfer.getJoules()), debug), (double)transfer.getVoltage());
            if (transfer.getVoltage() > 120.0) {
                Level world = tile.m_58904_();
                BlockPos pos = tile.m_58899_();
                world.m_46597_(pos, Blocks.f_50016_.m_49966_());
                world.m_254849_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (float)Math.log10(10.0 + transfer.getVoltage() / 120.0), Level.ExplosionInteraction.BLOCK);
            }
            return returner;
        }
        return TransferPack.EMPTY;
    }
}

