/*
 * Decompiled with CFR 0.152.
 */
package electrodynamics.prefab.utilities.object;

import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import voltaic.common.recipe.recipeutils.FluidIngredient;

public class CombustionFuelSource {
    public static final String FLUID_KEY = "fluid_tag";
    public static final String USAGE_AMOUNT = "usage_per_burn";
    public static final String POWER_MULTIPLIER = "power_multiplier";
    public static final CombustionFuelSource EMPTY = new CombustionFuelSource((TagKey<Fluid>)FluidTags.create((ResourceLocation)new ResourceLocation("air")), 0, 0.0);
    private FluidIngredient fuel;
    private double powerMultiplier;
    private final TagKey<Fluid> tag;

    private CombustionFuelSource(TagKey<Fluid> tag, int usageAmount, double powerMultiplier) {
        this.fuel = new FluidIngredient(tag, usageAmount);
        this.powerMultiplier = powerMultiplier;
        this.tag = tag;
    }

    public double getPowerMultiplier() {
        return this.powerMultiplier;
    }

    public boolean isFuelSource(FluidStack stack) {
        return this.fuel.testFluid(stack);
    }

    public List<FluidStack> getFuels() {
        return this.fuel.getMatchingFluids();
    }

    public TagKey<Fluid> getTag() {
        return this.tag;
    }

    public int getFuelUsage() {
        return this.fuel.getFluidStack().getAmount();
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public static CombustionFuelSource fromJson(JsonObject json) {
        TagKey tag = FluidTags.create((ResourceLocation)new ResourceLocation(json.get(FLUID_KEY).getAsString()));
        return new CombustionFuelSource((TagKey<Fluid>)tag, json.get(USAGE_AMOUNT).getAsInt(), json.get(POWER_MULTIPLIER).getAsDouble());
    }

    public static JsonObject toJson(TagKey<Fluid> fluid, int usageAmount, double powerMultiplier) {
        JsonObject json = new JsonObject();
        json.addProperty(FLUID_KEY, fluid.f_203868_().toString());
        json.addProperty(USAGE_AMOUNT, (Number)usageAmount);
        json.addProperty(POWER_MULTIPLIER, (Number)powerMultiplier);
        return json;
    }

    public void writeToBuffer(FriendlyByteBuf buffer) {
        buffer.m_130070_(this.fuel.tag.f_203868_().toString());
        buffer.writeInt(this.fuel.getFluidStack().getAmount());
        buffer.writeDouble(this.powerMultiplier);
    }

    public static CombustionFuelSource readFromBuffer(FriendlyByteBuf buffer) {
        TagKey tag = FluidTags.create((ResourceLocation)new ResourceLocation(buffer.m_130277_()));
        return new CombustionFuelSource((TagKey<Fluid>)tag, buffer.readInt(), buffer.readDouble());
    }
}

