/*
 * Decompiled with CFR 0.152.
 */
package hasjamon.block4block;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AdaptiveRangeMobSpawner
extends JavaPlugin
implements Listener {
    private int initialSpawnerRange;
    private int spawnerRangeHigh;
    private int spawnerRangeLow;
    private double tpsThresholdLow;
    private double tpsThresholdHigh;
    private int updateIntervalTicks;
    private boolean affectNaturallyGenerated;
    private boolean updatePreexistingSpawners;
    private int chunksPerTick;
    private int currentSpawnerRange;
    private boolean debugMode;
    private Set<String> disabledWorlds;
    private int playerChunkRadius;
    private boolean onlyUpdateNearPlayers;
    private static final String PLAYER_PLACED_KEY = "player_placed";
    private NamespacedKey playerPlacedKey;
    private boolean isPaper;
    private final Set<Long> recentlyProcessedChunks = new HashSet<Long>();

    public void onEnable() {
        this.playerPlacedKey = new NamespacedKey((Plugin)this, PLAYER_PLACED_KEY);
        this.currentSpawnerRange = -1;
        this.isPaper = this.checkIfPaper();
        if (this.isPaper) {
            this.getLogger().info("Running on Paper - using Paper-specific optimizations");
        } else {
            this.getLogger().info("Running on Spigot/Bukkit - using compatibility mode");
        }
        this.loadConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.currentSpawnerRange = this.initialSpawnerRange;
        new BukkitRunnable(){

            public void run() {
                AdaptiveRangeMobSpawner.this.recentlyProcessedChunks.clear();
                if (AdaptiveRangeMobSpawner.this.debugMode) {
                    AdaptiveRangeMobSpawner.this.getLogger().info("Cleared chunk processing cache");
                }
            }
        }.runTaskTimer((Plugin)this, 1200L, 1200L);
        this.updateChunksOnStartup();
        this.startTPSMonitoring();
        this.getLogger().info("Adaptive Range Mob Spawner enabled. Initial spawner range: " + this.initialSpawnerRange + " blocks.");
        this.getLogger().info("TPS thresholds: Low=" + this.tpsThresholdLow + ", High=" + this.tpsThresholdHigh);
        this.getLogger().info("Spawner ranges: Low=" + this.spawnerRangeLow + ", High=" + this.spawnerRangeHigh);
        this.getLogger().info("Affect naturally generated spawners: " + this.affectNaturallyGenerated);
        this.getLogger().info("Update preexisting spawners: " + this.updatePreexistingSpawners);
        this.getLogger().info("Only update spawners near players: " + this.onlyUpdateNearPlayers);
    }

    private boolean checkIfPaper() {
        try {
            Class.forName("io.papermc.paper.entity.TeleportFlag");
            return true;
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("com.destroystokyo.paper.event.server.ServerTickStartEvent");
                return true;
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
        }
    }

    private void loadConfig() {
        this.saveDefaultConfig();
        this.reloadConfig();
        FileConfiguration config = this.getConfig();
        this.initialSpawnerRange = config.getInt("initial-spawner-range", 64);
        this.spawnerRangeHigh = config.getInt("spawner-range-high", 128);
        this.spawnerRangeLow = config.getInt("spawner-range-low", 16);
        this.tpsThresholdLow = config.getDouble("tps-threshold-low", 15.0);
        this.tpsThresholdHigh = config.getDouble("tps-threshold-high", 18.0);
        this.updateIntervalTicks = config.getInt("update-interval-ticks", 200);
        this.affectNaturallyGenerated = config.getBoolean("affect-naturally-generated", false);
        this.updatePreexistingSpawners = config.getBoolean("update-preexisting-spawners", false);
        this.chunksPerTick = config.getInt("chunks-per-tick", 5);
        this.debugMode = config.getBoolean("debug-mode", false);
        this.onlyUpdateNearPlayers = config.getBoolean("only-update-near-players", true);
        this.playerChunkRadius = config.getInt("player-chunk-radius", 5);
        this.disabledWorlds = new HashSet<String>(config.getStringList("disabled-worlds"));
        if (!config.contains("chunks-per-tick")) {
            config.set("chunks-per-tick", (Object)this.chunksPerTick);
            config.set("debug-mode", (Object)this.debugMode);
            config.set("only-update-near-players", (Object)this.onlyUpdateNearPlayers);
            config.set("player-chunk-radius", (Object)this.playerChunkRadius);
            config.set("disabled-worlds", new ArrayList());
            this.saveConfig();
        }
    }

    private void updateChunksOnStartup() {
        new BukkitRunnable(){
            private final Chunk[] chunks = (Chunk[])Bukkit.getWorlds().stream().filter(world -> !AdaptiveRangeMobSpawner.this.disabledWorlds.contains(world.getName())).flatMap(world -> Arrays.stream(world.getLoadedChunks())).toArray(Chunk[]::new);
            private int index = 0;

            public void run() {
                int i = 0;
                while (i < AdaptiveRangeMobSpawner.this.chunksPerTick && this.index < this.chunks.length) {
                    AdaptiveRangeMobSpawner.this.updateSpawnersInChunk(this.chunks[this.index], AdaptiveRangeMobSpawner.this.initialSpawnerRange);
                    ++i;
                    ++this.index;
                }
                if (this.index >= this.chunks.length) {
                    this.cancel();
                    AdaptiveRangeMobSpawner.this.getLogger().info("All spawners updated on startup (" + this.chunks.length + " chunks processed).");
                }
            }
        }.runTaskTimer((Plugin)this, 20L, 1L);
    }

    private void startTPSMonitoring() {
        new BukkitRunnable(){

            public void run() {
                int newRange;
                double currentTPS = AdaptiveRangeMobSpawner.this.getTPS();
                if (currentTPS <= AdaptiveRangeMobSpawner.this.tpsThresholdLow) {
                    newRange = AdaptiveRangeMobSpawner.this.spawnerRangeLow;
                    AdaptiveRangeMobSpawner.this.logDebug("TPS below threshold (" + currentTPS + "). Setting spawner range to " + newRange);
                } else if (currentTPS >= AdaptiveRangeMobSpawner.this.tpsThresholdHigh) {
                    newRange = AdaptiveRangeMobSpawner.this.spawnerRangeHigh;
                    AdaptiveRangeMobSpawner.this.logDebug("TPS above threshold (" + currentTPS + "). Setting spawner range to " + newRange);
                } else {
                    return;
                }
                if (newRange == AdaptiveRangeMobSpawner.this.currentSpawnerRange) {
                    AdaptiveRangeMobSpawner.this.logDebug("Spawner range already at " + newRange + ", skipping update");
                    return;
                }
                AdaptiveRangeMobSpawner.this.currentSpawnerRange = newRange;
                AdaptiveRangeMobSpawner.this.updateAllSpawners(newRange);
            }
        }.runTaskTimer((Plugin)this, (long)this.updateIntervalTicks, (long)this.updateIntervalTicks);
    }

    private void updateAllSpawners(int newRange) {
        if (this.onlyUpdateNearPlayers) {
            HashSet<Long> processedChunkKeys = new HashSet<Long>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                World world = player.getWorld();
                if (this.disabledWorlds.contains(world.getName())) continue;
                Chunk centerChunk = player.getLocation().getChunk();
                for (int dx = -this.playerChunkRadius; dx <= this.playerChunkRadius; ++dx) {
                    for (int dz = -this.playerChunkRadius; dz <= this.playerChunkRadius; ++dz) {
                        if (dx * dx + dz * dz > this.playerChunkRadius * this.playerChunkRadius) continue;
                        int x = centerChunk.getX() + dx;
                        int z = centerChunk.getZ() + dz;
                        long chunkKey = (long)world.hashCode() << 32 | ((long)x & 0xFFFFFFFFL) << 16 | (long)z & 0xFFFFFFFFL;
                        if (!processedChunkKeys.add(chunkKey) || !world.isChunkLoaded(x, z)) continue;
                        Chunk chunk = world.getChunkAt(x, z);
                        this.updateSpawnersInChunk(chunk, newRange);
                    }
                }
            }
            this.logDebug("Updated spawners in " + processedChunkKeys.size() + " chunks near players");
        } else {
            int count = 0;
            for (World world : Bukkit.getWorlds()) {
                if (this.disabledWorlds.contains(world.getName())) continue;
                for (Chunk chunk : world.getLoadedChunks()) {
                    this.updateSpawnersInChunk(chunk, newRange);
                    ++count;
                }
            }
            this.logDebug("Updated spawners in all " + count + " loaded chunks");
        }
    }

    private double getTPS() {
        if (this.isPaper) {
            try {
                Method getTpsMethod = Bukkit.getServer().getClass().getMethod("getTPS", new Class[0]);
                double[] tps = (double[])getTpsMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
                return tps[0];
            }
            catch (Exception e) {
                this.logDebug("Failed to get TPS via Paper's getTPS method: " + e.getMessage());
                try {
                    Method getTickTimesMethod = Bukkit.getServer().getClass().getMethod("getTickTimes", new Class[0]);
                    double[] tickTimes = (double[])getTickTimesMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
                    double mspt = Arrays.stream(tickTimes).limit(100L).average().orElse(50.0);
                    return Math.min(20.0, 1000.0 / Math.max(mspt, 1.0));
                }
                catch (Exception e2) {
                    this.logDebug("Failed to get TPS via Paper's getTickTimes method: " + e2.getMessage());
                }
            }
        }
        try {
            Object serverInstance = Bukkit.getServer().getClass().getMethod("getServer", new Class[0]).invoke((Object)Bukkit.getServer(), new Object[0]);
            try {
                Field tpsField = serverInstance.getClass().getField("recentTps");
                double[] tps = (double[])tpsField.get(serverInstance);
                return tps[0];
            }
            catch (NoSuchFieldException e) {
                try {
                    Method getTpsMethod = serverInstance.getClass().getMethod("getTPS", new Class[0]);
                    double[] tps = (double[])getTpsMethod.invoke(serverInstance, new Object[0]);
                    return tps[0];
                }
                catch (Exception ex) {
                    this.logDebug("Could not find TPS method in server instance");
                }
            }
        }
        catch (Exception ex) {
            this.getLogger().warning("Failed to get server TPS: " + ex.getMessage());
        }
        this.getLogger().warning("Unable to retrieve server TPS - defaulting to 20.0. Plugin may not adjust spawner ranges correctly.");
        return 20.0;
    }

    private void updateSpawnersInChunk(Chunk chunk, int range) {
        if (this.disabledWorlds.contains(chunk.getWorld().getName())) {
            return;
        }
        long chunkKey = (long)chunk.getWorld().hashCode() << 32 | ((long)chunk.getX() & 0xFFFFFFFFL) << 16 | (long)chunk.getZ() & 0xFFFFFFFFL;
        if (this.recentlyProcessedChunks.contains(chunkKey)) {
            return;
        }
        this.recentlyProcessedChunks.add(chunkKey);
        if (this.isPaper) {
            CompletableFuture futureChunk = CompletableFuture.completedFuture(chunk);
            if (!chunk.isLoaded()) {
                try {
                    Method getChunkAtAsyncMethod = chunk.getWorld().getClass().getMethod("getChunkAtAsync", Integer.TYPE, Integer.TYPE);
                    futureChunk = (CompletableFuture)getChunkAtAsyncMethod.invoke((Object)chunk.getWorld(), chunk.getX(), chunk.getZ());
                }
                catch (Exception e) {
                    this.logDebug("Failed to use Paper's async chunk loading: " + e.getMessage());
                }
            }
            futureChunk.thenAccept(loadedChunk -> {
                if (loadedChunk != null && loadedChunk.isLoaded()) {
                    Bukkit.getScheduler().runTask((Plugin)this, () -> {
                        int count = 0;
                        for (BlockState blockState : loadedChunk.getTileEntities()) {
                            if (blockState.getType() != Material.SPAWNER || !this.processSpawner(blockState.getBlock(), range)) continue;
                            ++count;
                        }
                        if (count > 0 && this.debugMode) {
                            this.getLogger().info("Updated " + count + " spawners in chunk " + loadedChunk.getWorld().getName() + " [" + loadedChunk.getX() + "," + loadedChunk.getZ() + "]");
                        }
                    });
                }
            });
        } else {
            int count = 0;
            for (BlockState blockState : chunk.getTileEntities()) {
                if (blockState.getType() != Material.SPAWNER || !this.processSpawner(blockState.getBlock(), range)) continue;
                ++count;
            }
            if (count > 0 && this.debugMode) {
                this.getLogger().info("Updated " + count + " spawners in chunk " + chunk.getWorld().getName() + " [" + chunk.getX() + "," + chunk.getZ() + "]");
            }
        }
    }

    private boolean processSpawner(Block block, int range) {
        boolean shouldUpdate = this.isPlayerPlacedOrUpdateable(block);
        if (shouldUpdate) {
            this.updateSpawnerRange(block, range);
            return true;
        }
        if (!this.affectNaturallyGenerated) {
            this.updateSpawnerRange(block, 16);
            return true;
        }
        return false;
    }

    private boolean isPlayerPlacedOrUpdateable(Block block) {
        BlockState state = block.getState();
        if (state instanceof CreatureSpawner) {
            CreatureSpawner spawner = (CreatureSpawner)state;
            PersistentDataContainer pdc = spawner.getPersistentDataContainer();
            if (pdc.has(this.playerPlacedKey, PersistentDataType.INTEGER)) {
                return true;
            }
            return this.updatePreexistingSpawners;
        }
        return false;
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        int range;
        if (this.disabledWorlds.contains(event.getWorld().getName())) {
            return;
        }
        int n = range = this.currentSpawnerRange >= 0 ? this.currentSpawnerRange : this.initialSpawnerRange;
        if (this.isPaper) {
            try {
                Class<?> asyncEventClass = Class.forName("io.papermc.paper.event.world.AsyncChunkLoadEvent");
                if (asyncEventClass.isInstance(event)) {
                    Bukkit.getScheduler().runTask((Plugin)this, () -> this.updateSpawnersInChunk(event.getChunk(), range));
                    return;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.updateSpawnersInChunk(event.getChunk(), range);
    }

    @EventHandler
    public void onSpawnerPlace(BlockPlaceEvent event) {
        if (event.getBlock().getType() == Material.SPAWNER) {
            if (this.disabledWorlds.contains(event.getBlock().getWorld().getName())) {
                return;
            }
            Block block = event.getBlock();
            BlockState state = block.getState();
            if (state instanceof CreatureSpawner) {
                CreatureSpawner spawner = (CreatureSpawner)state;
                PersistentDataContainer pdc = spawner.getPersistentDataContainer();
                pdc.set(this.playerPlacedKey, PersistentDataType.INTEGER, (Object)1);
                spawner.update();
                int range = this.currentSpawnerRange >= 0 ? this.currentSpawnerRange : this.initialSpawnerRange;
                this.updateSpawnerRange(block, range);
                if (this.debugMode) {
                    this.getLogger().info("Player " + event.getPlayer().getName() + " placed a spawner at " + block.getWorld().getName() + " [" + block.getX() + "," + block.getY() + "," + block.getZ() + "] - Range set to " + range);
                }
            }
        }
    }

    private void updateSpawnerRange(Block block, int range) {
        CreatureSpawner spawner;
        if (block.getType() == Material.SPAWNER && (spawner = (CreatureSpawner)block.getState()).getRequiredPlayerRange() != range) {
            spawner.setRequiredPlayerRange(range);
            spawner.update();
        }
    }

    private void logDebug(String message) {
        if (this.debugMode) {
            this.getLogger().log(Level.INFO, "[Debug] " + message);
        }
    }

    public boolean onCommand(final CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("adaptivespawner")) {
            if (!sender.hasPermission("block4block.admin")) {
                sender.sendMessage("\u00a7cYou don't have permission to use this command.");
                return true;
            }
            if (args.length == 0) {
                sender.sendMessage("\u00a7e===== Adaptive Range Mob Spawner Status =====");
                sender.sendMessage("\u00a77Current TPS: \u00a7f" + String.format("%.2f", this.getTPS()));
                sender.sendMessage("\u00a77Current Spawner Range: \u00a7f" + this.currentSpawnerRange);
                sender.sendMessage("\u00a77TPS Thresholds: \u00a7flow=" + this.tpsThresholdLow + ", high=" + this.tpsThresholdHigh);
                sender.sendMessage("\u00a77Spawner Ranges: \u00a7flow=" + this.spawnerRangeLow + ", high=" + this.spawnerRangeHigh);
                sender.sendMessage("\u00a77Debug Mode: \u00a7f" + (this.debugMode ? "Enabled" : "Disabled"));
                sender.sendMessage("\u00a77Updating Near Players Only: \u00a7f" + (this.onlyUpdateNearPlayers ? "Yes" : "No"));
                return true;
            }
            if (args[0].equalsIgnoreCase("reload")) {
                this.reloadConfig();
                this.loadConfig();
                sender.sendMessage("\u00a7aAdaptive Range Mob Spawner config reloaded!");
                return true;
            }
            if (args[0].equalsIgnoreCase("debug")) {
                this.debugMode = !this.debugMode;
                this.getConfig().set("debug-mode", (Object)this.debugMode);
                this.saveConfig();
                sender.sendMessage("\u00a7aDebug mode " + (this.debugMode ? "enabled" : "disabled"));
                return true;
            }
            if (args[0].equalsIgnoreCase("update")) {
                final int range = this.currentSpawnerRange >= 0 ? this.currentSpawnerRange : this.initialSpawnerRange;
                sender.sendMessage("\u00a7aForcing update of all spawners to range: " + range);
                new BukkitRunnable(){

                    public void run() {
                        AdaptiveRangeMobSpawner.this.updateAllSpawners(range);
                        sender.sendMessage("\u00a7aSpawner update complete.");
                    }
                }.runTaskLater((Plugin)this, 5L);
                return true;
            }
        }
        return false;
    }
}

