/*
 * Decompiled with CFR 0.152.
 */
package ru.auth;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;
import ru.auth.commands.ChangePasswordCommand;
import ru.auth.commands.LoginCommand;
import ru.auth.commands.RegisterCommand;
import ru.auth.database.Database;
import ru.auth.utils.LanguageManager;

public class AuthPlugin
extends JavaPlugin
implements Listener {
    private Set<String> authenticatedPlayers;
    private Location spawnLocation;
    private Database database;
    private Map<String, BukkitTask> loginTimeoutTasks;
    private Map<String, Location> lastLocations;
    private LanguageManager languageManager;
    private Map<String, Integer> loginAttempts;
    private Map<String, Long> loginBlockTime;
    private Map<String, Set<UUID>> ipAccounts;

    public void onEnable() {
        this.authenticatedPlayers = new HashSet<String>();
        this.loginTimeoutTasks = new HashMap<String, BukkitTask>();
        this.lastLocations = new HashMap<String, Location>();
        this.loginAttempts = new HashMap<String, Integer>();
        this.loginBlockTime = new HashMap<String, Long>();
        this.ipAccounts = new HashMap<String, Set<UUID>>();
        this.saveDefaultConfig();
        this.languageManager = new LanguageManager(this);
        this.database = new Database(this);
        this.database.initialize();
        this.getCommand("login").setExecutor((CommandExecutor)new LoginCommand(this));
        this.getCommand("register").setExecutor((CommandExecutor)new RegisterCommand(this));
        this.getCommand("changepassword").setExecutor((CommandExecutor)new ChangePasswordCommand(this));
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.spawnLocation = this.getConfig().contains("spawn") ? (Location)this.getConfig().get("spawn") : ((World)this.getServer().getWorlds().get(0)).getSpawnLocation();
        this.getLogger().info("AuthPlugin \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0432\u043a\u043b\u044e\u0447\u0435\u043d!");
    }

    public void onDisable() {
        for (String playerName : this.authenticatedPlayers) {
            Player player = this.getServer().getPlayer(playerName);
            if (player == null) continue;
            this.database.saveLastLocation(player.getUniqueId(), player.getLocation());
        }
        this.authenticatedPlayers.clear();
        this.loginTimeoutTasks.values().forEach(BukkitTask::cancel);
        this.loginTimeoutTasks.clear();
        this.lastLocations.clear();
        this.database.close();
        this.getLogger().info("AuthPlugin \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d!");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        String ip = player.getAddress().getAddress().getHostAddress();
        int maxAccounts = this.getConfig().getInt("settings.max-accounts-per-ip", 2);
        if (maxAccounts > 0) {
            Set accounts = this.ipAccounts.computeIfAbsent(ip, k -> new HashSet());
            if (!accounts.contains(player.getUniqueId()) && accounts.size() >= maxAccounts) {
                player.kickPlayer(this.languageManager.getMessage("too-many-accounts").replace("{max}", String.valueOf(maxAccounts)));
                return;
            }
            accounts.add(player.getUniqueId());
        }
        if (this.getConfig().getBoolean("settings.save-last-location", true)) {
            this.lastLocations.put(player.getName(), player.getLocation());
        }
        if (this.getConfig().getBoolean("settings.teleport-to-spawn", true)) {
            player.teleport(this.spawnLocation);
        }
        player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, Integer.MAX_VALUE, 1, false, false));
        int timeout = this.getConfig().getInt("settings.login-timeout", 180);
        BukkitTask task = this.getServer().getScheduler().runTaskLater((Plugin)this, () -> {
            if (!this.isPlayerAuthenticated(player)) {
                player.kickPlayer(this.languageManager.getMessage("timeout"));
            }
        }, (long)timeout * 20L);
        this.loginTimeoutTasks.put(player.getName(), task);
        if (this.database.isRegistered(player.getUniqueId())) {
            player.sendMessage(this.languageManager.getMessage("must-login"));
        } else {
            player.sendMessage(this.languageManager.getMessage("not-registered"));
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        String playerName = player.getName();
        String ip = player.getAddress().getAddress().getHostAddress();
        this.authenticatedPlayers.remove(playerName);
        this.loginAttempts.remove(playerName);
        this.loginBlockTime.remove(playerName);
        BukkitTask task = this.loginTimeoutTasks.remove(playerName);
        if (task != null) {
            task.cancel();
        }
        if (this.isPlayerAuthenticated(player) && this.getConfig().getBoolean("settings.save-last-location", true)) {
            this.database.saveLastLocation(player.getUniqueId(), player.getLocation());
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        if (!this.isPlayerAuthenticated(event.getPlayer())) {
            Location from = event.getFrom();
            Location to = event.getTo();
            if (from.getX() != to.getX() || from.getY() != to.getY() || from.getZ() != to.getZ()) {
                event.setTo(from);
            } else if (!(this.getConfig().getBoolean("settings.allow-head-rotation", true) || from.getYaw() == to.getYaw() && from.getPitch() == to.getPitch())) {
                to.setYaw(from.getYaw());
                to.setPitch(from.getPitch());
                event.setTo(to);
            }
        }
    }

    @EventHandler
    public void onPlayerCommand(PlayerCommandPreprocessEvent event) {
        String command;
        if (!(this.isPlayerAuthenticated(event.getPlayer()) || (command = event.getMessage().split(" ")[0].toLowerCase()).equals("/login") || command.equals("/register") || command.equals("/l") || command.equals("/reg"))) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(this.languageManager.getMessage("must-login"));
        }
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (!this.isPlayerAuthenticated(event.getPlayer())) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(this.languageManager.getMessage("must-login"));
        }
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (!this.isPlayerAuthenticated(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (!this.isPlayerAuthenticated(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String command;
        if (!this.isPlayerAuthenticated(event.getPlayer()) && ((command = event.getMessage().toLowerCase()).startsWith("/coords") || command.startsWith("/pos") || command.startsWith("/location") || command.startsWith("/whereami") || command.startsWith("/getpos"))) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(this.languageManager.getMessage("must-login"));
        }
    }

    public boolean isPlayerAuthenticated(Player player) {
        return this.authenticatedPlayers.contains(player.getName());
    }

    public void authenticatePlayer(Player player) {
        String playerName = player.getName();
        this.authenticatedPlayers.add(playerName);
        BukkitTask task = this.loginTimeoutTasks.remove(playerName);
        if (task != null) {
            task.cancel();
        }
        player.removePotionEffect(PotionEffectType.BLINDNESS);
        this.loginAttempts.remove(playerName);
        this.loginBlockTime.remove(playerName);
        Location lastLocation = this.lastLocations.get(playerName);
        if (lastLocation != null) {
            player.teleport(lastLocation);
            this.lastLocations.remove(playerName);
        }
    }

    public Database getDatabase() {
        return this.database;
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public boolean canLogin(Player player) {
        String playerName = player.getName();
        int maxAttempts = this.getConfig().getInt("settings.max-login-attempts", 3);
        if (maxAttempts <= 0) {
            return true;
        }
        Long blockUntil = this.loginBlockTime.get(playerName);
        if (blockUntil != null) {
            if (System.currentTimeMillis() < blockUntil) {
                long remainingTime = (blockUntil - System.currentTimeMillis()) / 1000L;
                player.sendMessage(this.languageManager.getMessage("login-attempts-exceeded").replace("{time}", String.valueOf(remainingTime)));
                return false;
            }
            this.loginBlockTime.remove(playerName);
            this.loginAttempts.remove(playerName);
        }
        return true;
    }

    public void handleLoginAttempt(Player player, boolean success) {
        String playerName = player.getName();
        int maxAttempts = this.getConfig().getInt("settings.max-login-attempts", 3);
        if (maxAttempts <= 0) {
            return;
        }
        if (success) {
            this.loginAttempts.remove(playerName);
            this.loginBlockTime.remove(playerName);
        } else {
            int attempts = this.loginAttempts.getOrDefault(playerName, 0) + 1;
            this.loginAttempts.put(playerName, attempts);
            int remainingAttempts = maxAttempts - attempts;
            if (attempts >= maxAttempts) {
                int blockTime = this.getConfig().getInt("settings.login-block-time", 300);
                this.loginBlockTime.put(playerName, System.currentTimeMillis() + (long)blockTime * 1000L);
                player.sendMessage(this.languageManager.getMessage("login-attempts-exceeded").replace("{time}", String.valueOf(blockTime)));
            } else {
                player.sendMessage(this.languageManager.getMessage("wrong-password").replace("{attempts}", String.valueOf(remainingAttempts)));
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCommand(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        String command = event.getMessage().split(" ")[0].toLowerCase();
        if (!(this.isPlayerAuthenticated(player) || command.equals("/login") || command.equals("/register") || command.equals("/l") || command.equals("/reg"))) {
            String fullCommand = event.getMessage().toLowerCase();
            if (fullCommand.startsWith("/coords") || fullCommand.startsWith("/pos") || fullCommand.startsWith("/location") || fullCommand.startsWith("/whereami") || fullCommand.startsWith("/getpos")) {
                // empty if block
            }
            event.setCancelled(true);
            player.sendMessage(this.languageManager.getMessage("must-login"));
        }
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        if (!this.isPlayerAuthenticated(event.getPlayer())) {
            event.setCancelled(true);
            event.getPlayer().sendMessage(this.languageManager.getMessage("must-login"));
        }
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent event) {
        if (!this.isPlayerAuthenticated(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent event) {
        if (!this.isPlayerAuthenticated(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onItemPickup(EntityPickupItemEvent event) {
        if (event.getEntity() instanceof Player && !this.isPlayerAuthenticated((Player)event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onDamage(EntityDamageEvent event) {
        if (event.getEntity() instanceof Player && !this.isPlayerAuthenticated((Player)event.getEntity())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getWhoClicked() instanceof Player && !this.isPlayerAuthenticated((Player)event.getWhoClicked())) {
            event.setCancelled(true);
        }
    }
}

