/*
 * Decompiled with CFR 0.152.
 */
package ru.auth.commands;

import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import ru.auth.AuthPlugin;

public class ChangePasswordCommand
implements CommandExecutor {
    private final AuthPlugin plugin;

    public ChangePasswordCommand(AuthPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "\u042d\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0438\u0433\u0440\u043e\u043a\u043e\u0432!");
            return true;
        }
        Player player = (Player)sender;
        if (!this.plugin.isPlayerAuthenticated(player)) {
            player.sendMessage(this.plugin.getLanguageManager().getMessage("must-login"));
            return true;
        }
        if (args.length != 2) {
            player.sendMessage(ChatColor.RED + "\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /changepassword <\u0441\u0442\u0430\u0440\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c> <\u043d\u043e\u0432\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c>");
            return true;
        }
        String oldPassword = args[0];
        String newPassword = args[1];
        if (!this.plugin.getDatabase().checkPassword(player.getUniqueId(), oldPassword)) {
            player.sendMessage(ChatColor.RED + "\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0441\u0442\u0430\u0440\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c!");
            return true;
        }
        int minLength = this.plugin.getConfig().getInt("settings.min-password-length", 6);
        int maxLength = this.plugin.getConfig().getInt("settings.max-password-length", 32);
        if (newPassword.length() < minLength) {
            player.sendMessage(this.plugin.getLanguageManager().getMessage("password-too-short").replace("{min}", String.valueOf(minLength)));
            return true;
        }
        if (newPassword.length() > maxLength) {
            player.sendMessage(this.plugin.getLanguageManager().getMessage("password-too-long").replace("{max}", String.valueOf(maxLength)));
            return true;
        }
        try {
            this.plugin.getDatabase().updatePassword(player.getUniqueId(), newPassword);
            player.sendMessage(ChatColor.GREEN + "\u041f\u0430\u0440\u043e\u043b\u044c \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d!");
        }
        catch (Exception e) {
            player.sendMessage(ChatColor.RED + "\u041f\u0440\u043e\u0438\u0437\u043e\u0448\u043b\u0430 \u043e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043c\u0435\u043d\u0435 \u043f\u0430\u0440\u043e\u043b\u044f!");
            this.plugin.getLogger().severe("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043c\u0435\u043d\u0435 \u043f\u0430\u0440\u043e\u043b\u044f \u0434\u043b\u044f " + player.getName() + ": " + e.getMessage());
        }
        return true;
    }
}

