/*
 * Decompiled with CFR 0.152.
 */
package ru.auth.commands;

import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import ru.auth.AuthPlugin;

public class LoginCommand
implements CommandExecutor {
    private final AuthPlugin plugin;

    public LoginCommand(AuthPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.RED + "\u042d\u0442\u0430 \u043a\u043e\u043c\u0430\u043d\u0434\u0430 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u0430 \u0442\u043e\u043b\u044c\u043a\u043e \u0434\u043b\u044f \u0438\u0433\u0440\u043e\u043a\u043e\u0432!");
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            player.sendMessage(this.plugin.getLanguageManager().getMessage("must-login"));
            return true;
        }
        if (!this.plugin.getDatabase().isRegistered(player.getUniqueId())) {
            player.sendMessage(this.plugin.getLanguageManager().getMessage("not-registered"));
            return true;
        }
        if (this.plugin.isPlayerAuthenticated(player)) {
            player.sendMessage(this.plugin.getLanguageManager().getMessage("already-registered"));
            return true;
        }
        if (!this.plugin.canLogin(player)) {
            return true;
        }
        String password = args[0];
        boolean success = this.plugin.getDatabase().checkPassword(player.getUniqueId(), password);
        this.plugin.handleLoginAttempt(player, success);
        if (success) {
            this.plugin.authenticatePlayer(player);
            player.sendMessage(this.plugin.getLanguageManager().getMessage("login-success"));
        }
        return true;
    }
}

