/*
 * Decompiled with CFR 0.152.
 */
package ru.auth.database;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Base64;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import ru.auth.AuthPlugin;

public class Database {
    private final AuthPlugin plugin;
    private Connection connection;
    private final SecureRandom random = new SecureRandom();

    public Database(AuthPlugin plugin) {
        this.plugin = plugin;
    }

    public void initialize() {
        try {
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.plugin.getDataFolder().getAbsolutePath() + "/database.db");
            try (Statement statement = this.connection.createStatement();){
                statement.execute("CREATE TABLE IF NOT EXISTS players (uuid VARCHAR(36) PRIMARY KEY,username VARCHAR(16),password VARCHAR(256),salt VARCHAR(64),last_login BIGINT,last_location_world VARCHAR(64),last_location_x DOUBLE,last_location_y DOUBLE,last_location_z DOUBLE,last_location_yaw FLOAT,last_location_pitch FLOAT)");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0438\u043d\u0438\u0446\u0438\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u0431\u0430\u0437\u044b \u0434\u0430\u043d\u043d\u044b\u0445: " + e.getMessage());
        }
    }

    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0438 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0431\u0430\u0437\u043e\u0439 \u0434\u0430\u043d\u043d\u044b\u0445: " + e.getMessage());
        }
    }

    public boolean isRegistered(UUID uuid) {
        boolean bl;
        block8: {
            PreparedStatement statement = this.connection.prepareStatement("SELECT COUNT(*) FROM players WHERE uuid = ?");
            try {
                statement.setString(1, uuid.toString());
                ResultSet result = statement.executeQuery();
                boolean bl2 = bl = result.getInt(1) > 0;
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.plugin.getLogger().severe("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0435 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0438\u0433\u0440\u043e\u043a\u0430: " + e.getMessage());
                    return false;
                }
            }
            statement.close();
        }
        return bl;
    }

    public void registerPlayer(UUID uuid, String username, String password) {
        byte[] saltBytes = new byte[16];
        this.random.nextBytes(saltBytes);
        String salt = Base64.getEncoder().encodeToString(saltBytes);
        String hashedPassword = this.hashPassword(password, salt);
        try (PreparedStatement statement = this.connection.prepareStatement("INSERT OR REPLACE INTO players (uuid, username, password, salt, last_login) VALUES (?, ?, ?, ?, ?)");){
            statement.setString(1, uuid.toString());
            statement.setString(2, username);
            statement.setString(3, hashedPassword);
            statement.setString(4, salt);
            statement.setLong(5, System.currentTimeMillis());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0438\u0433\u0440\u043e\u043a\u0430: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkPassword(UUID uuid, String password) {
        try (PreparedStatement statement = this.connection.prepareStatement("SELECT password, salt FROM players WHERE uuid = ?");){
            statement.setString(1, uuid.toString());
            ResultSet result = statement.executeQuery();
            if (!result.next()) return false;
            String storedHash = result.getString("password");
            String salt = result.getString("salt");
            String hashedPassword = this.hashPassword(password, salt);
            boolean bl = storedHash.equals(hashedPassword);
            return bl;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0435 \u043f\u0430\u0440\u043e\u043b\u044f: " + e.getMessage());
        }
        return false;
    }

    public void updatePassword(UUID uuid, String newPassword) {
        byte[] saltBytes = new byte[16];
        this.random.nextBytes(saltBytes);
        String salt = Base64.getEncoder().encodeToString(saltBytes);
        String hashedPassword = this.hashPassword(newPassword, salt);
        try (PreparedStatement statement = this.connection.prepareStatement("UPDATE players SET password = ?, salt = ? WHERE uuid = ?");){
            statement.setString(1, hashedPassword);
            statement.setString(2, salt);
            statement.setString(3, uuid.toString());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0438 \u043f\u0430\u0440\u043e\u043b\u044f: " + e.getMessage());
        }
    }

    private String hashPassword(String password, String salt) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            String saltedPassword = password + salt;
            byte[] hash = digest.digest(saltedPassword.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(hash);
        }
        catch (NoSuchAlgorithmException e) {
            this.plugin.getLogger().severe("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0445\u0435\u0448\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0438 \u043f\u0430\u0440\u043e\u043b\u044f: " + e.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Location getLastLocation(UUID uuid) {
        try (PreparedStatement statement = this.connection.prepareStatement("SELECT last_location_world, last_location_x, last_location_y, last_location_z, last_location_yaw, last_location_pitch FROM players WHERE uuid = ?");){
            statement.setString(1, uuid.toString());
            ResultSet result = statement.executeQuery();
            if (!result.next()) return null;
            if (result.getString("last_location_world") == null) return null;
            String worldName = result.getString("last_location_world");
            double x = result.getDouble("last_location_x");
            double y = result.getDouble("last_location_y");
            double z = result.getDouble("last_location_z");
            float yaw = result.getFloat("last_location_yaw");
            float pitch = result.getFloat("last_location_pitch");
            Location location = new Location(Bukkit.getWorld((String)worldName), x, y, z, yaw, pitch);
            return location;
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u043b\u043e\u043a\u0430\u0446\u0438\u0438: " + e.getMessage());
        }
        return null;
    }

    public void saveLastLocation(UUID uuid, Location location) {
        try (PreparedStatement statement = this.connection.prepareStatement("UPDATE players SET last_location_world = ?, last_location_x = ?, last_location_y = ?, last_location_z = ?, last_location_yaw = ?, last_location_pitch = ? WHERE uuid = ?");){
            statement.setString(1, location.getWorld().getName());
            statement.setDouble(2, location.getX());
            statement.setDouble(3, location.getY());
            statement.setDouble(4, location.getZ());
            statement.setFloat(5, location.getYaw());
            statement.setFloat(6, location.getPitch());
            statement.setString(7, uuid.toString());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043f\u043e\u0441\u043b\u0435\u0434\u043d\u0435\u0439 \u043b\u043e\u043a\u0430\u0446\u0438\u0438: " + e.getMessage());
        }
    }
}

