/*
 * Decompiled with CFR 0.152.
 */
package ru.auth.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.YamlConfiguration;
import ru.auth.AuthPlugin;

public class LanguageManager {
    private final AuthPlugin plugin;
    private final Map<String, YamlConfiguration> languages;
    private final File langDir;

    public LanguageManager(AuthPlugin plugin) {
        this.plugin = plugin;
        this.languages = new HashMap<String, YamlConfiguration>();
        this.langDir = new File(plugin.getDataFolder(), "lang");
        if (!this.langDir.exists()) {
            this.langDir.mkdirs();
        }
        this.loadLanguages();
    }

    private void loadLanguages() {
        File langFile;
        block14: {
            this.languages.clear();
            langFile = new File(this.langDir, "ru.yml");
            if (!langFile.exists()) {
                try (InputStream in = this.plugin.getResource("lang/ru.yml");){
                    if (in != null) {
                        Files.copy(in, langFile.toPath(), new CopyOption[0]);
                        this.plugin.getLogger().info("\u0421\u043e\u0437\u0434\u0430\u043d \u044f\u0437\u044b\u043a\u043e\u0432\u043e\u0439 \u0444\u0430\u0439\u043b: ru.yml");
                        break block14;
                    }
                    this.plugin.getLogger().severe("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0440\u0435\u0441\u0443\u0440\u0441 \u044f\u0437\u044b\u043a\u043e\u0432\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430: ru.yml");
                    return;
                }
                catch (IOException e) {
                    this.plugin.getLogger().severe("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u044f\u0437\u044b\u043a\u043e\u0432\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430: " + e.getMessage());
                    return;
                }
            }
        }
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)langFile);
            if (config.contains("messages")) {
                this.languages.put("ru", config);
                this.plugin.getLogger().info("\u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d \u044f\u0437\u044b\u043a\u043e\u0432\u043e\u0439 \u0444\u0430\u0439\u043b: ru.yml");
            } else {
                this.plugin.getLogger().severe("\u042f\u0437\u044b\u043a\u043e\u0432\u043e\u0439 \u0444\u0430\u0439\u043b ru.yml \u043d\u0435 \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u0441\u0435\u043a\u0446\u0438\u044e messages!");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0435 \u044f\u0437\u044b\u043a\u043e\u0432\u043e\u0433\u043e \u0444\u0430\u0439\u043b\u0430: " + e.getMessage());
        }
    }

    public String getMessage(String key) {
        String message;
        YamlConfiguration config = this.languages.get("ru");
        if (config != null && (message = config.getString("messages." + key)) != null) {
            return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        }
        return ChatColor.RED + "Missing message: " + key;
    }

    public void reloadLanguages() {
        this.loadLanguages();
    }
}

