/*
 * Decompiled with CFR 0.152.
 */
package dev.yatloaf.modkrowd.config;

import dev.yatloaf.modkrowd.ModKrowd;
import dev.yatloaf.modkrowd.config.Config;
import dev.yatloaf.modkrowd.config.exception.ConfigException;
import dev.yatloaf.modkrowd.config.feature.Feature;
import dev.yatloaf.modkrowd.config.queue.ActionQueue;
import dev.yatloaf.modkrowd.cubekrowd.common.cache.TextCache;
import dev.yatloaf.modkrowd.cubekrowd.message.cache.MessageCache;
import dev.yatloaf.modkrowd.cubekrowd.subserver.Subserver;
import dev.yatloaf.modkrowd.cubekrowd.subserver.Subservers;
import dev.yatloaf.modkrowd.cubekrowd.tablist.cache.TabListCache;
import dev.yatloaf.modkrowd.custom.Custom;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_634;

public class SyncedConfig
extends Config {
    public final List<Feature> enabledFeatures = new ArrayList<Feature>(40);
    private boolean dirty = true;

    public void tryDeserialize(File file) {
        try {
            this.deserialize(file);
            this.dirty = false;
        }
        catch (ConfigException e) {
            ModKrowd.LOGGER.error("[SyncedConfig] Couldn't load config!", (Throwable)e);
        }
    }

    public void trySerialize(File file) {
        if (this.dirty) {
            try {
                this.serialize(file);
                this.dirty = false;
            }
            catch (ConfigException e) {
                ModKrowd.LOGGER.error("[SyncedConfig] Couldn't save config!", (Throwable)e);
            }
        }
    }

    public void copyFromConfig(Config source) {
        this.mergeState(source);
        this.selectedTab = source.selectedTab;
        this.dirty = true;
        this.updateFeatures();
    }

    public void updateTab(Config source) {
        this.selectedTab = source.selectedTab;
        this.dirty = true;
    }

    @Deprecated(forRemoval=true, since="0.1.3")
    public void updateFeatures(class_310 client, Subserver subserver) {
        this.updateFeatures(client, subserver, client.field_1724 != null ? client.field_1724.method_5691() : 0);
    }

    public void updateFeatures() {
        class_310 client = class_310.method_1551();
        this.updateFeatures(client, ModKrowd.currentSubserver, client.field_1724 != null ? client.field_1724.method_5691() : 0);
    }

    public synchronized void updateFeatures(class_310 client, Subserver subserver, int permissionLevel) {
        if (subserver == Subservers.PENDING) {
            return;
        }
        ArrayList<Feature> eventEnable = new ArrayList<Feature>();
        ArrayList<Feature> eventDisable = new ArrayList<Feature>();
        for (Feature f : this.features) {
            if (f.predicate.enabled(subserver, permissionLevel)) {
                if (f.enabled) continue;
                f.enabled = true;
                this.enabledFeatures.add(f);
                eventEnable.add(f);
                continue;
            }
            if (!f.enabled) continue;
            f.enabled = false;
            this.enabledFeatures.remove(f);
            eventDisable.add(f);
        }
        ActionQueue queue = new ActionQueue();
        for (Feature f : eventEnable) {
            f.onEnable(client, queue);
        }
        for (Feature f : eventDisable) {
            f.onDisable(client, queue);
        }
        queue.flush(client);
    }

    public synchronized void onInitEnable(class_310 client) {
        this.enabledFeatures.clear();
        ActionQueue queue = new ActionQueue();
        for (Feature f : this.features) {
            if (!f.predicate.enabled(Subservers.NONE, 0)) continue;
            f.enabled = true;
            this.enabledFeatures.add(f);
            f.onInitEnable(client, queue);
        }
        queue.flush(client);
    }

    public synchronized void onEndTick(class_310 client) {
        ActionQueue queue = new ActionQueue();
        for (Feature f : this.enabledFeatures) {
            f.onEndTick(client, queue);
        }
        queue.flush(client);
    }

    public synchronized void onJoin(class_634 handler, class_310 client) {
        ActionQueue queue = new ActionQueue();
        for (Feature f : this.enabledFeatures) {
            f.onJoin(handler, client, queue);
        }
        queue.flush(client);
    }

    public synchronized void onJoinUpdated(class_634 handler, class_310 client) {
        ActionQueue queue = new ActionQueue();
        for (Feature f : this.enabledFeatures) {
            f.onJoinUpdated(handler, client, queue);
        }
        queue.flush(client);
    }

    public synchronized void onDisconnect(class_634 handler, class_310 client) {
        ActionQueue queue = new ActionQueue();
        for (Feature f : this.enabledFeatures) {
            f.onDisconnect(handler, client, queue);
        }
        queue.flush(client);
    }

    public synchronized boolean allowMessage(MessageCache message, boolean overlay) {
        class_310 client = class_310.method_1551();
        ActionQueue queue = new ActionQueue();
        for (Feature f : this.enabledFeatures) {
            f.onMessage(message, overlay, client, queue);
        }
        queue.flush(client);
        return !message.blocked();
    }

    public synchronized void onTabList(TabListCache tabList) {
        ActionQueue queue = new ActionQueue();
        class_310 client = class_310.method_1551();
        for (Feature f : this.enabledFeatures) {
            f.onTabList(tabList, client, queue);
        }
        queue.flush(client);
    }

    public synchronized TextCache themeCustom(Custom custom) {
        ActionQueue queue = new ActionQueue();
        class_310 client = class_310.method_1551();
        for (Feature f : this.enabledFeatures) {
            TextCache result = f.themeCustom(custom, client, queue);
            if (result == null) continue;
            queue.flush(client);
            return result;
        }
        queue.flush(client);
        return custom.appearance();
    }
}

