/*
 * Decompiled with CFR 0.152.
 */
package dev.yatloaf.modkrowd.config.feature;

import dev.yatloaf.modkrowd.config.PredicateIndex;
import dev.yatloaf.modkrowd.config.feature.CherryLiteThemeFeature;
import dev.yatloaf.modkrowd.config.queue.ActionQueue;
import dev.yatloaf.modkrowd.cubekrowd.common.Afk;
import dev.yatloaf.modkrowd.cubekrowd.common.CKColor;
import dev.yatloaf.modkrowd.cubekrowd.common.LatencyLevel;
import dev.yatloaf.modkrowd.cubekrowd.common.MinigameTeam;
import dev.yatloaf.modkrowd.cubekrowd.common.MinigameTeamName;
import dev.yatloaf.modkrowd.cubekrowd.common.Rank;
import dev.yatloaf.modkrowd.cubekrowd.common.RankBrackets;
import dev.yatloaf.modkrowd.cubekrowd.common.RankLetters;
import dev.yatloaf.modkrowd.cubekrowd.common.RankName;
import dev.yatloaf.modkrowd.cubekrowd.common.cache.TextCache;
import dev.yatloaf.modkrowd.cubekrowd.tablist.MainTabColumn;
import dev.yatloaf.modkrowd.cubekrowd.tablist.MainTabName;
import dev.yatloaf.modkrowd.cubekrowd.tablist.MainTabPing;
import dev.yatloaf.modkrowd.cubekrowd.tablist.MinigameTabName;
import dev.yatloaf.modkrowd.cubekrowd.tablist.TabEntry;
import dev.yatloaf.modkrowd.cubekrowd.tablist.cache.TabEntryCache;
import dev.yatloaf.modkrowd.custom.Custom;
import dev.yatloaf.modkrowd.custom.SelfAlohaMessage;
import dev.yatloaf.modkrowd.util.Util;
import dev.yatloaf.modkrowd.util.text.StyledString;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5251;

public class CherryThemeFeature
extends CherryLiteThemeFeature {
    public CherryThemeFeature(String id, PredicateIndex allowedPredicates) {
        super(id, allowedPredicates);
    }

    @Override
    protected void onTabEntry(TabEntryCache entry) {
        super.onTabEntry(entry);
        TabEntry tabEntry = entry.result();
        Objects.requireNonNull(tabEntry);
        TabEntry tabEntry2 = tabEntry;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MainTabName.class, MinigameTabName.class}, (Object)tabEntry2, n)) {
            case 0: {
                MainTabName mainTabName = (MainTabName)tabEntry2;
                entry.setThemed(this.mainTabName(mainTabName));
                break;
            }
            case 1: {
                MinigameTabName minigameTabName = (MinigameTabName)tabEntry2;
                entry.setThemed(this.minigameTabName(minigameTabName));
                break;
            }
        }
        entry.setLatencyThemed(this.formatLatency(entry.latency));
    }

    @Override
    protected TextCache mainTabColumn(MainTabColumn column) {
        return TextCache.of(column.appearance().fillColor(column.online() ? CHERRY4 : CHERRY1));
    }

    @Override
    protected TextCache mainTabPing(MainTabPing ping) {
        return TextCache.of(StyledString.concat(MainTabPing.YOUR_PING_.fillColor(CHERRY5), StyledString.fromString(" " + ping.latency() + "ms", class_2583.field_24360.method_27703(CHERRY6))));
    }

    protected TextCache mainTabName(MainTabName mainTabName) {
        return TextCache.of(StyledString.concat(this.afk(mainTabName.afk()), this.rankName(mainTabName.rankName())));
    }

    protected TextCache minigameTabName(MinigameTabName tabName) {
        return TextCache.of(StyledString.concat(this.afk(tabName.afk()), this.minigameTeamName(tabName.teamName())));
    }

    protected StyledString afk(Afk afk) {
        return afk.star.fillColor(CHERRY2);
    }

    @Override
    protected StyledString rankName(RankName rankName) {
        Rank rank = rankName.rank();
        class_5251 nameColor = this.colorNameFromRank(rank);
        class_5251 bracketsColor = this.colorBrackets(rank);
        return StyledString.concat(rank.pipes().pipe.fillColor(CHERRY4), rank.brackets().leftBracket.fillColor(bracketsColor), rank.letters().letter.fillColor(CHERRY6), rank.brackets().rightBracket.fillColor(bracketsColor), rank.pipes().pipe.fillColor(CHERRY4), StyledString.SPACE, rankName.name().fillColor(nameColor));
    }

    @Override
    protected StyledString minigameTeamName(MinigameTeamName teamName) {
        class_5251 teamColor = this.colorNameFromTeam(teamName.team());
        return teamName.name().fillColor(teamColor);
    }

    protected class_5251 colorBrackets(Rank rank) {
        return switch (rank.brackets()) {
            case RankBrackets.NONE -> CHERRY1;
            case RankBrackets.YELLOW -> CHERRY5;
            case RankBrackets.GOLD -> CHERRY3;
            default -> CKColor.WHITE.textColor;
        };
    }

    protected class_5251 colorNameFromRank(Rank rank) {
        return switch (rank.letters()) {
            case RankLetters.GUEST -> CHERRY5;
            case RankLetters.MEMBER, RankLetters.BUILDER -> CHERRY6;
            case RankLetters.TRUSTED -> CHERRY3;
            case RankLetters.RESPECTED -> CHERRY2;
            case RankLetters.VETERAN, RankLetters.DEVELOPER -> CHERRY1;
            case RankLetters.SPECIAL_GUEST, RankLetters.YOUTUBE, RankLetters.ZIPKROWD -> CHERRY4;
            case RankLetters.HELPER -> CHERRY3;
            case RankLetters.MODERATOR -> CHERRY3;
            case RankLetters.ADMIN -> CHERRY5;
            default -> CKColor.WHITE.textColor;
        };
    }

    protected class_5251 colorNameFromTeam(MinigameTeam team) {
        return switch (team) {
            case MinigameTeam.MW_LOBBY, MinigameTeam.RR_LOBBY, MinigameTeam.CC_LOBBY -> CHERRY1;
            case MinigameTeam.MW_SPECTATOR, MinigameTeam.RR_SPECTATOR, MinigameTeam.IR_SPECTATOR, MinigameTeam.FS, MinigameTeam.CC_SPECTATOR -> CHERRY4;
            case MinigameTeam.MW_RED, MinigameTeam.RR_BLUE, MinigameTeam.IR_RED, MinigameTeam.CC_PURPLE -> CHERRY3;
            case MinigameTeam.MW_GREEN, MinigameTeam.RR_YELLOW, MinigameTeam.IR_GREEN, MinigameTeam.CC_ORANGE -> CHERRY6;
            default -> CKColor.WHITE.textColor;
        };
    }

    protected TextCache formatLatency(int latency) {
        class_5251 color = this.colorLatencyLevel(LatencyLevel.fromLatency(latency));
        return TextCache.of(class_2561.method_43470((String)Util.superscript(latency)).method_10862(class_2583.field_24360.method_27703(color)));
    }

    protected class_5251 colorLatencyLevel(LatencyLevel level) {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case LatencyLevel.UNKNOWN -> CHERRY6;
            case LatencyLevel.L1 -> CHERRY5;
            case LatencyLevel.L2 -> CHERRY4;
            case LatencyLevel.L3 -> CHERRY3;
            case LatencyLevel.L4 -> CHERRY2;
            case LatencyLevel.L5 -> CHERRY1;
        };
    }

    @Override
    public TextCache themeCustom(Custom custom, class_310 client, ActionQueue queue) {
        Custom custom2 = custom;
        Objects.requireNonNull(custom2);
        Custom custom3 = custom2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SelfAlohaMessage.class}, (Object)custom3, n)) {
            case 0 -> {
                SelfAlohaMessage selfAlohaMessage = (SelfAlohaMessage)custom3;
                yield this.selfAlohaMessage(selfAlohaMessage);
            }
            default -> TextCache.EMPTY;
        };
    }

    public TextCache selfAlohaMessage(SelfAlohaMessage selfAlohaMessage) {
        return TextCache.of(selfAlohaMessage.appearance().text().method_10862(class_2583.field_24360.method_27703(CHERRY5)));
    }
}

