/*
 * Decompiled with CFR 0.152.
 */
package dev.yatloaf.modkrowd.config.feature;

import dev.yatloaf.modkrowd.config.DefaultTheme;
import dev.yatloaf.modkrowd.config.PredicateIndex;
import dev.yatloaf.modkrowd.config.feature.ThemeFeature;
import dev.yatloaf.modkrowd.config.queue.ActionQueue;
import dev.yatloaf.modkrowd.cubekrowd.common.Afk;
import dev.yatloaf.modkrowd.cubekrowd.common.CKColor;
import dev.yatloaf.modkrowd.cubekrowd.common.LatencyLevel;
import dev.yatloaf.modkrowd.cubekrowd.common.RankLetters;
import dev.yatloaf.modkrowd.cubekrowd.common.RankName;
import dev.yatloaf.modkrowd.cubekrowd.common.cache.TextCache;
import dev.yatloaf.modkrowd.cubekrowd.message.AfkMessage;
import dev.yatloaf.modkrowd.cubekrowd.message.AlohaMessage;
import dev.yatloaf.modkrowd.cubekrowd.message.MainChatMessage;
import dev.yatloaf.modkrowd.cubekrowd.message.Message;
import dev.yatloaf.modkrowd.cubekrowd.message.cache.MessageCache;
import dev.yatloaf.modkrowd.cubekrowd.tablist.MainTabList;
import dev.yatloaf.modkrowd.cubekrowd.tablist.MainTabName;
import dev.yatloaf.modkrowd.cubekrowd.tablist.MainTabPing;
import dev.yatloaf.modkrowd.cubekrowd.tablist.MinigameTabList;
import dev.yatloaf.modkrowd.cubekrowd.tablist.MinigameTabName;
import dev.yatloaf.modkrowd.cubekrowd.tablist.TabEntry;
import dev.yatloaf.modkrowd.cubekrowd.tablist.TabList;
import dev.yatloaf.modkrowd.cubekrowd.tablist.cache.TabListCache;
import dev.yatloaf.modkrowd.util.text.StyledString;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.class_2583;
import net.minecraft.class_310;

public class HighContrastThemeFeature
extends ThemeFeature {
    public HighContrastThemeFeature(String id, PredicateIndex allowedPredicates) {
        super(id, allowedPredicates);
    }

    @Override
    public void onMessage(MessageCache message, boolean overlay, class_310 client, ActionQueue queue) {
        Message message2 = message.result();
        Objects.requireNonNull(message2);
        Message message3 = message2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AlohaMessage.class, AfkMessage.class, MainChatMessage.class}, (Object)message3, n)) {
            case 0: {
                AlohaMessage alohaMessage = (AlohaMessage)message3;
                this.onAlohaMessage(message, alohaMessage);
                break;
            }
            case 1: {
                AfkMessage afkMessage = (AfkMessage)message3;
                this.onAfkMessage(message, afkMessage);
                break;
            }
            case 2: {
                MainChatMessage mainChatMessage = (MainChatMessage)message3;
                this.onMainChatMessage(message, mainChatMessage);
                break;
            }
        }
    }

    protected void onAlohaMessage(MessageCache message, AlohaMessage alohaMessage) {
        switch (alohaMessage.aloha()) {
            case JOIN: {
                message.setThemed(TextCache.of(StyledString.concat(StyledString.fromString("+ ", CKColor.DARK_GREEN.style), alohaMessage.name().fillColor(CKColor.WHITE.textColor), StyledString.fromString(" joined", CKColor.GRAY.style))));
                break;
            }
            case LEAVE: {
                message.setThemed(TextCache.of(StyledString.concat(StyledString.fromString("- ", CKColor.DARK_RED.style), alohaMessage.name().fillColor(CKColor.WHITE.textColor), StyledString.fromString(" left", CKColor.GRAY.style))));
            }
        }
    }

    protected void onAfkMessage(MessageCache message, AfkMessage afkMessage) {
        switch (afkMessage.afk()) {
            case FALSE: {
                message.setThemed(TextCache.of(StyledString.concat(StyledString.fromString("+ ", CKColor.GREEN.style), afkMessage.name().fillColor(CKColor.WHITE.textColor), StyledString.fromString(" is no longer AFK", CKColor.GRAY.style))));
                break;
            }
            case TRUE: {
                message.setThemed(TextCache.of(StyledString.concat(StyledString.fromString("- ", CKColor.RED.style), afkMessage.name().fillColor(CKColor.WHITE.textColor), StyledString.fromString(" is now AFK", CKColor.GRAY.style))));
            }
        }
    }

    protected void onMainChatMessage(MessageCache message, MainChatMessage mainChatMessage) {
        switch (mainChatMessage.sender().rank().letters()) {
            case RESPECTED: 
            case VETERAN: {
                message.setThemed(TextCache.of(mainChatMessage.mapSender(HighContrastThemeFeature::modifyRankName).appearance()));
            }
        }
    }

    @Override
    public void onTabList(TabListCache tabList, class_310 client, ActionQueue queue) {
        TabList tabList2 = tabList.result();
        Objects.requireNonNull(tabList2);
        TabList tabList3 = tabList2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MainTabList.class, MinigameTabList.class}, (Object)tabList3, n)) {
            case 0: {
                MainTabList mainTabList = (MainTabList)tabList3;
                this.onMainTabList(mainTabList);
                break;
            }
            case 1: {
                MinigameTabList minigameTabList = (MinigameTabList)tabList3;
                this.onMinigameTabList(minigameTabList);
                break;
            }
        }
    }

    protected void onMainTabList(MainTabList mainTabList) {
        block4: for (MainTabList.EntryCache entry : mainTabList.entries()) {
            TabEntry tabEntry;
            Objects.requireNonNull(entry.result());
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MainTabName.class, MainTabPing.class}, (Object)tabEntry, n)) {
                case 0: {
                    MainTabName mainTabName = (MainTabName)tabEntry;
                    entry.setThemed(TextCache.of(StyledString.concat(mainTabName.afk().star.fillColor(CKColor.LIGHT_PURPLE.textColor), HighContrastThemeFeature.modifyRankName(mainTabName.rankName()).appearance())));
                    continue block4;
                }
                case 1: {
                    MainTabPing mainTabPing = (MainTabPing)tabEntry;
                    entry.setThemed(TextCache.of(StyledString.concat(MainTabPing.YOUR_PING_, StyledString.fromString(" " + mainTabPing.latency() + "ms", class_2583.field_24360.method_36139(DefaultTheme.colorLatencyLevel(LatencyLevel.fromLatency(mainTabPing.latency())))))));
                    continue block4;
                }
            }
        }
    }

    protected void onMinigameTabList(MinigameTabList minigameTabList) {
        for (MinigameTabList.EntryCache player : minigameTabList.players()) {
            MinigameTabName minigameTabName;
            TabEntry tabEntry = player.result();
            if (!(tabEntry instanceof MinigameTabName) || (minigameTabName = (MinigameTabName)tabEntry).afk() != Afk.TRUE) continue;
            player.setThemed(TextCache.of(minigameTabName.mapTeamName(teamName -> teamName.mapName(StyledString::fillStrikethrough)).appearance()));
        }
    }

    protected static RankName modifyRankName(RankName rankName) {
        return switch (rankName.rank().letters()) {
            case RankLetters.RESPECTED -> rankName.mapName(name -> name.fillColor(CKColor.LIGHT_PURPLE.textColor));
            case RankLetters.VETERAN -> rankName.mapName(name -> name.fillColor(CKColor.YELLOW.textColor));
            default -> rankName;
        };
    }
}

