/*
 * Decompiled with CFR 0.152.
 */
package dev.yatloaf.modkrowd.cubekrowd.common;

import dev.yatloaf.modkrowd.cubekrowd.common.CKColor;
import dev.yatloaf.modkrowd.util.Util;
import dev.yatloaf.modkrowd.util.text.StyledString;
import dev.yatloaf.modkrowd.util.text.StyledStringReader;
import java.util.Map;

public enum RankBrackets {
    NONE(StyledString.fromString("[", CKColor.DARK_GRAY.style), StyledString.fromString("]", CKColor.DARK_GRAY.style)),
    YELLOW(StyledString.fromString("[", CKColor.YELLOW.style), StyledString.fromString("]", CKColor.YELLOW.style)),
    GOLD(StyledString.fromString("[", CKColor.GOLD.style), StyledString.fromString("]", CKColor.GOLD.style)),
    UNKNOWN(StyledString.fromString("["), StyledString.fromString("]"));

    public final StyledString leftBracket;
    public final StyledString rightBracket;
    private static final Map<StyledString, RankBrackets> FROM_LEFT_BRACKET;
    private static final Map<StyledString, RankBrackets> FROM_RIGHT_BRACKET;

    private RankBrackets(StyledString leftBracket, StyledString rightBracket) {
        this.leftBracket = leftBracket;
        this.rightBracket = rightBracket;
    }

    public static RankBrackets readLeft(StyledStringReader source) {
        return source.mapNextOrDefault(FROM_LEFT_BRACKET, UNKNOWN);
    }

    public static RankBrackets readRight(StyledStringReader source) {
        return source.mapNextOrDefault(FROM_RIGHT_BRACKET, UNKNOWN);
    }

    public boolean isReal() {
        return this != UNKNOWN;
    }

    static {
        FROM_LEFT_BRACKET = Util.arrayToMap(RankBrackets.values(), item -> item.leftBracket, item -> item);
        FROM_RIGHT_BRACKET = Util.arrayToMap(RankBrackets.values(), item -> item.rightBracket, item -> item);
    }
}

