/*
 * Decompiled with CFR 0.152.
 */
package dev.yatloaf.modkrowd.cubekrowd.tablist;

import dev.yatloaf.modkrowd.cubekrowd.common.CKColor;
import dev.yatloaf.modkrowd.cubekrowd.common.SelfPlayer;
import dev.yatloaf.modkrowd.cubekrowd.common.cache.TextCache;
import dev.yatloaf.modkrowd.cubekrowd.subserver.Subserver;
import dev.yatloaf.modkrowd.cubekrowd.subserver.Subservers;
import dev.yatloaf.modkrowd.cubekrowd.tablist.MainTabColumn;
import dev.yatloaf.modkrowd.cubekrowd.tablist.MainTabName;
import dev.yatloaf.modkrowd.cubekrowd.tablist.MainTabPing;
import dev.yatloaf.modkrowd.cubekrowd.tablist.MainTabPlayers;
import dev.yatloaf.modkrowd.cubekrowd.tablist.TabEntry;
import dev.yatloaf.modkrowd.cubekrowd.tablist.TabList;
import dev.yatloaf.modkrowd.cubekrowd.tablist.cache.TabEntryCache;
import dev.yatloaf.modkrowd.cubekrowd.tablist.cache.TabListCache;
import dev.yatloaf.modkrowd.util.text.StyledString;
import dev.yatloaf.modkrowd.util.text.StyledStringReader;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_640;

public final class MainTabList
extends Record
implements TabList {
    private final EntryCache[] entries;
    private final EntryCache[] players;
    private final EntryCache self;
    private final Set<Subserver> listedSubservers;
    private final boolean isReal;
    public static final EntryCache[] EMPTY_ENTRIES = new EntryCache[0];
    public static final MainTabList FAILURE = new MainTabList(EMPTY_ENTRIES, EMPTY_ENTRIES, null, Set.of(), false);
    private static final StyledString SU2 = StyledString.concat(StyledString.fromString("[", CKColor.GRAY.style), StyledString.fromString("su2", CKColor.YELLOW.style), StyledString.fromString("]", CKColor.GRAY.style));
    private static final IntSet SPECIAL_INDEXES = IntSet.of((int[])new int[]{0, 17, 18, 19, 20, 40, 60});

    public MainTabList(EntryCache[] entries, EntryCache[] players, EntryCache self, Set<Subserver> listedSubservers, boolean isReal) {
        this.entries = entries;
        this.players = players;
        this.self = self;
        this.listedSubservers = listedSubservers;
        this.isReal = isReal;
    }

    public static MainTabList parseFast(TabListCache source) {
        List<class_640> playerListEntries = source.playerListEntries();
        if (playerListEntries.size() < 80) {
            return FAILURE;
        }
        MainTabColumn currentColumn = MainTabColumn.FAILURE;
        HashSet<Subserver> listedSubservers = new HashSet<Subserver>(4);
        EntryCache[] entries = new EntryCache[80];
        ArrayList<EntryCache> playersBuilder = new ArrayList<EntryCache>();
        String selfName = SelfPlayer.username();
        EntryCache self = null;
        for (int index = 0; index < 80; ++index) {
            boolean isPlayer;
            EntryCache entryCache;
            TextCache name = source.getPlayerName(index);
            if (SPECIAL_INDEXES.contains(index)) {
                entryCache = new EntryCache(name, index, playerListEntries.get(index).method_2959(), currentColumn.subserver());
                TabEntry result = entryCache.result();
                if (result instanceof MainTabColumn) {
                    MainTabColumn mainTabColumn = (MainTabColumn)result;
                    if (!mainTabColumn.isReal()) {
                        return FAILURE;
                    }
                    currentColumn = mainTabColumn;
                    Subserver subserver = currentColumn.subserver();
                    listedSubservers.add(subserver);
                    if (subserver == Subservers.SURVIVAL_AMBIGUOUS) {
                        listedSubservers.add(Subservers.SURVIVAL);
                        listedSubservers.add(Subservers.SURVIVAL2);
                    }
                }
                isPlayer = entryCache.isPlayer();
            } else {
                isPlayer = !name.string().isBlank() && !name.styledString().contains(___AND);
                entryCache = new EntryCache(name, index, playerListEntries.get(index).method_2959(), isPlayer, currentColumn.subserver());
            }
            entries[index] = entryCache;
            if (!isPlayer) continue;
            playersBuilder.add(entryCache);
            if (!name.string().equals(selfName)) continue;
            self = entryCache;
        }
        EntryCache[] players = (EntryCache[])playersBuilder.toArray(EntryCache[]::new);
        return new MainTabList(entries, players, self, listedSubservers, true);
    }

    @Override
    public boolean listsSubserver(Subserver subserver) {
        return this.listedSubservers.contains(subserver);
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{MainTabList.class, "entries;players;self;listedSubservers;isReal", "entries", "players", "self", "listedSubservers", "isReal"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MainTabList.class, "entries;players;self;listedSubservers;isReal", "entries", "players", "self", "listedSubservers", "isReal"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MainTabList.class, "entries;players;self;listedSubservers;isReal", "entries", "players", "self", "listedSubservers", "isReal"}, this, o);
    }

    public EntryCache[] entries() {
        return this.entries;
    }

    public EntryCache[] players() {
        return this.players;
    }

    @Override
    public EntryCache self() {
        return this.self;
    }

    public Set<Subserver> listedSubservers() {
        return this.listedSubservers;
    }

    public boolean isReal() {
        return this.isReal;
    }

    public static class EntryCache
    extends TabEntryCache {
        public final int index;
        public final boolean isPlayer;
        private Subserver subserver;
        private TabEntry result;

        public EntryCache(TextCache name, int index, int latency, Subserver subserver) {
            super(name, latency);
            this.index = index;
            this.subserver = subserver;
            this.isPlayer = this.result() instanceof MainTabName;
        }

        public EntryCache(TextCache name, int index, int latency, boolean isPlayer, Subserver subserver) {
            super(name, latency);
            this.index = index;
            this.isPlayer = isPlayer;
            this.subserver = subserver;
        }

        @Override
        public TabEntry result() {
            if (this.result == null) {
                this.result = this.createResult();
            }
            return this.result;
        }

        protected TabEntry createResult() {
            MainTabPlayers mainTabPlayers;
            MainTabPing mainTabPing;
            if (this.index % 20 == 0) {
                return MainTabColumn.readFast(StyledStringReader.of(this.original.styledString()));
            }
            if ((this.index == 19 || this.index == 18) && (mainTabPing = MainTabPing.readFast(StyledStringReader.of(this.original.styledString()))).isReal()) {
                return mainTabPing;
            }
            if ((this.index == 18 || this.index == 17) && (mainTabPlayers = MainTabPlayers.readFast(StyledStringReader.of(this.original.styledString()))).isReal()) {
                return mainTabPlayers;
            }
            MainTabName mainTabName = MainTabName.readFast(StyledStringReader.of(this.original.styledString()));
            if (mainTabName.isReal()) {
                return mainTabName;
            }
            return TabEntry.FAILURE;
        }

        @Override
        public boolean isPlayer() {
            return this.isPlayer;
        }

        @Override
        public Subserver subserver() {
            if (this.subserver == Subservers.SURVIVAL_AMBIGUOUS) {
                this.subserver = this.original.styledString().endsWith(SU2) ? Subservers.SURVIVAL2 : Subservers.SURVIVAL;
            }
            return this.subserver;
        }
    }
}

