/*
 * Decompiled with CFR 0.152.
 */
package dev.yatloaf.modkrowd.cubekrowd.tablist;

import dev.yatloaf.modkrowd.ModKrowd;
import dev.yatloaf.modkrowd.cubekrowd.common.CKColor;
import dev.yatloaf.modkrowd.cubekrowd.common.SelfPlayer;
import dev.yatloaf.modkrowd.cubekrowd.common.cache.TextCache;
import dev.yatloaf.modkrowd.cubekrowd.subserver.MinigameSubserver;
import dev.yatloaf.modkrowd.cubekrowd.subserver.Subserver;
import dev.yatloaf.modkrowd.cubekrowd.subserver.Subservers;
import dev.yatloaf.modkrowd.cubekrowd.tablist.MinigameTabName;
import dev.yatloaf.modkrowd.cubekrowd.tablist.TabEntry;
import dev.yatloaf.modkrowd.cubekrowd.tablist.TabList;
import dev.yatloaf.modkrowd.cubekrowd.tablist.cache.TabEntryCache;
import dev.yatloaf.modkrowd.cubekrowd.tablist.cache.TabListCache;
import dev.yatloaf.modkrowd.util.text.StyledString;
import dev.yatloaf.modkrowd.util.text.StyledStringReader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_640;

public final class MinigameTabList
extends Record
implements TabList {
    private final EntryCache[] entries;
    private final EntryCache[] players;
    private final EntryCache self;
    private final Subserver yourGame;
    private final boolean isReal;
    public static final EntryCache[] EMPTY_ENTRIES = new EntryCache[0];
    public static final MinigameTabList FAILURE = new MinigameTabList(EMPTY_ENTRIES, EMPTY_ENTRIES, null, Subservers.NONE, false);
    public static final StyledString YOUR_GAME = StyledString.fromString("Your game", CKColor.GOLD.style.method_10982(Boolean.valueOf(true)));

    public MinigameTabList(EntryCache[] entries, EntryCache[] players, EntryCache self, Subserver yourGame, boolean isReal) {
        this.entries = entries;
        this.players = players;
        this.self = self;
        this.yourGame = yourGame;
        this.isReal = isReal;
    }

    public static MinigameTabList parseFast(TabListCache source) {
        List<class_640> playerListEntries = source.playerListEntries();
        if (playerListEntries.size() < 80) {
            return FAILURE;
        }
        StyledString styledString40 = source.getPlayerName(40).styledString();
        if (!styledString40.strip().equals(ARCKADE)) {
            return FAILURE;
        }
        StyledString styledString61 = source.getPlayerName(61).styledString();
        if (!styledString61.strip().equals(YOUR_GAME)) {
            return FAILURE;
        }
        boolean isLoaded = ModKrowd.currentSubserver.isReal();
        Subserver yourGame = isLoaded ? ModKrowd.currentSubserver : Subservers.UNKNOWN;
        EntryCache[] entries = new EntryCache[playerListEntries.size()];
        ArrayList<EntryCache> playersBuilder = new ArrayList<EntryCache>();
        String selfName = SelfPlayer.username();
        EntryCache self = null;
        for (int index = 0; index < playerListEntries.size(); ++index) {
            EntryCache entryCache;
            class_640 playerListEntry = playerListEntries.get(index);
            TextCache name = source.getPlayerName(index);
            boolean isPlayer = isLoaded && index >= 62 && !name.string().isBlank() && !name.styledString().contains(___AND);
            entries[index] = entryCache = new EntryCache(name, index, playerListEntry.method_2959(), yourGame, isPlayer);
            if (!isPlayer) continue;
            playersBuilder.add(entryCache);
            if (!name.string().equals(selfName)) continue;
            self = entryCache;
        }
        EntryCache[] players = (EntryCache[])playersBuilder.toArray(EntryCache[]::new);
        return new MinigameTabList(entries, players, self, yourGame, true);
    }

    @Override
    public boolean listsSubserver(Subserver subserver) {
        return subserver == this.yourGame;
    }

    @Override
    public boolean isLoaded() {
        return this.yourGame != Subservers.UNKNOWN;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{MinigameTabList.class, "entries;players;self;yourGame;isReal", "entries", "players", "self", "yourGame", "isReal"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MinigameTabList.class, "entries;players;self;yourGame;isReal", "entries", "players", "self", "yourGame", "isReal"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MinigameTabList.class, "entries;players;self;yourGame;isReal", "entries", "players", "self", "yourGame", "isReal"}, this, o);
    }

    public EntryCache[] entries() {
        return this.entries;
    }

    public EntryCache[] players() {
        return this.players;
    }

    @Override
    public EntryCache self() {
        return this.self;
    }

    public Subserver yourGame() {
        return this.yourGame;
    }

    public boolean isReal() {
        return this.isReal;
    }

    public static class EntryCache
    extends TabEntryCache {
        public final int index;
        public final Subserver subserver;
        public final boolean isPlayer;
        private TabEntry result;

        public EntryCache(TextCache name, int index, int latency, Subserver subserver, boolean isPlayer) {
            super(name, latency);
            this.index = index;
            this.subserver = subserver;
            this.isPlayer = isPlayer;
        }

        @Override
        public TabEntry result() {
            if (this.result == null) {
                this.result = this.createResult();
            }
            return this.result;
        }

        protected TabEntry createResult() {
            Subserver subserver;
            if (this.isPlayer && (subserver = this.subserver) instanceof MinigameSubserver) {
                MinigameSubserver minigameSubserver = (MinigameSubserver)subserver;
                MinigameTabName minigameTabName = MinigameTabName.readFast(StyledStringReader.of(this.original.styledString()), minigameSubserver);
                if (minigameTabName.isReal()) {
                    return minigameTabName;
                }
            }
            return TabEntry.FAILURE;
        }

        @Override
        public boolean isPlayer() {
            return this.isPlayer;
        }

        @Override
        public Subserver subserver() {
            return this.subserver;
        }
    }
}

