/*
 * Decompiled with CFR 0.152.
 */
package dev.yatloaf.modkrowd.cubekrowd.tablist;

import dev.yatloaf.modkrowd.ModKrowd;
import dev.yatloaf.modkrowd.cubekrowd.common.SelfPlayer;
import dev.yatloaf.modkrowd.cubekrowd.common.cache.TextCache;
import dev.yatloaf.modkrowd.cubekrowd.subserver.RealSubserver;
import dev.yatloaf.modkrowd.cubekrowd.subserver.Subserver;
import dev.yatloaf.modkrowd.cubekrowd.subserver.Subservers;
import dev.yatloaf.modkrowd.cubekrowd.tablist.TabEntry;
import dev.yatloaf.modkrowd.cubekrowd.tablist.TabList;
import dev.yatloaf.modkrowd.cubekrowd.tablist.cache.TabEntryCache;
import dev.yatloaf.modkrowd.cubekrowd.tablist.cache.TabListCache;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import net.minecraft.class_640;

public final class VanillaTabList
extends Record
implements TabList {
    private final EntryCache[] entries;
    private final EntryCache[] players;
    private final EntryCache self;
    private final Subserver yourGame;
    private final boolean isReal;
    private static final EntryCache[] EMPTY_ENTRIES = new EntryCache[0];
    public static final VanillaTabList FAILURE = new VanillaTabList(EMPTY_ENTRIES, EMPTY_ENTRIES, null, Subservers.NONE, false);

    public VanillaTabList(EntryCache[] entries, EntryCache[] players, EntryCache self, Subserver yourGame, boolean isReal) {
        this.entries = entries;
        this.players = players;
        this.self = self;
        this.yourGame = yourGame;
        this.isReal = isReal;
    }

    public static VanillaTabList parseFast(TabListCache source) {
        List<class_640> playerListEntries = source.playerListEntries();
        if (playerListEntries.isEmpty()) {
            return FAILURE;
        }
        String firstProfileName = playerListEntries.getFirst().method_2966().getName();
        if (firstProfileName.isBlank() || firstProfileName.contains("~")) {
            return FAILURE;
        }
        boolean isLoaded = ModKrowd.currentSubserver instanceof RealSubserver;
        Subserver yourGame = isLoaded ? ModKrowd.currentSubserver : Subservers.UNKNOWN;
        EntryCache[] entries = new EntryCache[playerListEntries.size()];
        String selfName = SelfPlayer.username();
        EntryCache self = null;
        for (int index = 0; index < playerListEntries.size(); ++index) {
            EntryCache entryCache;
            class_640 playerListEntry = playerListEntries.get(index);
            TextCache name = source.getPlayerName(index);
            entries[index] = entryCache = new EntryCache(name, playerListEntry.method_2959(), yourGame);
            if (!name.string().equals(selfName)) continue;
            self = entryCache;
        }
        EntryCache[] players = isLoaded ? entries : EMPTY_ENTRIES;
        return new VanillaTabList(entries, players, self, yourGame, true);
    }

    @Override
    public boolean listsSubserver(Subserver subserver) {
        return subserver == this.yourGame;
    }

    @Override
    public boolean isLoaded() {
        return this.yourGame != Subservers.UNKNOWN;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{VanillaTabList.class, "entries;players;self;yourGame;isReal", "entries", "players", "self", "yourGame", "isReal"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{VanillaTabList.class, "entries;players;self;yourGame;isReal", "entries", "players", "self", "yourGame", "isReal"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{VanillaTabList.class, "entries;players;self;yourGame;isReal", "entries", "players", "self", "yourGame", "isReal"}, this, o);
    }

    public EntryCache[] entries() {
        return this.entries;
    }

    public EntryCache[] players() {
        return this.players;
    }

    @Override
    public EntryCache self() {
        return this.self;
    }

    public Subserver yourGame() {
        return this.yourGame;
    }

    public boolean isReal() {
        return this.isReal;
    }

    public static class EntryCache
    extends TabEntryCache {
        public final Subserver subserver;

        public EntryCache(TextCache name, int latency, Subserver subserver) {
            super(name, latency);
            this.subserver = subserver;
        }

        @Override
        public TabEntry result() {
            return TabEntry.FAILURE;
        }

        @Override
        public boolean isPlayer() {
            return true;
        }

        @Override
        public Subserver subserver() {
            return this.subserver;
        }
    }
}

