/*
 * Decompiled with CFR 0.152.
 */
package dev.yatloaf.modkrowd.util;

import it.unimi.dsi.fastutil.chars.Char2CharMap;
import it.unimi.dsi.fastutil.chars.Char2CharOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.VersionParsingException;
import net.minecraft.class_2596;
import net.minecraft.class_634;
import net.minecraft.class_7472;

public final class Util {
    private static final Char2CharMap NUMERAL_TO_SUPERSCRIPT = new Char2CharOpenHashMap();

    public static String superscript(int n) {
        char[] chars = String.valueOf(n).toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = NUMERAL_TO_SUPERSCRIPT.get(chars[i]);
        }
        return String.valueOf(chars);
    }

    public static String normalizeIntOr(String s, String fallback) {
        try {
            return Integer.toString(Integer.parseInt(s));
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    public static int parseIntOr(String s, int fallback) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return fallback;
        }
    }

    public static <T, R> R[] listToArray(List<T> list, Function<T, R> mapper, IntFunction<R[]> generator) {
        return list.stream().map(mapper).toArray(generator);
    }

    public static <T, K, V> Map<K, V> arrayToMap(T[] arr, Function<T, K> keyMapper, Function<T, V> valueMapper) {
        return Arrays.stream(arr).collect(Collectors.toMap(keyMapper, valueMapper));
    }

    @Deprecated(forRemoval=true, since="0.1.1")
    public static SemanticVersion constVersion(String s) {
        try {
            return SemanticVersion.parse((String)s);
        }
        catch (VersionParsingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void sendCommandPacket(class_634 handler, String command) {
        handler.method_52787((class_2596)new class_7472(command));
    }

    static {
        NUMERAL_TO_SUPERSCRIPT.put('0', '\u2070');
        NUMERAL_TO_SUPERSCRIPT.put('1', '\u00b9');
        NUMERAL_TO_SUPERSCRIPT.put('2', '\u00b2');
        NUMERAL_TO_SUPERSCRIPT.put('3', '\u00b3');
        NUMERAL_TO_SUPERSCRIPT.put('4', '\u2074');
        NUMERAL_TO_SUPERSCRIPT.put('5', '\u2075');
        NUMERAL_TO_SUPERSCRIPT.put('6', '\u2076');
        NUMERAL_TO_SUPERSCRIPT.put('7', '\u2077');
        NUMERAL_TO_SUPERSCRIPT.put('8', '\u2078');
        NUMERAL_TO_SUPERSCRIPT.put('9', '\u2079');
        NUMERAL_TO_SUPERSCRIPT.put('-', '\u207b');
    }
}

