/*
 * Decompiled with CFR 0.152.
 */
package dev.yatloaf.modkrowd;

import dev.yatloaf.modkrowd.config.Config;
import dev.yatloaf.modkrowd.config.SyncedConfig;
import dev.yatloaf.modkrowd.config.screen.ConfigScreen;
import dev.yatloaf.modkrowd.cubekrowd.common.CubeKrowd;
import dev.yatloaf.modkrowd.cubekrowd.message.KickedMessage;
import dev.yatloaf.modkrowd.cubekrowd.message.WhereamiMessage;
import dev.yatloaf.modkrowd.cubekrowd.message.cache.CubeKrowdMessageCache;
import dev.yatloaf.modkrowd.cubekrowd.message.cache.MessageCache;
import dev.yatloaf.modkrowd.cubekrowd.subserver.CubeKrowdSubserver;
import dev.yatloaf.modkrowd.cubekrowd.subserver.MissileWarsSubserver;
import dev.yatloaf.modkrowd.cubekrowd.subserver.Subserver;
import dev.yatloaf.modkrowd.cubekrowd.subserver.Subservers;
import dev.yatloaf.modkrowd.cubekrowd.tablist.cache.TabListCache;
import dev.yatloaf.modkrowd.mixin.ClientCommonNetworkHandlerAccessor;
import dev.yatloaf.modkrowd.mixin.KeyBindingAccessor;
import dev.yatloaf.modkrowd.util.Util;
import java.io.File;
import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_408;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_642;
import net.minecraft.class_8674;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModKrowd
implements ClientModInitializer {
    public static final String MODID = "modkrowd";
    public static final Version VERSION = ((ModContainer)FabricLoader.getInstance().getModContainer("modkrowd").orElseThrow(AssertionError::new)).getMetadata().getVersion();
    public static final Object USELESS = new Object();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"modkrowd");
    public static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("modkrowd.json").toFile();
    public static final SyncedConfig CONFIG = new SyncedConfig();
    public static Subserver currentSubserver = Subservers.NONE;
    public static TabListCache currentTabListCache = null;
    public static long tick = 0L;
    public static class_304 OPTIONS_KEY;
    public static class_304 TOGGLE_MESSAGE_PREVIEW_KEY;
    public static class_304 NEXT_SUBSERVER_KEY;
    public static boolean INIT;
    private static boolean pendingTabListCache;
    private static MwSwitchStatus mwSwitchStatus;
    private static long mwSwitchTick;
    private static int mwSwitchIndex;

    public void onInitializeClient() {
        String[] hello = new String[]{"[ModKrowd] Haiii world :3", "[ModKrowd] Hewwo world ^w^", "[ModKrowd] Greetings Earth!"};
        LOGGER.info(hello[ThreadLocalRandom.current().nextInt(hello.length)]);
        OPTIONS_KEY = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.modkrowd.options", class_3675.class_307.field_1668, -1, "category.modkrowd"));
        TOGGLE_MESSAGE_PREVIEW_KEY = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.modkrowd.toggle_message_preview", class_3675.class_307.field_1668, -1, "category.modkrowd"));
        NEXT_SUBSERVER_KEY = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.modkrowd.next_subserver", class_3675.class_307.field_1668, -1, "category.modkrowd"));
        INIT = true;
        ClientConfigurationConnectionEvents.COMPLETE.register(ModKrowd::onConfigurationComplete);
        ClientPlayConnectionEvents.JOIN.register(ModKrowd::onJoin);
        ClientPlayConnectionEvents.DISCONNECT.register(ModKrowd::onDisconnect);
        ClientTickEvents.END_CLIENT_TICK.register(ModKrowd::onEndClientTick);
        ClientLifecycleEvents.CLIENT_STOPPING.register(ModKrowd::onClientStopping);
        CONFIG.tryDeserialize(CONFIG_FILE);
        CONFIG.onInitEnable(class_310.method_1551());
    }

    public static void invalidateTabListCache() {
        pendingTabListCache = true;
    }

    public static void checkTabListCache() {
        TabListCache candidate;
        if (pendingTabListCache && (candidate = TabListCache.tryNew()) != null) {
            pendingTabListCache = false;
            currentTabListCache = candidate;
            CONFIG.onTabList(currentTabListCache);
        }
    }

    public static ConfigScreen createConfigScreen(class_437 parent) {
        return new ConfigScreen(parent, CONFIG, ModKrowd::saveConfig, ModKrowd::cancelConfig);
    }

    private static void saveConfig(Config config) {
        CONFIG.copyFromConfig(config);
        CONFIG.trySerialize(CONFIG_FILE);
    }

    private static void cancelConfig(Config config) {
        CONFIG.updateTab(config);
    }

    public static void startSwitchingMissileWarsLobby(int delay) {
        if (mwSwitchStatus != MwSwitchStatus.CONNECTING) {
            mwSwitchTick = tick + (long)delay;
            mwSwitchStatus = MwSwitchStatus.DELAY;
            ModKrowd.tickSwitchingMissileWarsLobby();
        }
    }

    private static void tickSwitchingMissileWarsLobby() {
        class_310 client = class_310.method_1551();
        if (mwSwitchStatus == MwSwitchStatus.DELAY && mwSwitchTick <= tick && !(client.field_1755 instanceof class_408)) {
            MissileWarsSubserver mwSubserver;
            Subserver subserver;
            class_634 handler = client.method_1562();
            mwSwitchStatus = handler != null && (subserver = currentSubserver) instanceof MissileWarsSubserver && (mwSubserver = (MissileWarsSubserver)subserver).tryConnectNext(handler, mwSwitchIndex) ? MwSwitchStatus.CONNECTING : MwSwitchStatus.IDLE;
        }
    }

    private static void onConfigurationComplete(class_8674 handler, class_310 client) {
        class_642 info = ((ClientCommonNetworkHandlerAccessor)handler).getServerInfo();
        currentSubserver = info != null && CubeKrowd.addressIsCubeKrowd(info.field_3761) ? Subservers.PENDING : Subservers.NONE;
        CONFIG.updateFeatures();
        CONFIG.onConfigurationComplete(handler, client);
    }

    private static void onJoin(class_634 handler, PacketSender sender, class_310 client) {
        ModKrowd.invalidateTabListCache();
        mwSwitchStatus = MwSwitchStatus.IDLE;
        mwSwitchTick = 0L;
        mwSwitchIndex = 0;
        if (currentSubserver instanceof CubeKrowdSubserver) {
            Util.sendCommandPacket(handler, "whereami");
        }
        CONFIG.onJoin(handler, client);
    }

    private static void onDisconnect(class_634 handler, class_310 client) {
        currentSubserver = Subservers.NONE;
        CONFIG.onDisconnect(handler, client);
        CONFIG.updateFeatures();
    }

    private static void onEndClientTick(class_310 client) {
        ++tick;
        ModKrowd.tickSwitchingMissileWarsLobby();
        ModKrowd.tickKeys(client);
        ModKrowd.checkTabListCache();
        CONFIG.onEndTick(client);
    }

    private static void tickKeys(class_310 client) {
        if (OPTIONS_KEY.method_1436()) {
            client.method_1507((class_437)ModKrowd.createConfigScreen(client.field_1755));
            ((KeyBindingAccessor)OPTIONS_KEY).callReset();
        }
        if (NEXT_SUBSERVER_KEY.method_1436()) {
            ModKrowd.startSwitchingMissileWarsLobby(0);
            ((KeyBindingAccessor)NEXT_SUBSERVER_KEY).callReset();
        }
    }

    private static void onClientStopping(class_310 client) {
        CONFIG.trySerialize(CONFIG_FILE);
    }

    public static void onMessage(MessageCache message) {
        class_310 client = class_310.method_1551();
        if (message instanceof CubeKrowdMessageCache) {
            Subserver subserver;
            WhereamiMessage whereamiMessage;
            CubeKrowdMessageCache ckCache = (CubeKrowdMessageCache)message;
            if (currentSubserver == Subservers.PENDING && (whereamiMessage = ckCache.whereamiMessageFast()).isReal()) {
                currentSubserver = whereamiMessage.subserver();
                CONFIG.updateFeatures();
                CONFIG.onJoinUpdated(client.method_1562(), client);
                message.setBlocked(true);
                return;
            }
            if (mwSwitchStatus == MwSwitchStatus.CONNECTING && (subserver = currentSubserver) instanceof MissileWarsSubserver) {
                MissileWarsSubserver mwSubserver = (MissileWarsSubserver)subserver;
                KickedMessage kickedMessage = ckCache.kickedMessageFast();
                if ((kickedMessage.isReal() && kickedMessage.subserver() instanceof MissileWarsSubserver || ckCache.unavailableMessageFast().isReal()) && !mwSubserver.tryConnectNext(client.method_1562(), ++mwSwitchIndex)) {
                    mwSwitchStatus = MwSwitchStatus.IDLE;
                    mwSwitchTick = 0L;
                    mwSwitchIndex = 0;
                }
            }
        }
        CONFIG.onMessage(message, client);
    }

    static {
        INIT = false;
        pendingTabListCache = true;
        mwSwitchStatus = MwSwitchStatus.IDLE;
        mwSwitchTick = 0L;
        mwSwitchIndex = 0;
    }

    private static enum MwSwitchStatus {
        IDLE,
        DELAY,
        CONNECTING;

    }
}

