/*
 * Decompiled with CFR 0.152.
 */
package dev.yatloaf.modkrowd.config.feature;

import dev.yatloaf.modkrowd.config.ActionQueue;
import dev.yatloaf.modkrowd.config.PredicateIndex;
import dev.yatloaf.modkrowd.config.feature.CherryLiteThemeFeature;
import dev.yatloaf.modkrowd.cubekrowd.common.Afk;
import dev.yatloaf.modkrowd.cubekrowd.common.CKColor;
import dev.yatloaf.modkrowd.cubekrowd.common.LatencyLevel;
import dev.yatloaf.modkrowd.cubekrowd.common.MinigameTeam;
import dev.yatloaf.modkrowd.cubekrowd.common.MinigameTeamName;
import dev.yatloaf.modkrowd.cubekrowd.common.Rank;
import dev.yatloaf.modkrowd.cubekrowd.common.RankBrackets;
import dev.yatloaf.modkrowd.cubekrowd.common.RankLetters;
import dev.yatloaf.modkrowd.cubekrowd.common.RankName;
import dev.yatloaf.modkrowd.cubekrowd.common.cache.TextCache;
import dev.yatloaf.modkrowd.cubekrowd.message.MissileWarsDeathMessage;
import dev.yatloaf.modkrowd.cubekrowd.tablist.GameTabStatus;
import dev.yatloaf.modkrowd.cubekrowd.tablist.GameTabSubserver;
import dev.yatloaf.modkrowd.cubekrowd.tablist.MainTabColumn;
import dev.yatloaf.modkrowd.cubekrowd.tablist.MainTabName;
import dev.yatloaf.modkrowd.cubekrowd.tablist.MinigameTabName;
import dev.yatloaf.modkrowd.cubekrowd.tablist.TabCentered;
import dev.yatloaf.modkrowd.cubekrowd.tablist.TabEntry;
import dev.yatloaf.modkrowd.cubekrowd.tablist.TabPing;
import dev.yatloaf.modkrowd.cubekrowd.tablist.cache.TabEntryCache;
import dev.yatloaf.modkrowd.custom.Custom;
import dev.yatloaf.modkrowd.custom.MissileWarsTieMessage;
import dev.yatloaf.modkrowd.custom.SelfAlohaMessage;
import dev.yatloaf.modkrowd.util.Util;
import dev.yatloaf.modkrowd.util.text.StyledString;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.jetbrains.annotations.Nullable;

public class CherryThemeFeature
extends CherryLiteThemeFeature {
    private static final class_5250 MW_TIE_RED = MissileWarsTieMessage.RED.method_27661().method_10862(class_2583.field_24360.method_27703(CHERRY3));
    private static final class_5250 MW_TIE_GREEN = MissileWarsTieMessage.GREEN.method_27661().method_10862(class_2583.field_24360.method_27703(CHERRY6));
    private static final TextCache MW_TIE_SIMULTANEOUS = TextCache.of(MissileWarsTieMessage.SIMULTANEOUS.text().method_27661().method_10862(class_2583.field_24360.method_27703(CHERRY4).method_10978(Boolean.valueOf(true))));

    public CherryThemeFeature(String id, PredicateIndex allowedPredicates) {
        super(id, allowedPredicates);
    }

    @Override
    protected TextCache missileWarsDeathMessage(MissileWarsDeathMessage message) {
        MissileWarsDeathMessage modifiedMessage = message.mapVictim(this::modifyMissileWarsTeamName).mapKillerIfPresent(this::modifyMissileWarsTeamName);
        return super.missileWarsDeathMessage(modifiedMessage);
    }

    protected class_2561 modifyMissileWarsTeamName(class_2561 original) {
        CKColor cKColor = CKColor.fromStyle(original.method_10866());
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"RED", "GREEN"}, (CKColor)cKColor, n)) {
            case 0 -> original.method_27661().method_27696(class_2583.field_24360.method_27703(CHERRY3));
            case 1 -> original.method_27661().method_27696(class_2583.field_24360.method_27703(CHERRY6));
            default -> original;
        };
    }

    @Override
    protected void onTabEntry(TabEntryCache entry) {
        super.onTabEntry(entry);
        TabEntry tabEntry = entry.result();
        Objects.requireNonNull(tabEntry);
        TabEntry tabEntry2 = tabEntry;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MainTabName.class, MinigameTabName.class}, (Object)tabEntry2, n)) {
            case 0: {
                MainTabName mainTabName = (MainTabName)tabEntry2;
                entry.setThemed(this.mainTabName(mainTabName));
                break;
            }
            case 1: {
                MinigameTabName minigameTabName = (MinigameTabName)tabEntry2;
                entry.setThemed(this.minigameTabName(minigameTabName));
                break;
            }
        }
        entry.setLatencyThemed(this.formatLatency(entry.latency));
    }

    @Override
    @Nullable
    protected StyledString tabCentered(TabCentered<?> tabCentered) {
        StyledString sup = super.tabCentered(tabCentered);
        if (sup != null) {
            return sup;
        }
        Object obj = tabCentered.content();
        Objects.requireNonNull(obj);
        Object obj2 = obj;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GameTabSubserver.class, GameTabStatus.class}, obj2, n)) {
            case 0 -> {
                GameTabSubserver gameTabSubserver = (GameTabSubserver)obj2;
                yield this.gameTabSubserver(gameTabSubserver);
            }
            case 1 -> {
                GameTabStatus gameTabStatus = (GameTabStatus)obj2;
                yield this.gameTabStatus(gameTabStatus);
            }
            default -> null;
        };
    }

    @Nullable
    protected StyledString gameTabSubserver(GameTabSubserver gameTabSubserver) {
        return gameTabSubserver.subserverName().mapStyle(style -> {
            CKColor selector0$temp = CKColor.fromStyle(style);
            int index$1 = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"DARK_PURPLE", "BLUE", "RED", "FESTIVE_RED", "DARK_AQUA", "CRIMSON", "GOLD", "FESTIVE_GREEN", "GREEN", "SKY", "AQUA"}, (CKColor)selector0$temp, index$1)) {
                case 0 -> style.method_27703(CHERRY1);
                case 1, 2, 3 -> style.method_27703(CHERRY2);
                case 4, 5 -> style.method_27703(CHERRY3);
                case 6, 7 -> style.method_27703(CHERRY4);
                case 8, 9 -> style.method_27703(CHERRY5);
                case 10 -> style.method_27703(CHERRY6);
                default -> style;
            };
        });
    }

    @Nullable
    protected StyledString gameTabStatus(GameTabStatus gameTabStatus) {
        return switch (gameTabStatus) {
            case GameTabStatus.ONLINE -> gameTabStatus.text.fillColor(CHERRY6);
            case GameTabStatus.OFFLINE -> gameTabStatus.text.fillColor(CHERRY3);
            default -> gameTabStatus.text;
        };
    }

    @Override
    protected TextCache tabPing(TabPing ping) {
        return TextCache.of(StyledString.concat(TabPing.YOUR_PING_.fillColor(CHERRY5), StyledString.fromString(" " + ping.latency() + "ms", class_2583.field_24360.method_27703(CHERRY6))));
    }

    @Override
    protected TextCache mainTabColumn(MainTabColumn column) {
        return TextCache.of(column.appearance().fillColor(column.online() ? CHERRY4 : CHERRY1));
    }

    protected TextCache mainTabName(MainTabName mainTabName) {
        return TextCache.of(StyledString.concat(this.afk(mainTabName.afk()), this.rankName(mainTabName.rankName())));
    }

    protected TextCache minigameTabName(MinigameTabName tabName) {
        return TextCache.of(StyledString.concat(this.afk(tabName.afk()), this.minigameTeamName(tabName.teamName())));
    }

    protected StyledString afk(Afk afk) {
        return afk.star.fillColor(CHERRY2);
    }

    @Override
    protected StyledString rankName(RankName rankName) {
        Rank rank = rankName.rank();
        class_5251 nameColor = this.colorNameFromRank(rank);
        class_5251 bracketsColor = this.colorBrackets(rank);
        return StyledString.concat(rank.pipes().pipe.fillColor(CHERRY4), rank.brackets().leftBracket.fillColor(bracketsColor), rank.letters().letter.fillColor(CHERRY6), rank.brackets().rightBracket.fillColor(bracketsColor), rank.pipes().pipe.fillColor(CHERRY4), StyledString.SPACE, rankName.name().fillColor(nameColor));
    }

    @Override
    protected StyledString minigameTeamName(MinigameTeamName teamName) {
        class_5251 teamColor = this.colorNameFromTeam(teamName.team());
        return teamName.name().fillColor(teamColor);
    }

    protected class_5251 colorBrackets(Rank rank) {
        return switch (rank.brackets()) {
            case RankBrackets.NONE -> CHERRY1;
            case RankBrackets.YELLOW -> CHERRY5;
            case RankBrackets.GOLD -> CHERRY3;
            default -> CKColor.WHITE.textColor;
        };
    }

    protected class_5251 colorNameFromRank(Rank rank) {
        return switch (rank.letters()) {
            case RankLetters.GUEST -> CHERRY5;
            case RankLetters.MEMBER, RankLetters.BUILDER -> CHERRY6;
            case RankLetters.TRUSTED -> CHERRY3;
            case RankLetters.RESPECTED -> CHERRY2;
            case RankLetters.VETERAN, RankLetters.DEVELOPER -> CHERRY1;
            case RankLetters.SPECIAL_GUEST, RankLetters.YOUTUBE, RankLetters.ZIPKROWD -> CHERRY4;
            case RankLetters.HELPER -> CHERRY3;
            case RankLetters.MODERATOR -> CHERRY3;
            case RankLetters.ADMIN -> CHERRY5;
            default -> CKColor.WHITE.textColor;
        };
    }

    protected class_5251 colorNameFromTeam(MinigameTeam team) {
        return switch (team) {
            case MinigameTeam.MW_LOBBY, MinigameTeam.RR_LOBBY, MinigameTeam.CC_LOBBY -> CHERRY1;
            case MinigameTeam.MW_SPECTATOR, MinigameTeam.RR_SPECTATOR, MinigameTeam.IR_SPECTATOR, MinigameTeam.FS, MinigameTeam.CC_SPECTATOR -> CHERRY4;
            case MinigameTeam.MW_RED, MinigameTeam.RR_BLUE, MinigameTeam.IR_RED, MinigameTeam.CC_PURPLE -> CHERRY3;
            case MinigameTeam.MW_GREEN, MinigameTeam.RR_YELLOW, MinigameTeam.IR_GREEN, MinigameTeam.CC_ORANGE -> CHERRY6;
            default -> CKColor.WHITE.textColor;
        };
    }

    protected TextCache formatLatency(int latency) {
        class_5251 color = this.colorLatencyLevel(LatencyLevel.fromLatency(latency));
        return TextCache.of(class_2561.method_43470((String)Util.superscript(latency)).method_10862(class_2583.field_24360.method_27703(color)));
    }

    protected class_5251 colorLatencyLevel(LatencyLevel level) {
        return switch (level) {
            default -> throw new MatchException(null, null);
            case LatencyLevel.UNKNOWN -> CHERRY6;
            case LatencyLevel.L1 -> CHERRY5;
            case LatencyLevel.L2 -> CHERRY4;
            case LatencyLevel.L3 -> CHERRY3;
            case LatencyLevel.L4 -> CHERRY2;
            case LatencyLevel.L5 -> CHERRY1;
        };
    }

    @Override
    public TextCache themeCustom(Custom custom, class_310 client, ActionQueue queue) {
        Custom custom2 = custom;
        Objects.requireNonNull(custom2);
        Custom custom3 = custom2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SelfAlohaMessage.class, MissileWarsTieMessage.class}, (Object)custom3, n)) {
            case 0 -> {
                SelfAlohaMessage selfAlohaMessage = (SelfAlohaMessage)custom3;
                yield this.selfAlohaMessage(selfAlohaMessage);
            }
            case 1 -> {
                MissileWarsTieMessage missileWarsTieMessage = (MissileWarsTieMessage)custom3;
                yield this.missileWarsTieMessage(missileWarsTieMessage);
            }
            default -> TextCache.EMPTY;
        };
    }

    public TextCache selfAlohaMessage(SelfAlohaMessage selfAlohaMessage) {
        return TextCache.of(selfAlohaMessage.appearance().text().method_10862(class_2583.field_24360.method_27703(CHERRY5)));
    }

    public TextCache missileWarsTieMessage(MissileWarsTieMessage missileWarsTieMessage) {
        class_5250 last;
        class_5250 first;
        long deltaTicks;
        long greenWinTick;
        long redWinTick = missileWarsTieMessage.redWinTick();
        if (redWinTick == (greenWinTick = missileWarsTieMessage.greenWinTick())) {
            return MW_TIE_SIMULTANEOUS;
        }
        if (redWinTick < greenWinTick) {
            deltaTicks = greenWinTick - redWinTick;
            first = MW_TIE_RED;
            last = MW_TIE_GREEN;
        } else {
            deltaTicks = redWinTick - greenWinTick;
            first = MW_TIE_GREEN;
            last = MW_TIE_RED;
        }
        return TextCache.of(MissileWarsTieMessage.sequential(first, last, deltaTicks).method_10862(class_2583.field_24360.method_27703(CHERRY2).method_10978(Boolean.valueOf(true))));
    }
}

