/*
 * Decompiled with CFR 0.152.
 */
package dev.yatloaf.modkrowd.config.screen;

import dev.yatloaf.modkrowd.ModKrowd;
import dev.yatloaf.modkrowd.config.Config;
import dev.yatloaf.modkrowd.config.SyncedConfig;
import dev.yatloaf.modkrowd.config.exception.ConfigException;
import dev.yatloaf.modkrowd.config.screen.ConfigTab;
import dev.yatloaf.modkrowd.util.Util;
import net.minecraft.class_2561;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_8030;
import net.minecraft.class_8087;
import net.minecraft.class_8088;
import net.minecraft.class_8089;

public class ConfigScreen
extends class_437 {
    public final class_437 parent;
    public final Config config;
    public final Save save;
    public final Cancel cancel;
    public final ConfigTab[] tabs;
    private final class_8088 tabManager;
    private final class_8089 tabNavigation;
    public final class_4185 reloadButton;
    public final class_4185 cancelButton;
    public final class_4185 doneButton;

    public ConfigScreen(class_437 parent, SyncedConfig config, Save save, Cancel cancel) {
        super((class_2561)class_2561.method_43471((String)"modkrowd.config.title"));
        this.parent = parent;
        this.config = config.copyConfig();
        this.save = save;
        this.cancel = cancel;
        this.tabs = Util.listToArray(this.config.tabs, ConfigTab::new, ConfigTab[]::new);
        this.tabManager = new class_8088(x$0 -> {
            class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
        }, x$0 -> this.method_37066((class_364)x$0));
        this.tabNavigation = class_8089.method_48623((class_8088)this.tabManager, (int)this.field_22789).method_48631((class_8087[])this.tabs).method_48627();
        this.reloadButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reload"), this::onReloadButton).method_46431();
        this.cancelButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), this::onCancelButton).method_46431();
        this.doneButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Done"), this::onDoneButton).method_46431();
    }

    private void onReloadButton(class_4185 button) {
        try {
            this.config.deserialize(ModKrowd.CONFIG_FILE);
            for (ConfigTab t : this.tabs) {
                t.refreshState();
            }
        }
        catch (ConfigException e) {
            ModKrowd.LOGGER.error("[ConfigScreen] Couldn't load config!", (Throwable)e);
        }
    }

    private void onCancelButton(class_4185 button) {
        this.cancelAndClose();
    }

    private void onDoneButton(class_4185 button) {
        this.saveAndClose();
    }

    private void cancelAndClose() {
        this.updateConfig();
        this.cancel.cancel(this.config);
        this.method_25419();
    }

    private void saveAndClose() {
        this.updateConfig();
        this.save.save(this.config);
        this.method_25419();
    }

    private void updateConfig() {
        ConfigTab currentTab = (ConfigTab)this.tabManager.method_48614();
        assert (currentTab != null);
        this.config.selectedTab = currentTab.tab;
    }

    protected void method_25426() {
        this.tabNavigation.method_48618(this.field_22789);
        this.tabNavigation.method_49613();
        int contentTop = this.tabNavigation.method_48202().method_49619();
        class_8030 tabArea = new class_8030(0, contentTop, this.field_22789, this.field_22790 - contentTop - 36);
        this.tabManager.method_48616(tabArea);
        this.reloadButton.method_55444(64, 20, this.field_22789 - 216, this.field_22790 - 28);
        this.cancelButton.method_55444(64, 20, this.field_22789 - 144, this.field_22790 - 28);
        this.doneButton.method_55444(64, 20, this.field_22789 - 72, this.field_22790 - 28);
        this.method_37063((class_364)this.tabNavigation);
        class_8087 currentTab = this.tabManager.method_48614();
        if (currentTab == null) {
            this.tabNavigation.method_48987(this.config.selectedTab.index, false);
        } else {
            currentTab.method_48612(x$0 -> {
                class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
            });
        }
        this.method_37063((class_364)this.reloadButton);
        this.method_37063((class_364)this.cancelButton);
        this.method_37063((class_364)this.doneButton);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.saveAndClose();
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(this.parent);
        }
    }

    @FunctionalInterface
    public static interface Save {
        public void save(Config var1);
    }

    @FunctionalInterface
    public static interface Cancel {
        public void cancel(Config var1);
    }
}

