/*
 * Decompiled with CFR 0.152.
 */
package dev.yatloaf.modkrowd.cubekrowd.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.yatloaf.modkrowd.ModKrowd;
import dev.yatloaf.modkrowd.cubekrowd.command.PreviewResult;
import dev.yatloaf.modkrowd.cubekrowd.common.CKColor;
import dev.yatloaf.modkrowd.cubekrowd.common.CubeKrowd;
import dev.yatloaf.modkrowd.cubekrowd.common.RankBrackets;
import dev.yatloaf.modkrowd.cubekrowd.common.SelfPlayer;
import dev.yatloaf.modkrowd.cubekrowd.common.cache.TextCache;
import dev.yatloaf.modkrowd.cubekrowd.message.DirectMessage;
import dev.yatloaf.modkrowd.cubekrowd.message.Direction;
import dev.yatloaf.modkrowd.cubekrowd.subserver.MainSubserver;
import dev.yatloaf.modkrowd.util.Util;
import dev.yatloaf.modkrowd.util.text.StyledString;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public final class PreviewCommands {
    private static final CommandDispatcher<Object> DISPATCHER = new CommandDispatcher();

    @NotNull
    public static TextCache preview(@NotNull String args) {
        if (args.startsWith("/")) {
            try {
                DISPATCHER.execute(args.substring(1), ModKrowd.USELESS);
                return TextCache.EMPTY;
            }
            catch (PreviewResult r) {
                return r.value;
            }
            catch (CommandSyntaxException e) {
                return TextCache.EMPTY;
            }
        }
        if (args.isEmpty()) {
            return TextCache.EMPTY;
        }
        TextCache chat = ModKrowd.currentSubserver.formatChat(args);
        if (chat == TextCache.EMPTY) {
            return TextCache.EMPTY;
        }
        return CubeKrowd.censor(chat);
    }

    public static void command(LiteralArgumentBuilder<Object> previewer, String ... aliases) {
        LiteralCommandNode node = DISPATCHER.register(previewer);
        for (String alias : aliases) {
            LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)alias).requires(node.getRequirement())).forward(node.getRedirect(), node.getRedirectModifier(), node.isFork())).executes(node.getCommand());
            for (CommandNode child : node.getChildren()) {
                builder.then(child);
            }
            DISPATCHER.register(builder);
        }
    }

    public static void chattymote0(String format, String canonical, String ... aliases) {
        PreviewCommands.command((LiteralArgumentBuilder<Object>)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)canonical).executes(context -> {
            PreviewCommands.checkChattymote();
            throw PreviewCommands.result(class_2561.method_43470((String)format.formatted(SelfPlayer.username())).method_27692(class_124.field_1076));
        })), aliases);
    }

    public static void chattymote1(String format, String canonical, String ... aliases) {
        PreviewCommands.command((LiteralArgumentBuilder<Object>)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)canonical).then(RequiredArgumentBuilder.argument((String)"arg1", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            PreviewCommands.checkChattymote();
            String arg1 = StringArgumentType.getString((CommandContext)context, (String)"arg1");
            throw PreviewCommands.result(class_2561.method_43470((String)format.formatted(SelfPlayer.username(), arg1)).method_27692(class_124.field_1076));
        }))), aliases);
    }

    public static void chattymote2(String format, String canonical, String ... aliases) {
        PreviewCommands.command((LiteralArgumentBuilder<Object>)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)canonical).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"arg1", (ArgumentType)StringArgumentType.word()).executes(context -> {
            PreviewCommands.checkChattymote();
            String arg1 = StringArgumentType.getString((CommandContext)context, (String)"arg1");
            String arg2 = "2";
            throw PreviewCommands.result(class_2561.method_43470((String)format.formatted(SelfPlayer.username(), arg1, arg2)).method_27692(class_124.field_1076));
        })).then(RequiredArgumentBuilder.argument((String)"arg2", (ArgumentType)StringArgumentType.word()).executes(context -> {
            PreviewCommands.checkChattymote();
            String arg1 = StringArgumentType.getString((CommandContext)context, (String)"arg1");
            String arg2 = StringArgumentType.getString((CommandContext)context, (String)"arg2");
            throw PreviewCommands.result(class_2561.method_43470((String)format.formatted(SelfPlayer.username(), arg1, arg2)).method_27692(class_124.field_1076));
        })))), aliases);
    }

    public static void chattymoteV(String format0, String format1, String canonical, String ... aliases) {
        PreviewCommands.command((LiteralArgumentBuilder<Object>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)canonical).executes(context -> {
            PreviewCommands.checkChattymote();
            throw PreviewCommands.result(class_2561.method_43470((String)format0.formatted(SelfPlayer.username())).method_27692(class_124.field_1076));
        })).then(RequiredArgumentBuilder.argument((String)"arg1", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            PreviewCommands.checkChattymote();
            String arg1 = StringArgumentType.getString((CommandContext)context, (String)"arg1");
            throw PreviewCommands.result(class_2561.method_43470((String)format1.formatted(SelfPlayer.username(), arg1)).method_27692(class_124.field_1076));
        }))), aliases);
    }

    public static void checkChattymote() throws PreviewResult {
        if (!(ModKrowd.currentSubserver instanceof MainSubserver)) {
            throw PreviewCommands.result(class_2561.method_43470((String)"Not available on this server").method_27692(class_124.field_1061));
        }
        if (SelfPlayer.rankNameSoft().rank().brackets() == RankBrackets.NONE) {
            throw PreviewCommands.result(class_2561.method_43470((String)"Yellow brackets required").method_27692(class_124.field_1061));
        }
    }

    public static PreviewResult result(class_5250 value) {
        return new PreviewResult(TextCache.of(value));
    }

    public static PreviewResult result(StyledString value) {
        return new PreviewResult(TextCache.of(value));
    }

    public static PreviewResult result(TextCache value) {
        return new PreviewResult(value);
    }

    static {
        PreviewCommands.command((LiteralArgumentBuilder<Object>)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"message").then(RequiredArgumentBuilder.argument((String)"target", (ArgumentType)StringArgumentType.word()).then(RequiredArgumentBuilder.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            String target = StringArgumentType.getString((CommandContext)context, (String)"target");
            String message = StringArgumentType.getString((CommandContext)context, (String)"message");
            if (SelfPlayer.username().equals(target)) {
                throw PreviewCommands.result(new DirectMessage(Direction.LOOP, "me", "me", StyledString.fromString(message, CKColor.GOLD.style), true).appearance());
            }
            throw PreviewCommands.result(new DirectMessage(Direction.OUTGOING, "me", target, StyledString.fromString(message, CKColor.GOLD.style), true).appearance());
        })))), "msg", "m");
        PreviewCommands.command((LiteralArgumentBuilder<Object>)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"reply").then(RequiredArgumentBuilder.argument((String)"message", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            if (ModKrowd.CONFIG.MESSAGE_PREVIEW.replyTarget == null) {
                throw PreviewCommands.result(class_2561.method_43470((String)"No reply target").method_27692(class_124.field_1061));
            }
            String target = ModKrowd.CONFIG.MESSAGE_PREVIEW.replyTarget;
            String message = StringArgumentType.getString((CommandContext)context, (String)"message");
            if (SelfPlayer.username().equals(target)) {
                throw PreviewCommands.result(new DirectMessage(Direction.LOOP, "me", "me", StyledString.fromString(message, CKColor.GOLD.style), true).appearance());
            }
            throw PreviewCommands.result(new DirectMessage(Direction.OUTGOING, "me", target, StyledString.fromString(message, CKColor.GOLD.style), true).appearance());
        }))), "r");
        PreviewCommands.chattymote0("Sorry, %s is unauthorized access to use this command", "401", new String[0]);
        PreviewCommands.chattymoteV("%s appreciates it", "%s appreciates %s", "appreciate", new String[0]);
        PreviewCommands.chattymoteV("%s barks", "%s barks at %s", "bark", new String[0]);
        PreviewCommands.chattymoteV("%s will be right back", "%s will be right back %s", "brb", new String[0]);
        PreviewCommands.chattymote2("%s challenges %s to %s", "chal", "challenge");
        PreviewCommands.chattymote0("%s applauds", "clap", "claps");
        PreviewCommands.command((LiteralArgumentBuilder<Object>)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"coin").executes(context -> {
            PreviewCommands.checkChattymote();
            throw PreviewCommands.result(class_2561.method_43470((String)(SelfPlayer.username() + " flips a coin. It shows ")).method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)"#####").method_27692(class_124.field_1051)));
        })), new String[0]);
        PreviewCommands.chattymote1("%s congratulates %s", "congratulations", "congrats", "congratz", "grats", "gratz", "gz");
        PreviewCommands.chattymoteV("%s gives out cookies", "%s gives %s a cookie", "cookie", new String[0]);
        PreviewCommands.chattymote0("%s cries", "cry", "cri", "cries");
        PreviewCommands.command((LiteralArgumentBuilder<Object>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"dice").executes(context -> {
            PreviewCommands.checkChattymote();
            throw PreviewCommands.result(class_2561.method_43470((String)(SelfPlayer.username() + " throws a 6 sided dice. It shows ")).method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)"0").method_27692(class_124.field_1051)));
        })).then(RequiredArgumentBuilder.argument((String)"sides", (ArgumentType)StringArgumentType.word()).executes(context -> {
            PreviewCommands.checkChattymote();
            String sides = Util.normalizeIntOr(StringArgumentType.getString((CommandContext)context, (String)"sides"), "NaN");
            throw PreviewCommands.result(class_2561.method_43470((String)(SelfPlayer.username() + " throws a " + sides + " sided dice. It shows ")).method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)"0").method_27692(class_124.field_1051)));
        }))), new String[0]);
        PreviewCommands.chattymote0("%s dances", "dance", new String[0]);
        PreviewCommands.chattymote0("%s is facepalming", "facepalm", "face", "fp");
        PreviewCommands.chattymote0("%s failed horribly", "fail", new String[0]);
        PreviewCommands.chattymoteV("%s picks flowers", "%s picks flowers for %s", "flowers", new String[0]);
        PreviewCommands.chattymoteV("%s high fives", "%s high fives %s", "highfive", "highf", "h5");
        PreviewCommands.chattymote1("%s hugs %s", "hug", new String[0]);
        PreviewCommands.chattymote0("%s has an idea!", "idea", "lightbulb");
        PreviewCommands.chattymote0("%s is joking", "jk", new String[0]);
        PreviewCommands.chattymote0("%s laughs", "laugh", "lol");
        PreviewCommands.chattymote0("%s is forever alone", "lonely", new String[0]);
        PreviewCommands.chattymoteV("%s loses", "%s loses %s", "lose", "lost");
        PreviewCommands.chattymote1("%s loves %s", "love", new String[0]);
        PreviewCommands.chattymote0("%s doesn't like it", "meh", new String[0]);
        PreviewCommands.chattymote0("%s thought they could be op", "opme", new String[0]);
        PreviewCommands.chattymote0("%s is having a party \\o/", "party", "partayy");
        PreviewCommands.chattymoteV("%s pats", "%s pats %s", "pat", new String[0]);
        PreviewCommands.chattymote0("%s goes poof!", "poof", new String[0]);
        PreviewCommands.chattymote0("%s grabs popcorn", "popcorn", "pc", "pop", "corn");
        PreviewCommands.chattymoteV("%s sheds a tear R.I.P.", "%s sheds a tear at %s", "rip", new String[0]);
        PreviewCommands.chattymote0("%s is rolling on the floor laughing", "rofl", new String[0]);
        PreviewCommands.chattymoteV("%s runs away!", "%s runs to %s", "run", new String[0]);
        PreviewCommands.chattymote2("%s slaps %s with %s", "slap", new String[0]);
        PreviewCommands.chattymote0("%s falls asleep", "sleep", "zzz");
        PreviewCommands.chattymote0("%s got slimed", "slime", new String[0]);
        PreviewCommands.chattymoteV("%s claps slowly", "%s claps slowly at %s", "slowclap", new String[0]);
        PreviewCommands.chattymoteV("%s says Soon\u2122", "%s says Soon\u2122 %s", "soon", new String[0]);
        PreviewCommands.chattymoteV("%s apologizes", "%s apologizes to %s", "sorry", "sowwy");
        PreviewCommands.chattymote0("%s is stunned", "stunned", "stun");
        PreviewCommands.chattymoteV("%s gives thanks", "%s gives thanks to %s", "thanks", "thx", "ty");
        PreviewCommands.chattymoteV("%s is thinking", "%s is thinking about %s", "think", new String[0]);
        PreviewCommands.chattymoteV("%s tickles", "%s tickles %s", "tickle", new String[0]);
        PreviewCommands.chattymoteV("%s is waiting", "%s is waiting for %s", "wait", new String[0]);
        PreviewCommands.chattymoteV("%s waves", "%s waves to %s", "wave", "waves");
        PreviewCommands.command((LiteralArgumentBuilder<Object>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"welcome").executes(context -> {
            PreviewCommands.checkChattymote();
            throw PreviewCommands.result(class_2561.method_43470((String)(SelfPlayer.username() + ": Welcome to ")).method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)"Cube").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Krowd").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"!").method_27692(class_124.field_1076)));
        })).then(RequiredArgumentBuilder.argument((String)"player", (ArgumentType)StringArgumentType.greedyString()).executes(context -> {
            PreviewCommands.checkChattymote();
            String player = StringArgumentType.getString((CommandContext)context, (String)"player");
            throw PreviewCommands.result(class_2561.method_43470((String)(SelfPlayer.username() + ": Welcome to ")).method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)"Cube").method_27692(class_124.field_1062)).method_10852((class_2561)class_2561.method_43470((String)"Krowd").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)(" " + player + "!")).method_27692(class_124.field_1076)));
        }))), "wel");
        PreviewCommands.chattymoteV("%s wins!", "%s wins %s", "win", "won");
    }
}

