/*
 * Decompiled with CFR 0.152.
 */
package dev.yatloaf.modkrowd.cubekrowd.common.cache;

import dev.yatloaf.modkrowd.util.text.StyledString;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public abstract class TextCache {
    public static final TextCache EMPTY = new OfEmpty();

    public abstract class_5250 text();

    public abstract StyledString styledString();

    public abstract String string();

    public static TextCache of(@NotNull class_5250 text) {
        return new OfText(text);
    }

    public static TextCache of(@NotNull StyledString styledString) {
        return new OfStyledString(styledString);
    }

    private static class OfText
    extends TextCache {
        private final class_5250 text;
        private StyledString styledString;
        private String string;

        private OfText(class_5250 text) {
            this.text = text;
        }

        @Override
        public final class_5250 text() {
            return this.text;
        }

        @Override
        public final StyledString styledString() {
            if (this.styledString == null) {
                this.styledString = StyledString.fromText((class_2561)this.text);
            }
            return this.styledString;
        }

        @Override
        public final String string() {
            if (this.string == null) {
                this.string = this.text.getString();
            }
            return this.string;
        }
    }

    private static class OfStyledString
    extends TextCache {
        private final StyledString styledString;
        private class_5250 text;
        private String string;

        private OfStyledString(StyledString styledString) {
            this.styledString = styledString;
        }

        @Override
        public class_5250 text() {
            if (this.text == null) {
                this.text = this.styledString.toText();
            }
            return this.text;
        }

        @Override
        public StyledString styledString() {
            return this.styledString;
        }

        @Override
        public String string() {
            if (this.string == null) {
                this.string = this.styledString.toUnstyledString();
            }
            return this.string;
        }
    }

    private static class OfEmpty
    extends TextCache {
        private static final class_5250 EMPTY_TEXT = class_2561.method_43473();

        private OfEmpty() {
        }

        @Override
        public class_5250 text() {
            return EMPTY_TEXT;
        }

        @Override
        public StyledString styledString() {
            return StyledString.EMPTY;
        }

        @Override
        public String string() {
            return "";
        }
    }
}

