/*
 * Decompiled with CFR 0.152.
 */
package dev.yatloaf.modkrowd.cubekrowd.message.cache;

import dev.yatloaf.modkrowd.cubekrowd.common.cache.TextCache;
import dev.yatloaf.modkrowd.cubekrowd.common.cache.ThemedCache;
import dev.yatloaf.modkrowd.cubekrowd.message.Message;
import dev.yatloaf.modkrowd.cubekrowd.message.cache.CubeKrowdMessageCache;
import dev.yatloaf.modkrowd.cubekrowd.message.cache.FakeMessageCache;
import dev.yatloaf.modkrowd.cubekrowd.message.cache.FishslapMessageCache;
import dev.yatloaf.modkrowd.cubekrowd.message.cache.MainMessageCache;
import dev.yatloaf.modkrowd.cubekrowd.message.cache.MinigameMessageCache;
import dev.yatloaf.modkrowd.cubekrowd.message.cache.MissileWarsMessageCache;
import dev.yatloaf.modkrowd.cubekrowd.message.cache.NoneMessageCache;
import dev.yatloaf.modkrowd.cubekrowd.subserver.CubeKrowdSubserver;
import dev.yatloaf.modkrowd.cubekrowd.subserver.FakeSubserver;
import dev.yatloaf.modkrowd.cubekrowd.subserver.FishslapSubserver;
import dev.yatloaf.modkrowd.cubekrowd.subserver.MainSubserver;
import dev.yatloaf.modkrowd.cubekrowd.subserver.MinigameSubserver;
import dev.yatloaf.modkrowd.cubekrowd.subserver.MissileWarsSubserver;
import dev.yatloaf.modkrowd.cubekrowd.subserver.Subserver;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public abstract class MessageCache
extends ThemedCache {
    private boolean blocked = false;
    private int backgroundTint = 0;
    private Message result;

    public MessageCache(TextCache original) {
        super(original);
    }

    public static MessageCache of(TextCache message, Subserver subserver) {
        Subserver subserver2 = subserver;
        Objects.requireNonNull(subserver2);
        Subserver subserver3 = subserver2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FakeSubserver.class, MainSubserver.class, MissileWarsSubserver.class, FishslapSubserver.class, MinigameSubserver.class, CubeKrowdSubserver.class}, (Object)subserver3, n)) {
            case 0 -> {
                FakeSubserver ignored = (FakeSubserver)subserver3;
                yield new FakeMessageCache(message);
            }
            case 1 -> {
                MainSubserver ignored = (MainSubserver)subserver3;
                yield new MainMessageCache(message);
            }
            case 2 -> {
                MissileWarsSubserver missileWarsSubserver = (MissileWarsSubserver)subserver3;
                yield new MissileWarsMessageCache(message, missileWarsSubserver);
            }
            case 3 -> {
                FishslapSubserver ignored = (FishslapSubserver)subserver3;
                yield new FishslapMessageCache(message);
            }
            case 4 -> {
                MinigameSubserver minigameSubserver = (MinigameSubserver)subserver3;
                yield new MinigameMessageCache(message, minigameSubserver);
            }
            case 5 -> {
                CubeKrowdSubserver ignored = (CubeKrowdSubserver)subserver3;
                yield new CubeKrowdMessageCache(message);
            }
            default -> new NoneMessageCache(message);
        };
    }

    public boolean blocked() {
        return this.blocked;
    }

    public void setBlocked(boolean value) {
        this.blocked = value;
    }

    public int backgroundTint() {
        return this.backgroundTint;
    }

    public void setBackgroundTint(int color) {
        this.backgroundTint = color & 0xFFFFFF;
    }

    public final Message result() {
        if (this.result == null) {
            this.result = this.createResult();
        }
        return this.result;
    }

    protected abstract Message createResult();
}

