/*
 * Decompiled with CFR 0.152.
 */
package dev.yatloaf.modkrowd.cubekrowd.tablist;

import dev.yatloaf.modkrowd.cubekrowd.common.cache.TextCache;
import dev.yatloaf.modkrowd.cubekrowd.subserver.Subserver;
import dev.yatloaf.modkrowd.cubekrowd.subserver.Subservers;
import dev.yatloaf.modkrowd.cubekrowd.tablist.GameTabLabel;
import dev.yatloaf.modkrowd.cubekrowd.tablist.GameTabMode;
import dev.yatloaf.modkrowd.cubekrowd.tablist.GameTabPlayers;
import dev.yatloaf.modkrowd.cubekrowd.tablist.GameTabStatus;
import dev.yatloaf.modkrowd.cubekrowd.tablist.GameTabSubserver;
import dev.yatloaf.modkrowd.cubekrowd.tablist.TabCentered;
import dev.yatloaf.modkrowd.cubekrowd.tablist.TabEntry;
import dev.yatloaf.modkrowd.cubekrowd.tablist.TabList;
import dev.yatloaf.modkrowd.cubekrowd.tablist.TabPing;
import dev.yatloaf.modkrowd.cubekrowd.tablist.cache.TabEntryCache;
import dev.yatloaf.modkrowd.cubekrowd.tablist.cache.TabListCache;
import dev.yatloaf.modkrowd.util.text.StyledString;
import dev.yatloaf.modkrowd.util.text.StyledStringReader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_640;

public final class GameLobbyTabList
extends Record
implements TabList {
    private final EntryCache[] entries;
    private final boolean isReal;
    public static final EntryCache[] EMPTY_ENTRIES = new EntryCache[0];
    public static final GameLobbyTabList FAILURE = new GameLobbyTabList(EMPTY_ENTRIES, false);

    public GameLobbyTabList(EntryCache[] entries, boolean isReal) {
        this.entries = entries;
        this.isReal = isReal;
    }

    public static GameLobbyTabList parseFast(TabListCache source) {
        List<class_640> playerListEntries = source.playerListEntries();
        if (playerListEntries.size() < 80) {
            return FAILURE;
        }
        StyledString styledString40 = source.getPlayerName(40).styledString();
        if (TabCentered.parse(styledString40, GameTabLabel.ARCKADE::parseSpecific).content() != GameTabLabel.ARCKADE) {
            return FAILURE;
        }
        StyledString styledString21 = source.getPlayerName(21).styledString();
        if (TabCentered.parse(styledString21, GameTabLabel.MODE::parseSpecific).content() != GameTabLabel.MODE) {
            return FAILURE;
        }
        EntryCache[] entries = new EntryCache[playerListEntries.size()];
        for (int index = 0; index < playerListEntries.size(); ++index) {
            EntryCache entryCache;
            class_640 playerListEntry = playerListEntries.get(index);
            entries[index] = entryCache = new EntryCache(source.getPlayerName(index), index, playerListEntry.method_2959());
        }
        return new GameLobbyTabList(entries, true);
    }

    @Override
    public TabEntryCache[] players() {
        return EMPTY_ENTRIES;
    }

    @Override
    public TabEntryCache self() {
        return null;
    }

    @Override
    public boolean listsSubserver(Subserver subserver) {
        return false;
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{GameLobbyTabList.class, "entries;isReal", "entries", "isReal"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{GameLobbyTabList.class, "entries;isReal", "entries", "isReal"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{GameLobbyTabList.class, "entries;isReal", "entries", "isReal"}, this, o);
    }

    public EntryCache[] entries() {
        return this.entries;
    }

    public boolean isReal() {
        return this.isReal;
    }

    public static class EntryCache
    extends TabEntryCache {
        public final int index;
        private TabEntry result;

        public EntryCache(TextCache name, int index, int latency) {
            super(name, latency);
            this.index = index;
        }

        @Override
        public TabEntry result() {
            if (this.result == null) {
                this.result = this.createResult();
            }
            return this.result;
        }

        protected TabEntry createResult() {
            if ((this.index + 1) % 20 <= 2) {
                if (this.index == 19) {
                    return TabPing.readFast(StyledStringReader.of(this.original.styledString()));
                }
                return TabCentered.parse(this.original.styledString(), EntryCache.labelForIndex(this.index)::parseSpecific);
            }
            return TabCentered.parse(this.original.styledString(), EntryCache.contentParserForIndex(this.index));
        }

        protected static GameTabLabel labelForIndex(int index) {
            return switch (index) {
                case 20 -> GameTabLabel.WELCOME_TO;
                case 40 -> GameTabLabel.ARCKADE;
                case 1 -> GameTabLabel.SERVER;
                case 21 -> GameTabLabel.MODE;
                case 41 -> GameTabLabel.PLAYERS;
                case 61 -> GameTabLabel.STATUS;
                default -> GameTabLabel.EMPTY;
            };
        }

        protected static Function<StyledString, TabEntry> contentParserForIndex(int index) {
            if (index < 40) {
                if (index < 20) {
                    return GameTabSubserver::parse;
                }
                return source -> GameTabLabel.UNDER.matches((StyledString)source) ? GameTabLabel.UNDER : GameTabMode.parse(source);
            }
            if (index < 60) {
                return source -> GameTabLabel.MAINTENANCE.matches((StyledString)source) ? GameTabLabel.MAINTENANCE : GameTabPlayers.readSoft(StyledStringReader.of(source));
            }
            return GameTabStatus::parse;
        }

        @Override
        public boolean isPlayer() {
            return false;
        }

        @Override
        public Subserver subserver() {
            return Subservers.GAMELOBBY;
        }
    }
}

