/*
 * Decompiled with CFR 0.152.
 */
package dev.yatloaf.modkrowd.cubekrowd.tablist;

import dev.yatloaf.modkrowd.ModKrowd;
import dev.yatloaf.modkrowd.cubekrowd.common.SelfPlayer;
import dev.yatloaf.modkrowd.cubekrowd.common.cache.TextCache;
import dev.yatloaf.modkrowd.cubekrowd.subserver.MinigameSubserver;
import dev.yatloaf.modkrowd.cubekrowd.subserver.Subserver;
import dev.yatloaf.modkrowd.cubekrowd.subserver.Subservers;
import dev.yatloaf.modkrowd.cubekrowd.tablist.GameTabLabel;
import dev.yatloaf.modkrowd.cubekrowd.tablist.GameTabPlayers;
import dev.yatloaf.modkrowd.cubekrowd.tablist.GameTabStatus;
import dev.yatloaf.modkrowd.cubekrowd.tablist.GameTabSubserver;
import dev.yatloaf.modkrowd.cubekrowd.tablist.MinigameTabName;
import dev.yatloaf.modkrowd.cubekrowd.tablist.TabCentered;
import dev.yatloaf.modkrowd.cubekrowd.tablist.TabEntry;
import dev.yatloaf.modkrowd.cubekrowd.tablist.TabList;
import dev.yatloaf.modkrowd.cubekrowd.tablist.TabPing;
import dev.yatloaf.modkrowd.cubekrowd.tablist.cache.TabEntryCache;
import dev.yatloaf.modkrowd.cubekrowd.tablist.cache.TabListCache;
import dev.yatloaf.modkrowd.util.text.StyledString;
import dev.yatloaf.modkrowd.util.text.StyledStringReader;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_640;

public final class MinigameTabList
extends Record
implements TabList {
    private final EntryCache[] entries;
    private final EntryCache[] players;
    private final EntryCache self;
    private final Subserver yourGame;
    private final boolean isReal;
    public static final EntryCache[] EMPTY_ENTRIES = new EntryCache[0];
    public static final MinigameTabList FAILURE = new MinigameTabList(EMPTY_ENTRIES, EMPTY_ENTRIES, null, Subservers.NONE, false);

    public MinigameTabList(EntryCache[] entries, EntryCache[] players, EntryCache self, Subserver yourGame, boolean isReal) {
        this.entries = entries;
        this.players = players;
        this.self = self;
        this.yourGame = yourGame;
        this.isReal = isReal;
    }

    public static MinigameTabList parseFast(TabListCache source) {
        List<class_640> playerListEntries = source.playerListEntries();
        if (playerListEntries.size() < 80) {
            return FAILURE;
        }
        StyledString styledString40 = source.getPlayerName(40).styledString();
        if (TabCentered.parse(styledString40, GameTabLabel.ARCKADE::parseSpecific).content() != GameTabLabel.ARCKADE) {
            return FAILURE;
        }
        StyledString styledString61 = source.getPlayerName(61).styledString();
        if (TabCentered.parse(styledString61, GameTabLabel.YOUR_GAME::parseSpecific).content() != GameTabLabel.YOUR_GAME) {
            return FAILURE;
        }
        boolean isLoaded = ModKrowd.currentSubserver.isReal();
        Subserver yourGame = isLoaded ? ModKrowd.currentSubserver : Subservers.UNKNOWN;
        EntryCache[] entries = new EntryCache[playerListEntries.size()];
        ArrayList<EntryCache> playersBuilder = new ArrayList<EntryCache>();
        String selfName = SelfPlayer.username();
        EntryCache self = null;
        for (int index = 0; index < playerListEntries.size(); ++index) {
            EntryCache entryCache;
            class_640 playerListEntry = playerListEntries.get(index);
            TextCache name = source.getPlayerName(index);
            boolean isPlayer = isLoaded && index >= 62 && index <= 79 && !name.string().isBlank() && !name.styledString().contains(___AND);
            entries[index] = entryCache = new EntryCache(name, index, playerListEntry.method_2959(), yourGame, isPlayer);
            if (!isPlayer) continue;
            playersBuilder.add(entryCache);
            if (!name.string().equals(selfName)) continue;
            self = entryCache;
        }
        EntryCache[] players = (EntryCache[])playersBuilder.toArray(EntryCache[]::new);
        return new MinigameTabList(entries, players, self, yourGame, true);
    }

    @Override
    public boolean listsSubserver(Subserver subserver) {
        return subserver == this.yourGame;
    }

    @Override
    public boolean isLoaded() {
        return this.yourGame != Subservers.UNKNOWN;
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{MinigameTabList.class, "entries;players;self;yourGame;isReal", "entries", "players", "self", "yourGame", "isReal"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MinigameTabList.class, "entries;players;self;yourGame;isReal", "entries", "players", "self", "yourGame", "isReal"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MinigameTabList.class, "entries;players;self;yourGame;isReal", "entries", "players", "self", "yourGame", "isReal"}, this, o);
    }

    public EntryCache[] entries() {
        return this.entries;
    }

    public EntryCache[] players() {
        return this.players;
    }

    @Override
    public EntryCache self() {
        return this.self;
    }

    public Subserver yourGame() {
        return this.yourGame;
    }

    public boolean isReal() {
        return this.isReal;
    }

    public static class EntryCache
    extends TabEntryCache {
        public final int index;
        public final Subserver subserver;
        public final boolean isPlayer;
        private TabEntry result;

        public EntryCache(TextCache name, int index, int latency, Subserver subserver, boolean isPlayer) {
            super(name, latency);
            this.index = index;
            this.subserver = subserver;
            this.isPlayer = isPlayer;
        }

        @Override
        public TabEntry result() {
            if (this.result == null) {
                this.result = this.createResult();
            }
            return this.result;
        }

        protected TabEntry createResult() {
            if (this.isPlayer) {
                Subserver subserver = this.subserver;
                if (subserver instanceof MinigameSubserver) {
                    MinigameSubserver minigameSubserver = (MinigameSubserver)subserver;
                    return MinigameTabName.readFast(StyledStringReader.of(this.original.styledString()), minigameSubserver);
                }
                return TabEntry.FAILURE;
            }
            if ((this.index + 1) % 20 <= 2) {
                if (this.index == 19) {
                    return TabPing.readFast(StyledStringReader.of(this.original.styledString()));
                }
                return TabCentered.parse(this.original.styledString(), EntryCache.labelForIndex(this.index)::parseSpecific);
            }
            return TabCentered.parse(this.original.styledString(), EntryCache.contentParserForIndex(this.index));
        }

        protected static GameTabLabel labelForIndex(int index) {
            return switch (index) {
                case 20 -> GameTabLabel.WELCOME_TO;
                case 40 -> GameTabLabel.ARCKADE;
                case 1 -> GameTabLabel.SERVER;
                case 21 -> GameTabLabel.PLAYERS;
                case 41 -> GameTabLabel.STATUS;
                case 61 -> GameTabLabel.YOUR_GAME;
                default -> GameTabLabel.EMPTY;
            };
        }

        protected static Function<StyledString, TabEntry> contentParserForIndex(int index) {
            if (index < 40) {
                if (index < 20) {
                    return GameTabSubserver::parse;
                }
                return source -> GameTabLabel.UNDER.matches((StyledString)source) ? GameTabLabel.UNDER : GameTabPlayers.readSoft(StyledStringReader.of(source));
            }
            return source -> GameTabLabel.MAINTENANCE.matches((StyledString)source) ? GameTabLabel.MAINTENANCE : GameTabStatus.parse(source);
        }

        @Override
        public boolean isPlayer() {
            return this.isPlayer;
        }

        @Override
        public Subserver subserver() {
            return this.subserver;
        }
    }
}

