/*
 * Decompiled with CFR 0.152.
 */
package dev.yatloaf.modkrowd.util;

import com.google.common.collect.Iterators;
import dev.yatloaf.modkrowd.util.text.StyledString;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.PrimitiveIterator;
import org.jetbrains.annotations.NotNull;

public final class RabinKarp {
    private static final int ASCII_BASE = 128;
    private static final int ASCII_PRIME = 0xFFFFA7;

    public static int findHashAscii(StyledString haystack, int needleHash, int needleLength) {
        return RabinKarp.findHash(haystack, needleHash, needleLength, 128, 0xFFFFA7);
    }

    public static int findHash(StyledString haystack, int needleHash, int needleLength, int base, int prime) {
        int haystackLength = haystack.length();
        int rollingHash = RabinKarp.hash(haystack.subView(0, needleLength), base, prime);
        int mask = RabinKarp.powMod(base, needleLength - 1, prime);
        int index = 0;
        while (index + needleLength <= haystackLength) {
            if (needleHash == rollingHash) {
                return index;
            }
            if (index + needleLength < haystackLength) {
                rollingHash = RabinKarp.rollHash(rollingHash, haystack.codePointAt(index), haystack.codePointAt(index + needleLength), mask, base, prime);
            }
            ++index;
        }
        return -1;
    }

    public static <V> List<Result<V>> mapHashesAscii(StyledString haystack, Int2ObjectMap<V> needleHashes, int needleLength) {
        return RabinKarp.mapHashes(haystack, needleHashes, needleLength, 128, 0xFFFFA7);
    }

    public static <V> List<Result<V>> mapHashes(StyledString haystack, Int2ObjectMap<V> needleHashes, int needleLength, int base, int prime) {
        int haystackLength = haystack.length();
        if (haystackLength < needleLength) {
            return List.of();
        }
        int rollingHash = RabinKarp.hash(haystack.subView(0, needleLength), base, prime);
        ArrayList<Result<V>> results = new ArrayList<Result<V>>();
        int mask = RabinKarp.powMod(base, needleLength - 1, prime);
        int index = 0;
        while (index + needleLength <= haystackLength) {
            if (needleHashes.containsKey(rollingHash)) {
                results.add(new Result<Object>(index, needleHashes.get(rollingHash)));
            }
            if (index + needleLength < haystackLength && (rollingHash = RabinKarp.rollHash(rollingHash, haystack.codePointAt(index), haystack.codePointAt(index + needleLength), mask, base, prime)) < 0) {
                rollingHash += prime;
            }
            ++index;
        }
        return results;
    }

    public static int hashAscii(String value) {
        return RabinKarp.hash(value, 128, 0xFFFFA7);
    }

    public static int hash(String value, int base, int prime) {
        int result = 0;
        PrimitiveIterator.OfInt iterator = value.codePoints().iterator();
        while (iterator.hasNext()) {
            result = (base * result + iterator.nextInt()) % prime;
        }
        return result;
    }

    public static int hashAscii(StyledString value) {
        return RabinKarp.hash(value, 128, 0xFFFFA7);
    }

    public static int hash(StyledString value, int base, int prime) {
        int result = 0;
        for (int i = 0; i < value.length(); ++i) {
            result = (base * result + value.codePointAt(i)) % prime;
        }
        return result;
    }

    public static int rollHash(int source, int tail, int head, int mask, int base, int prime) {
        return ((source + prime - tail * mask % prime) % prime * base + head) % prime;
    }

    private static int powMod(int base, int exponent, int modulo) {
        int result = 1;
        for (int i = 0; i < exponent; ++i) {
            result = base * result % modulo;
        }
        return result;
    }

    public record Result<T>(int index, T t) {
    }

    public record Needle<V>(int length, Int2ObjectMap<V> map) {
    }

    public static class Needles<V>
    implements Iterable<Needle<V>> {
        private final Int2ObjectMap<Int2ObjectMap<V>> hashes = new Int2ObjectOpenHashMap();

        public void put(int length, int hash, V value) {
            if (this.hashes.containsKey(length)) {
                ((Int2ObjectMap)this.hashes.get(length)).put(hash, value);
            } else {
                Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
                map.put(hash, value);
                this.hashes.put(length, (Object)map);
            }
        }

        @Override
        @NotNull
        public Iterator<Needle<V>> iterator() {
            return Iterators.transform((Iterator)this.hashes.int2ObjectEntrySet().iterator(), entry -> new Needle(entry.getIntKey(), (Int2ObjectMap)entry.getValue()));
        }
    }
}

