/*
 * Decompiled with CFR 0.152.
 */
package dev.yatloaf.modkrowd.util.text;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.PrimitiveIterator;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StyledString {
    private static final int[] EMPTY_CODEPOINTS = new int[0];
    private static final class_2583[] EMPTY_STYLES = new class_2583[0];
    private static final class_2583 FALSE_STYLE = class_2583.field_24360.method_10977(class_124.field_1068).method_36141(Boolean.valueOf(false)).method_10982(Boolean.valueOf(false)).method_36140(Boolean.valueOf(false)).method_30938(Boolean.valueOf(false)).method_10978(Boolean.valueOf(false)).method_27704(class_310.field_1740);
    public static final StyledString EMPTY = new StyledString(EMPTY_CODEPOINTS, EMPTY_STYLES);
    public static final StyledString SPACE = StyledString.fromString(" ");
    public static final StyledString NEWLINE = StyledString.fromString("\n");
    private final int[] codePoints;
    private final int codePointsIndex;
    private final class_2583[] styles;
    private final int stylesIndex;
    private final int length;
    private boolean hashIsCalculated = false;
    private int hash = 0;

    private StyledString(int[] codePoints, class_2583[] styles) {
        this(codePoints, 0, styles, 0, codePoints.length);
    }

    private StyledString(int[] codePoints, int codePointsIndex, class_2583[] styles, int stylesIndex, int length) {
        this.codePoints = codePoints;
        this.codePointsIndex = codePointsIndex;
        this.styles = styles;
        this.stylesIndex = stylesIndex;
        this.length = length;
    }

    public static StyledString fromString(@NotNull String source) {
        return StyledString.fromString(source, FALSE_STYLE);
    }

    public static StyledString fromString(@NotNull String source, @NotNull class_2583 style) {
        class_2583 filledStyle = style.method_27702(FALSE_STYLE);
        int[] codePoints = source.codePoints().toArray();
        Object[] styles = new class_2583[codePoints.length];
        Arrays.fill(styles, filledStyle);
        return new StyledString(codePoints, (class_2583[])styles);
    }

    public static StyledString fromFormattedString(@NotNull String source, int formatChar, @NotNull EnumSet<class_124> formattings) {
        return StyledString.fromFormattedString(source, formatChar, formattings, FALSE_STYLE);
    }

    public static StyledString fromFormattedString(@NotNull String source, int formatChar, @NotNull EnumSet<class_124> formattings, @NotNull class_2583 startStyle) {
        class_2583 currentStyle = startStyle.method_27702(FALSE_STYLE);
        IntArrayList codepoints = new IntArrayList(source.length());
        ArrayList<class_2583> styles = new ArrayList<class_2583>(source.length());
        PrimitiveIterator.OfInt sourceIterator = source.codePoints().iterator();
        while (sourceIterator.hasNext()) {
            int ch = sourceIterator.nextInt();
            if (ch == formatChar && sourceIterator.hasNext()) {
                class_124 f;
                class_124 class_1242;
                int code = sourceIterator.nextInt();
                if (code <= 122 && (class_1242 = class_124.method_544((char)((char)code))) instanceof class_124 && formattings.contains(f = class_1242)) {
                    currentStyle = currentStyle.method_27706(f);
                    continue;
                }
                codepoints.add(ch);
                styles.add(currentStyle);
                codepoints.add(code);
                styles.add(currentStyle);
                continue;
            }
            codepoints.add(ch);
            styles.add(currentStyle);
        }
        return new StyledString(codepoints.toIntArray(), styles.toArray(EMPTY_STYLES));
    }

    public static StyledString fromText(@NotNull class_2561 source) {
        return StyledString.fromText(source, FALSE_STYLE);
    }

    public static StyledString fromText(@NotNull class_2561 source, @NotNull class_2583 parentStyle) {
        class_2583 filledParentStyle = parentStyle.method_27702(FALSE_STYLE);
        IntArrayList codepoints = new IntArrayList();
        ArrayList styles = new ArrayList();
        source.method_27658((arg_0, arg_1) -> StyledString.lambda$fromText$1(filledParentStyle, (IntList)codepoints, styles, arg_0, arg_1), filledParentStyle);
        return new StyledString(codepoints.toIntArray(), styles.toArray(EMPTY_STYLES));
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof StyledString) {
            StyledString thatStr = (StyledString)that;
            return Arrays.equals(this.codePoints, this.codePointsIndex, this.codePointsIndex + this.length, thatStr.codePoints, thatStr.codePointsIndex, thatStr.codePointsIndex + thatStr.length) && Arrays.equals(this.styles, this.stylesIndex, this.stylesIndex + this.length, thatStr.styles, thatStr.stylesIndex, thatStr.stylesIndex + thatStr.length);
        }
        return false;
    }

    public int hashCode() {
        if (this.hashIsCalculated) {
            return this.hash;
        }
        int result = 1;
        for (int i = 0; i < this.length; ++i) {
            result = 31 * result + this.codePoints[this.codePointsIndex + i];
            result = 31 * result + this.styles[this.stylesIndex + i].hashCode();
        }
        this.hash = result;
        this.hashIsCalculated = true;
        return result;
    }

    public boolean equalsString(String that) {
        if (that.length() > this.length * 2 || that.length() < this.length) {
            return false;
        }
        PrimitiveIterator.OfInt thatIterator = that.codePoints().iterator();
        for (int i = 0; i < this.length; ++i) {
            if (thatIterator.hasNext()) {
                if (thatIterator.nextInt() == this.codePointAt(i)) continue;
                return false;
            }
            return false;
        }
        return !thatIterator.hasNext();
    }

    public boolean equalsCodePoints(int[] that) {
        return Arrays.equals(this.codePoints, this.codePointsIndex, this.codePointsIndex + this.length, that, 0, that.length);
    }

    public boolean isEmpty() {
        return this.length == 0;
    }

    public boolean startsWith(StyledString that) {
        return that.length <= this.length && this.subView(0, that.length).equals(that);
    }

    public boolean startsWith(String that) {
        if (that.length() > this.length * 2) {
            return false;
        }
        PrimitiveIterator.OfInt thatIterator = that.codePoints().iterator();
        for (int i = 0; i < this.length; ++i) {
            if (thatIterator.hasNext()) {
                if (thatIterator.nextInt() == this.codePointAt(i)) continue;
                return false;
            }
            return true;
        }
        return !thatIterator.hasNext();
    }

    public boolean startsWithCodePoints(int[] that) {
        return that.length <= this.length && this.subView(0, that.length).equalsCodePoints(that);
    }

    public boolean endsWith(StyledString that) {
        return that.length <= this.length && this.subView(this.length - that.length).equals(that);
    }

    public <V> V mapStartOrDefault(Map<StyledString, V> map, V fallback) {
        int keyMaxLength = map.keySet().stream().mapToInt(StyledString::length).max().orElse(0);
        int maxLength = Math.min(keyMaxLength, this.length);
        for (int index = 0; index <= maxLength; ++index) {
            StyledString sub = this.subView(0, index);
            if (!map.containsKey(sub)) continue;
            return map.get(sub);
        }
        return fallback;
    }

    public class_5250 toText() {
        class_5250 text = class_2561.method_43473();
        int index = 0;
        while (index < this.length) {
            int sectionStart = index;
            class_2583 sectionStyle = this.styles[this.stylesIndex + index];
            while (index < this.length && this.styles[this.stylesIndex + index].equals((Object)sectionStyle)) {
                ++index;
            }
            text.method_10852((class_2561)class_2561.method_43470((String)new String(this.codePoints, this.codePointsIndex + sectionStart, index - sectionStart)).method_10862(sectionStyle));
        }
        return text;
    }

    public String toFormattedString(String formatChar) {
        StringBuilder builder = new StringBuilder(this.length);
        int index = 0;
        RollingStyle previousSectionStyle = RollingStyle.DEFAULT;
        while (index < this.length) {
            RollingStyle currentStyle;
            int sectionStart = index;
            RollingStyle sectionStyle = RollingStyle.fromStyle(this.styles[this.stylesIndex + index]);
            while (++index < this.length && (currentStyle = RollingStyle.fromStyle(this.styles[this.stylesIndex + index])).equals(sectionStyle)) {
            }
            sectionStyle.difference(previousSectionStyle, formatChar, builder);
            builder.append(new String(this.codePoints, this.codePointsIndex + sectionStart, index - sectionStart));
            previousSectionStyle = sectionStyle;
        }
        return builder.toString();
    }

    public String toUnstyledString() {
        return new String(this.codePoints, this.codePointsIndex, this.length);
    }

    public String toString() {
        return this.toFormattedString("\u00a7");
    }

    public StyledString subView(int beginIndex) {
        return this.subView(beginIndex, this.length);
    }

    public StyledString subView(int beginIndex, int endIndex) throws IndexOutOfBoundsException {
        if (beginIndex > this.length || endIndex > this.length || beginIndex > endIndex || beginIndex < 0) {
            throw new IndexOutOfBoundsException("beginIndex: " + beginIndex + ", endIndex: " + endIndex + ", length: " + this.length);
        }
        return new StyledString(this.codePoints, this.codePointsIndex + beginIndex, this.styles, this.stylesIndex + beginIndex, endIndex - beginIndex);
    }

    public StyledString isolate() {
        if (this.codePointsIndex == 0 && this.stylesIndex == 0 && this.codePoints.length == this.length && this.styles.length == this.length) {
            return this;
        }
        return new StyledString(Arrays.copyOfRange(this.codePoints, this.codePointsIndex, this.codePointsIndex + this.length), 0, Arrays.copyOfRange(this.styles, this.stylesIndex, this.stylesIndex + this.length), 0, this.length);
    }

    public static StyledString concat(StyledString ... strings) {
        int totalLength = 0;
        for (StyledString str : strings) {
            totalLength += str.length;
        }
        int[] codePoints = new int[totalLength];
        class_2583[] styles = new class_2583[totalLength];
        int index = 0;
        for (StyledString str : strings) {
            System.arraycopy(str.codePoints, str.codePointsIndex, codePoints, index, str.length);
            System.arraycopy(str.styles, str.stylesIndex, styles, index, str.length);
            index += str.length;
        }
        return new StyledString(codePoints, styles);
    }

    public StyledString mapCodePoints(IntUnaryOperator mapper) {
        int[] codePoints = new int[this.length];
        for (int i = 0; i < codePoints.length; ++i) {
            codePoints[i] = mapper.applyAsInt(this.codePointAt(i));
        }
        return new StyledString(codePoints, 0, this.styles, this.stylesIndex, this.length);
    }

    public StyledString mapStyle(Function<class_2583, class_2583> mapper) {
        class_2583[] styles = new class_2583[this.length];
        HashMap<class_2583, class_2583> identities = new HashMap<class_2583, class_2583>();
        for (int i = 0; i < styles.length; ++i) {
            class_2583 currentStyle = mapper.apply(this.styles[i + this.stylesIndex]);
            if (identities.containsKey(currentStyle)) {
                styles[i] = (class_2583)identities.get(currentStyle);
                continue;
            }
            identities.put(currentStyle, currentStyle);
            styles[i] = currentStyle;
        }
        return new StyledString(this.codePoints, this.codePointsIndex, styles, 0, this.length);
    }

    public StyledString fillStrikethrough() {
        return this.mapStyle(style -> style.method_36140(Boolean.valueOf(true)));
    }

    public StyledString fillColor(class_5251 color) {
        return this.mapStyle(style -> style.method_27703(color));
    }

    public StyledString strip() {
        if (this.isEmpty()) {
            return EMPTY;
        }
        int start = 0;
        while (Character.isWhitespace(this.codePointAt(start))) {
            if (++start != this.length) continue;
            return EMPTY;
        }
        int end = this.length;
        while (Character.isWhitespace(this.codePointAt(end - 1))) {
            --end;
        }
        return this.subView(start, end);
    }

    public StyledString insert(int index, String replacement) {
        int[] codePoints = new int[this.length];
        System.arraycopy(this.codePoints, this.codePointsIndex, codePoints, 0, index);
        int i = index;
        PrimitiveIterator.OfInt replacementIterator = replacement.codePoints().iterator();
        while (replacementIterator.hasNext()) {
            codePoints[i] = replacementIterator.nextInt();
            ++i;
        }
        System.arraycopy(this.codePoints, this.codePointsIndex + i, codePoints, i, this.length - i);
        return new StyledString(codePoints, 0, this.styles, this.stylesIndex, this.length);
    }

    public boolean contains(StyledString that) {
        return this.firstIndexOf(that) != -1;
    }

    public int firstIndexOf(StyledString that) {
        int startIndex = 0;
        while (startIndex + that.length <= this.length) {
            if (this.subView(startIndex, startIndex + that.length).equals(that)) {
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }

    public int firstIndexOf(String that) {
        return this.firstIndexOfCodePoints(that.codePoints().toArray());
    }

    public int firstIndexOfCodePoints(int[] that) {
        int startIndex = 0;
        while (startIndex + that.length <= this.length) {
            if (this.subView(startIndex, startIndex + that.length).equalsCodePoints(that)) {
                return startIndex;
            }
            ++startIndex;
        }
        return -1;
    }

    public int lastIndexOf(String that) {
        int[] thatCodePoints = that.codePoints().toArray();
        for (int startIndex = this.length - thatCodePoints.length; startIndex >= 0; --startIndex) {
            if (!this.subView(startIndex, startIndex + thatCodePoints.length).equalsCodePoints(thatCodePoints)) continue;
            return startIndex;
        }
        return -1;
    }

    public class_2583 firstStyle() {
        if (this.length > 0) {
            return this.styleAt(0);
        }
        return FALSE_STYLE;
    }

    public int codePointAt(int index) {
        return this.codePoints[this.codePointsIndex + index];
    }

    public class_2583 styleAt(int index) {
        return this.styles[this.stylesIndex + index];
    }

    public int length() {
        return this.length;
    }

    private static /* synthetic */ Optional lambda$fromText$1(class_2583 filledParentStyle, IntList codepoints, List styles, class_2583 style, String string) {
        class_2583 filledStyle = style.method_27702(filledParentStyle);
        string.codePoints().forEachOrdered(c -> {
            codepoints.add(c);
            styles.add(filledStyle);
        });
        return Optional.empty();
    }

    private record RollingStyle(@Nullable class_124 color, boolean obfuscated, boolean bold, boolean strikethrough, boolean underline, boolean italic) {
        public static final RollingStyle DEFAULT = new RollingStyle(null, false, false, false, false, false);

        public static RollingStyle fromStyle(class_2583 style) {
            class_5251 textColor = style.method_10973();
            class_124 color = textColor == null ? null : class_124.method_533((String)textColor.method_27721());
            return new RollingStyle(color, style.method_10987(), style.method_10984(), style.method_10986(), style.method_10965(), style.method_10966());
        }

        public StringBuilder difference(RollingStyle previous, String formatChar, StringBuilder builder) {
            if (this.color != null && this.color != previous.color) {
                builder.append(formatChar);
                builder.append(this.color.method_36145());
            } else if (this.lessThan(previous)) {
                builder.append(formatChar);
                builder.append(class_124.field_1070.method_36145());
            } else {
                if (this.obfuscated && !previous.obfuscated) {
                    this.formatting(formatChar, class_124.field_1051, builder);
                }
                if (this.bold && !previous.bold) {
                    this.formatting(formatChar, class_124.field_1067, builder);
                }
                if (this.strikethrough && !previous.strikethrough) {
                    this.formatting(formatChar, class_124.field_1055, builder);
                }
                if (this.underline && !previous.underline) {
                    this.formatting(formatChar, class_124.field_1073, builder);
                }
                if (this.italic && !previous.italic) {
                    this.formatting(formatChar, class_124.field_1056, builder);
                }
                return builder;
            }
            if (this.obfuscated) {
                this.formatting(formatChar, class_124.field_1051, builder);
            }
            if (this.bold) {
                this.formatting(formatChar, class_124.field_1067, builder);
            }
            if (this.strikethrough) {
                this.formatting(formatChar, class_124.field_1055, builder);
            }
            if (this.underline) {
                this.formatting(formatChar, class_124.field_1073, builder);
            }
            if (this.italic) {
                this.formatting(formatChar, class_124.field_1056, builder);
            }
            return builder;
        }

        private boolean lessThan(RollingStyle that) {
            return !this.obfuscated && that.obfuscated || !this.bold && that.bold || !this.strikethrough && that.strikethrough || !this.underline && that.underline || !this.italic && that.italic;
        }

        private StringBuilder formatting(String formatChar, class_124 formatting, StringBuilder builder) {
            builder.append(formatChar);
            builder.append(formatting.method_36145());
            return builder;
        }
    }
}

