/*
 * Decompiled with CFR 0.152.
 */
package com.tom.vivecraftcompat.overlay;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import com.tom.vivecraftcompat.overlay.OverlayEnable;
import com.tom.vivecraftcompat.overlay.OverlayManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.slf4j.Logger;

public class HudOverlayScreen
extends Screen {
    public static final Logger LOGGER = LogUtils.getLogger();
    public List<String> overlays = new ArrayList<String>();
    private final String id;
    private String name;
    public boolean outline;
    public OverlayManager.Layer layer;
    public OverlayEnable enable = OverlayEnable.ALWAYS;

    public HudOverlayScreen(String id) {
        super((Component)new TextComponent(""));
        this.id = id;
    }

    public void m_6305_(PoseStack poseStack, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.f_96541_.f_91074_ == null || this.f_96541_.f_91072_ == null || this.f_96541_.f_91073_ == null || !this.isEnabled()) {
            return;
        }
        int screenWidth = this.f_96541_.m_91268_().m_85445_();
        int screenHeight = this.f_96541_.m_91268_().m_85446_();
        this.overlays.forEach(id -> {
            OverlayRegistry.OverlayEntry entry = OverlayRegistry.orderedEntries().stream().filter(e -> e.getDisplayName().equals(id)).findFirst().orElse(null);
            if (entry != null) {
                try {
                    if (this.pre(entry.getOverlay(), poseStack)) {
                        return;
                    }
                    entry.getOverlay().render((ForgeIngameGui)this.f_96541_.f_91065_, poseStack, pPartialTick, screenWidth, screenHeight);
                    this.post(entry.getOverlay(), poseStack);
                }
                catch (Exception e2) {
                    LOGGER.error("Error rendering overlay '{}'", (Object)entry.getDisplayName(), (Object)e2);
                }
            }
        });
        if (this.outline) {
            HudOverlayScreen.m_93172_((PoseStack)poseStack, (int)0, (int)0, (int)this.f_96543_, (int)1, (int)-65536);
            HudOverlayScreen.m_93172_((PoseStack)poseStack, (int)0, (int)0, (int)1, (int)this.f_96544_, (int)-65536);
            HudOverlayScreen.m_93172_((PoseStack)poseStack, (int)(this.f_96543_ - 1), (int)0, (int)this.f_96543_, (int)this.f_96544_, (int)-65536);
            HudOverlayScreen.m_93172_((PoseStack)poseStack, (int)0, (int)(this.f_96544_ - 1), (int)this.f_96543_, (int)this.f_96544_, (int)-65536);
        }
    }

    private boolean pre(IIngameOverlay overlay, PoseStack poseStack) {
        RenderGameOverlayEvent parent = new RenderGameOverlayEvent(poseStack, this.f_96541_.m_91296_(), this.f_96541_.m_91268_());
        return MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.PreLayer(poseStack, parent, overlay));
    }

    private void post(IIngameOverlay overlay, PoseStack poseStack) {
        RenderGameOverlayEvent parent = new RenderGameOverlayEvent(poseStack, this.f_96541_.m_91296_(), this.f_96541_.m_91268_());
        MinecraftForge.EVENT_BUS.post((Event)new RenderGameOverlayEvent.PostLayer(poseStack, parent, overlay));
    }

    public String toString() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.enable.test(this.f_96541_);
    }
}

