/*
 * Decompiled with CFR 0.152.
 */
package com.tom.vivecraftcompat.overlay;

import java.util.function.Function;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;

public enum OverlayLock {
    FLOAT,
    HMD(d -> LockedPosition.pose(d.vrPlayer.vrdata_room_pre.hmd, 2.0f)),
    LEFT_HAND(d -> LockedPosition.pose(d.vrPlayer.vrdata_room_pre.getController(1), 1.2f)),
    RIGHT_HAND(d -> LockedPosition.pose(d.vrPlayer.vrdata_room_pre.getController(0), 1.2f)),
    BODY(d -> new LockedPosition(HMD.getLocked().getPosition()));

    private static final ClientDataHolderVR DATA_HOLDER;
    private Function<ClientDataHolderVR, LockedPosition> locked;

    private OverlayLock() {
    }

    private OverlayLock(Function<ClientDataHolderVR, LockedPosition> locked) {
        this.locked = locked;
    }

    public LockedPosition getLocked() {
        return this.locked == null ? null : this.locked.apply(DATA_HOLDER);
    }

    public static OverlayLock byName(String lock) {
        OverlayLock[] values = OverlayLock.values();
        for (int i = 0; i < values.length; ++i) {
            OverlayLock overlayLock = values[i];
            if (!overlayLock.name().equalsIgnoreCase(lock)) continue;
            return overlayLock;
        }
        return FLOAT;
    }

    static {
        DATA_HOLDER = ClientDataHolderVR.getInstance();
    }

    public static class LockedPosition {
        private Vec3 pos;
        private Matrix4f matrix;

        public static LockedPosition pose(VRData.VRDevicePose d, float f) {
            return new LockedPosition(d.getPosition(), d.getMatrix());
        }

        public LockedPosition(Vec3 pos, Matrix4f matrix) {
            this.pos = pos;
            this.matrix = matrix;
        }

        public LockedPosition(Vec3 pos) {
            this.pos = pos;
            this.matrix = new Matrix4f();
        }

        public Vec3 getPosition() {
            return this.pos;
        }

        public Vector3f getPositionF() {
            return new Vector3f((float)this.pos.f_82479_, (float)this.pos.f_82480_, (float)this.pos.f_82481_);
        }

        public Matrix4f getMatrix() {
            return this.matrix;
        }
    }
}

