/*
 * Decompiled with CFR 0.152.
 */
package com.tom.vivecraftcompat.overlay;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tom.vivecraftcompat.VRMode;
import com.tom.vivecraftcompat.access.MC;
import com.tom.vivecraftcompat.events.VRBindingsEvent;
import com.tom.vivecraftcompat.events.VRUpdateControllersEvent;
import com.tom.vivecraftcompat.overlay.HudOverlayScreen;
import com.tom.vivecraftcompat.overlay.OverlayLock;
import com.tom.vivecraftcompat.overlay.VRInteractableScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client_vr.ClientDataHolderVR;
import org.vivecraft.client_vr.VRData;
import org.vivecraft.client_vr.VRTextureTarget;
import org.vivecraft.client_vr.gameplay.screenhandlers.GuiHandler;
import org.vivecraft.client_vr.gameplay.screenhandlers.KeyboardHandler;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.provider.MCVR;
import org.vivecraft.client_vr.provider.openvr_lwjgl.VRInputAction;
import org.vivecraft.client_vr.render.helpers.RenderHelper;

public class OverlayManager {
    public static Minecraft minecraft = Minecraft.m_91087_();
    public static ClientDataHolderVR dh = ClientDataHolderVR.getInstance();
    private static List<Layer> screens = new ArrayList<Layer>();
    private static boolean overlayRendering;

    public static void resizeBuffers() {
        screens.forEach(Layer::resize);
    }

    public static void drawLayers(float partial) {
        if (!VRMode.isVR() || screens.isEmpty()) {
            return;
        }
        MC mc = (MC)minecraft;
        RenderTarget bak = minecraft.m_91385_();
        overlayRendering = true;
        for (Layer layer : screens) {
            layer.initialize();
            if (layer.framebuffer == null) continue;
            mc.mc$setMainRenderTarget(layer.getFramebuffer());
            layer.framebuffer.m_83954_(Minecraft.f_91002_);
            layer.framebuffer.m_83947_(true);
            RenderHelper.drawScreen((float)partial, (Screen)layer.screen, (boolean)true);
        }
        overlayRendering = false;
        mc.mc$setMainRenderTarget(bak);
        bak.m_83947_(true);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void overlayPre(RenderGameOverlayEvent.PreLayer event) {
        if (overlayRendering || !VRMode.isVR()) {
            return;
        }
        OverlayRegistry.OverlayEntry e = OverlayRegistry.getEntry((IIngameOverlay)event.getOverlay());
        if (e != null && OverlayManager.isOverlayDetached(e.getDisplayName())) {
            event.setCanceled(true);
        }
    }

    public static void populateListeners() {
        OverlayManager.registerListener(OverlayManager.minecraft.f_91066_.f_92096_, 0);
        OverlayManager.registerListener(OverlayManager.minecraft.f_91066_.f_92095_, 1);
        OverlayManager.registerListener(GuiHandler.KEY_LEFT_CLICK, 0);
        OverlayManager.registerListener(GuiHandler.KEY_RIGHT_CLICK, 1);
    }

    private static void registerListener(KeyMapping map, final int kb) {
        MCVR.get().getInputAction(map).registerListener(new VRInputAction.KeyListener(){

            public boolean onUnpressed(ControllerType var1) {
                return OverlayManager.interact(kb, false);
            }

            public boolean onPressed(ControllerType var1) {
                return OverlayManager.interact(kb, true);
            }

            public int getPriority() {
                return 0;
            }
        });
    }

    public static boolean isOverlayDetached(String rl) {
        return VRMode.isVR() && screens.stream().anyMatch(h -> {
            HudOverlayScreen s;
            Screen patt3962$temp = h.screen;
            return patt3962$temp instanceof HudOverlayScreen && (s = (HudOverlayScreen)patt3962$temp).isEnabled() && s.overlays.contains(rl);
        });
    }

    public static void addLayer(Layer layer) {
        screens.add(layer);
    }

    public static void forEachLayer(Consumer<Layer> renderLayer) {
        if (screens.isEmpty()) {
            return;
        }
        new ArrayList<Layer>(screens).forEach(renderLayer);
    }

    public static void renderLayers(Consumer<Layer> renderLayer) {
        if (!VRMode.isVR()) {
            return;
        }
        OverlayManager.forEachLayer(l -> {
            if (!l.ready()) {
                return;
            }
            float gs = GuiHandler.GUI_SCALE;
            GuiHandler.GUI_SCALE = gs * l.scale;
            renderLayer.accept((Layer)l);
            GuiHandler.GUI_SCALE = gs;
        });
    }

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        if (!VRMode.isVR() || event.phase == TickEvent.Phase.START) {
            return;
        }
        OverlayManager.forEachLayer(l -> l.screen.m_96624_());
    }

    @SubscribeEvent
    public static void processGui(VRUpdateControllersEvent event) {
        OverlayManager.forEachLayer(s -> {
            Screen patt11401$temp = s.screen;
            if (patt11401$temp instanceof VRInteractableScreen) {
                VRInteractableScreen i = (VRInteractableScreen)patt11401$temp;
                i.processGui();
            }
            s.updateMovingLayer();
        });
    }

    @SubscribeEvent
    public static void processBindings(VRBindingsEvent event) {
        for (Layer layer : screens) {
            if (layer.startControllerPose == null || !VivecraftVRMod.INSTANCE.keyMenuButton.m_90859_()) continue;
            layer.stopMovingLayer();
        }
        if (KeyboardHandler.SHOWING) {
            return;
        }
        OverlayManager.forEachLayer(s -> {
            Screen patt11829$temp = s.screen;
            if (patt11829$temp instanceof VRInteractableScreen) {
                VRInteractableScreen i = (VRInteractableScreen)patt11829$temp;
                i.processBindings();
            }
        });
    }

    public static boolean isUsingController() {
        return screens.stream().anyMatch(l -> {
            VRInteractableScreen i;
            Screen patt11999$temp = l.screen;
            return patt11999$temp instanceof VRInteractableScreen && (i = (VRInteractableScreen)patt11999$temp).isUsingController();
        });
    }

    public static Optional<Layer> findLayer(Screen s) {
        return screens.stream().filter(l -> l.screen == s).findFirst();
    }

    public static boolean type(char character) {
        boolean[] found = new boolean[]{false};
        OverlayManager.forEachLayer(s -> {
            if (found[0]) {
                return;
            }
            Screen patt12347$temp = s.screen;
            if (patt12347$temp instanceof VRInteractableScreen) {
                VRInteractableScreen i = (VRInteractableScreen)patt12347$temp;
                found[0] = i.type(character);
            }
        });
        return found[0];
    }

    public static boolean key(int key) {
        boolean[] found = new boolean[]{false};
        OverlayManager.forEachLayer(s -> {
            if (found[0]) {
                return;
            }
            Screen patt12596$temp = s.screen;
            if (patt12596$temp instanceof VRInteractableScreen) {
                VRInteractableScreen i = (VRInteractableScreen)patt12596$temp;
                found[0] = i.key(key);
            }
        });
        return found[0];
    }

    public static boolean interact(int key, boolean press) {
        boolean[] found = new boolean[]{false};
        OverlayManager.forEachLayer(s -> {
            if (found[0]) {
                return;
            }
            Screen patt12858$temp = s.screen;
            if (patt12858$temp instanceof VRInteractableScreen) {
                VRInteractableScreen i = (VRInteractableScreen)patt12858$temp;
                found[0] = i.interact(key, press);
            }
        });
        return found[0];
    }

    public static class Layer {
        private RenderTarget framebuffer = null;
        private Screen screen;
        private Vector3f pos = new Vector3f(0.0f, 0.0f, 0.0f);
        private Matrix4f rotation = new Matrix4f();
        private OverlayLock lock = OverlayLock.FLOAT;
        private float scale = 1.0f;
        private int startController;
        private VRData.VRDevicePose startControllerPose;
        private float startDragPosX;
        private float startDragPosY;
        private float startDragPosZ;
        private Matrix4f startDragRot;
        private boolean moved;
        private OverlayLock preMoveLock;

        public Layer(Screen screen) {
            this.screen = screen;
        }

        public Layer(Function<Layer, Screen> screen) {
            this.screen = screen.apply(this);
        }

        public void resize() {
            if (VRMode.isVR()) {
                if (this.framebuffer == null) {
                    this.framebuffer = VRTextureTarget.builder((String)("VCC Overlay: " + this.screen.getClass().getName())).withSize(GuiHandler.GUI_WIDTH, GuiHandler.GUI_HEIGHT).withDepth().withLinearFilter().withStencil(true).build();
                } else {
                    this.framebuffer.m_83941_(GuiHandler.GUI_WIDTH, GuiHandler.GUI_HEIGHT, Minecraft.f_91002_);
                }
                int l2 = minecraft.m_91268_().m_85445_();
                int j3 = minecraft.m_91268_().m_85446_();
                this.screen.m_6575_(minecraft, l2, j3);
            }
        }

        public RenderTarget getFramebuffer() {
            return this.framebuffer;
        }

        public Vector3f getPos() {
            if (this.startControllerPose != null) {
                return this.pos;
            }
            OverlayLock.LockedPosition pose = this.lock.getLocked();
            if (pose == null) {
                return this.pos;
            }
            Vec3 pp = pose.getPosition();
            Vector4f r = pose.getMatrix().transform(new Vector4f((Vector3fc)this.pos, 1.0f)).add((Vector4fc)new Vector4f((float)pp.f_82479_, (float)pp.f_82480_, (float)pp.f_82481_, 0.0f));
            return new Vector3f(r.x / r.w, r.y / r.w, r.z / r.w);
        }

        public Matrix4f getRotation() {
            if (this.startControllerPose != null) {
                return this.rotation;
            }
            OverlayLock.LockedPosition pose = this.lock.getLocked();
            if (pose == null) {
                return this.rotation;
            }
            return pose.getMatrix().mul((Matrix4fc)this.rotation, new Matrix4f());
        }

        public void spawnOverlay(ControllerType controller) {
            VRData.VRDevicePose vrdata$vrdevicepose = OverlayManager.dh.vrPlayer.vrdata_room_pre.hmd;
            float f = 2.0f;
            int i = 0;
            if (controller == ControllerType.LEFT) {
                i = 1;
            }
            vrdata$vrdevicepose = OverlayManager.dh.vrPlayer.vrdata_room_pre.getController(i);
            f = 1.2f;
            Vector3f vec3 = vrdata$vrdevicepose.getPositionF();
            Vector3f vec31 = new Vector3f(0.0f, 0.0f, -f);
            Vector3f vec32 = vrdata$vrdevicepose.getCustomVector((Vector3fc)vec31);
            this.pos = new Vector3f(vec32.x / 2.0f + vec3.x, vec32.y / 2.0f + vec3.y, vec32.z / 2.0f + vec3.z);
            Vector3f vector3 = new Vector3f();
            vector3.x = this.pos.x - vec3.x;
            vector3.y = this.pos.y - vec3.y;
            vector3.z = this.pos.z - vec3.z;
            float f1 = (float)Math.asin(vector3.y / vector3.length());
            float f2 = (float)(3.1415927410125732 + Math.atan2(vector3.x, vector3.z));
            this.rotation = new Matrix4f().rotationY(f2);
            Matrix4f matrix4f = new Matrix4f().rotationX(f1);
            this.rotation.mul((Matrix4fc)matrix4f);
        }

        public void remove() {
            if (this.framebuffer != null) {
                RenderTarget f = this.framebuffer;
                this.framebuffer = null;
                RenderSystem.m_69879_(() -> f.m_83930_());
            }
            screens.remove(this);
        }

        public void setPos(Vector3f pos) {
            this.pos = pos;
        }

        public void setPos(Vector4f pos) {
            this.pos = new Vector3f(pos.x, pos.y, pos.z);
        }

        public void setRotation(Matrix4f rotation) {
            this.rotation = rotation;
        }

        public void startMovingLayer(int controller) {
            this.preMoveLock = this.lock;
            this.setLock(OverlayLock.FLOAT);
            this.startController = controller;
            this.startControllerPose = OverlayManager.dh.vrPlayer.vrdata_room_pre.getController(controller);
            this.startDragPosX = this.pos.x;
            this.startDragPosY = this.pos.y;
            this.startDragPosZ = this.pos.z;
            this.startDragRot = new Matrix4f((Matrix4fc)this.rotation);
            this.moved = false;
        }

        public void updateMovingLayer() {
            if (this.startControllerPose != null) {
                VRData.VRDevicePose vrdata$vrdevicepose = OverlayManager.dh.vrPlayer.vrdata_room_pre.getController(this.startController);
                Vec3 vec3 = this.startControllerPose.getPosition();
                Vec3 vec31 = vrdata$vrdevicepose.getPosition().m_82546_(vec3);
                Matrix4f matrix4f = vrdata$vrdevicepose.getMatrix().mul((Matrix4fc)this.startControllerPose.getMatrix().invert(new Matrix4f()), new Matrix4f());
                Vector3f vector3 = new Vector3f(this.startDragPosX - (float)vec3.f_82479_, this.startDragPosY - (float)vec3.f_82480_, this.startDragPosZ - (float)vec3.f_82481_);
                Vector4f vector31 = matrix4f.transform(new Vector4f((Vector3fc)vector3, 1.0f));
                float px = this.startDragPosX + (float)vec31.f_82479_ + (vector31.x - vector3.x);
                float py = this.startDragPosY + (float)vec31.f_82480_ + (vector31.y - vector3.y);
                float pz = this.startDragPosZ + (float)vec31.f_82481_ + (vector31.z - vector3.z);
                this.setPos(new Vector3f(px, py, pz));
                this.setRotation(matrix4f.mul((Matrix4fc)this.startDragRot));
                this.moved = true;
            }
        }

        public void stopMovingLayer() {
            this.startControllerPose = null;
            if (this.moved) {
                this.setLock(this.preMoveLock);
                this.moved = false;
            }
        }

        public boolean isMoving() {
            return this.startControllerPose != null;
        }

        public Screen getScreen() {
            return this.screen;
        }

        public void setLock(OverlayLock lock) {
            this.setPos(this.getPos());
            this.setRotation(this.getRotation());
            this.lock = lock;
            OverlayLock.LockedPosition pose = lock.getLocked();
            if (pose != null) {
                Matrix4f mat = pose.getMatrix().invert(new Matrix4f()).mul((Matrix4fc)this.rotation);
                this.setPos(pose.getMatrix().invert(new Matrix4f()).transform(new Vector4f((Vector3fc)new Vector3f((Vector3fc)this.pos).sub((Vector3fc)pose.getPositionF()), 1.0f)));
                this.setRotation(mat);
            }
        }

        public OverlayLock getLock() {
            return this.lock;
        }

        public void setScale(float scale) {
            this.scale = scale;
        }

        public float getScale() {
            return this.scale;
        }

        public Vector3f getPosRaw() {
            return this.pos;
        }

        public Matrix4f getRotationRaw() {
            return this.rotation;
        }

        public void setLockDirect(OverlayLock lock) {
            this.lock = lock;
        }

        public void initialize() {
            if (this.framebuffer == null) {
                this.resize();
            }
        }

        public boolean ready() {
            return this.framebuffer != null;
        }

        public void addPos(Vector3f d) {
            this.pos.x += d.x * 0.025f;
            this.pos.y += d.y * 0.025f;
            this.pos.z += d.z * 0.025f;
        }

        public void addRotation(Vector3f d) {
            Matrix4f rotationMatrix = this.getRotationRaw();
            Quaternionf quaternion = new Quaternionf();
            rotationMatrix.getUnnormalizedRotation(quaternion);
            quaternion.rotateAxis((float)Math.toRadians(10.0), (Vector3fc)d);
            Matrix4f mat = new Matrix4f().rotate((Quaternionfc)quaternion);
            this.setRotation(mat);
        }
    }
}

