/*
 * Decompiled with CFR 0.152.
 */
package com.tom.vivecraftcompat.overlay;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ButtonIcon;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.DropDownBox;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.InputPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.ListPicker;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.elements.Slider;
import com.tom.cpl.gui.elements.Spinner;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.math.Box;
import com.tom.cpl.util.NamedElement;
import com.tom.vivecraftcompat.overlay.HudOverlayScreen;
import com.tom.vivecraftcompat.overlay.OverlayConfig;
import com.tom.vivecraftcompat.overlay.OverlayEnable;
import com.tom.vivecraftcompat.overlay.OverlayLock;
import com.tom.vivecraftcompat.overlay.OverlayManager;
import it.unimi.dsi.fastutil.booleans.BooleanConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.client.gui.OverlayRegistry;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.vivecraft.client.VivecraftVRMod;
import org.vivecraft.client_vr.provider.ControllerType;
import org.vivecraft.client_vr.provider.MCVR;

public class OverlaySettingsGui
extends Frame {
    private List<OverlayElement> overlays;
    private DropDownBox<OverlayElement> overlaysBox;
    private NamedElement.NameMapper<String> elementNames;
    private ListPicker<NamedElement<String>> elementsBox;
    private ScrollPanel currentElementsScp;
    private Panel currentElements;
    private FlowLayout currentElementsLayout;
    private DropDownBox<NamedElement<OverlayLock>> overlayLockBox;
    private NamedElement.NameMapper<OverlayLock> overlayLockNames;
    private DropDownBox<NamedElement<OverlayEnable>> overlayEnableBox;
    private NamedElement.NameMapper<OverlayEnable> overlayEnableNames;
    private Button btnAdd;
    private Button btnDel;
    private Set<String> allElements;
    private Slider sliderScale;
    private List<BooleanConsumer> moveUpdater = new ArrayList<BooleanConsumer>();

    public OverlaySettingsGui(IGui gui) {
        super(gui);
        gui.setCloseListener(t -> {
            this.updateOutlines(null);
            OverlayConfig.saveOverlays();
            t.run();
        });
    }

    public void initFrame(int width, int height) {
        this.allElements = OverlayRegistry.orderedEntries().stream().map(OverlayRegistry.OverlayEntry::getDisplayName).collect(Collectors.toSet());
        this.overlays = new ArrayList<OverlayElement>();
        this.overlays.add(new OverlayElement(null));
        OverlayManager.forEachLayer(l -> {
            Screen patt2773$temp = l.getScreen();
            if (patt2773$temp instanceof HudOverlayScreen) {
                HudOverlayScreen h = (HudOverlayScreen)patt2773$temp;
                this.overlays.add(new OverlayElement(h));
                this.allElements.removeAll(h.overlays);
            }
        });
        int w = width;
        int h = height - 20;
        Panel p = new Panel(this.gui);
        p.setBounds(new Box(0, 20, w, h));
        p.setBackgroundColor(this.gui.getColors().popup_background & 0x80FFFFFF);
        this.addElement((GuiElement)p);
        Button btnClose = new Button(this.gui, "X", () -> ((IGui)this.gui).closeGui());
        btnClose.setBounds(new Box(w - 20, 0, 20, 20));
        p.addElement((GuiElement)btnClose);
        int lw = w / 2 - 10;
        int rw = w / 2 - 50;
        int rx = lw + 10;
        int rx2 = rx + rw + 5;
        this.overlaysBox = new DropDownBox(this.gui.getFrame(), this.overlays);
        this.overlaysBox.setBounds(new Box(rx, 5, rw, 20));
        p.addElement(this.overlaysBox);
        this.overlaysBox.setAction(this::updateCurrentElementsList);
        Button btnRename = new Button(this.gui, "E", () -> {
            if (this.overlaysBox.getSelected() != null && ((OverlayElement)this.overlaysBox.getSelected()).overlay != null) {
                HudOverlayScreen scr = ((OverlayElement)this.overlaysBox.getSelected()).overlay;
                this.openPopup((PopupPanel)new InputPopup((Frame)this, this.gui.i18nFormat("vivecraftcompat.gui.overlay.editname", new Object[0]), scr::setName, null));
            }
        });
        btnRename.setBounds(new Box(rx2, 5, 20, 20));
        p.addElement((GuiElement)btnRename);
        this.btnDel = new Button(this.gui, "-", ConfirmPopup.confirmHandler((Frame)this, (String)this.gui.i18nFormat("vivecraftcompat.gui.overlay.delete", new Object[0]), this::deleteOverlay));
        this.btnDel.setBounds(new Box(rx2, 30, 20, 20));
        p.addElement((GuiElement)this.btnDel);
        this.elementNames = new NamedElement.NameMapper(this.allElements, rl -> rl);
        this.elementsBox = new ListPicker(this.gui.getFrame(), this.elementNames.asList());
        this.elementsBox.setBounds(new Box(5, 5, lw, 20));
        p.addElement(this.elementsBox);
        this.btnAdd = new Button(this.gui, this.gui.i18nFormat("vivecraftcompat.gui.overlay.add", new Object[0]), this::addElementToOverlay);
        this.btnAdd.setBounds(new Box(5, 30, lw, 20));
        p.addElement((GuiElement)this.btnAdd);
        this.elementsBox.setAction(() -> this.btnAdd.setEnabled(this.elementsBox.getSelected() != null));
        Panel rp = new Panel(this.gui);
        rp.setBounds(new Box(0, 0, rw + 5, 100));
        ScrollPanel rscp = new ScrollPanel(this.gui);
        rscp.setDisplay(rp);
        rscp.setBounds(new Box(lw + 5, 30, rw + 5, h - 30));
        p.addElement((GuiElement)rscp);
        this.initLayerSettings(rp, rw - 5);
        this.currentElementsScp = new ScrollPanel(this.gui);
        this.currentElements = new Panel(this.gui);
        this.currentElements.setBackgroundColor(this.gui.getColors().button_border);
        this.currentElementsScp.setDisplay(this.currentElements);
        this.currentElements.setBounds(new Box(0, 0, lw, 0));
        this.currentElementsScp.setBounds(new Box(5, 65, lw, h - 70));
        p.addElement(new Label(this.gui, this.gui.i18nFormat("vivecraftcompat.gui.overlay.current", new Object[0])).setBounds(new Box(5, 55, 0, 0)));
        p.addElement((GuiElement)this.currentElementsScp);
        this.currentElementsLayout = new FlowLayout(this.currentElements, 5, 1);
        this.updateCurrentElementsList();
    }

    private void initLayerSettings(Panel rp, int rw) {
        FlowLayout layout = new FlowLayout(rp, 5, 1);
        rp.addElement(new Label(this.gui, this.gui.i18nFormat("vivecraftcompat.gui.overlay.lock", new Object[0])).setBounds(new Box(5, 0, 100, 10)));
        this.overlayLockNames = new NamedElement.NameMapper((Object[])OverlayLock.values(), l -> this.gui.i18nFormat("vivecraftcompat.gui.overlay.lock." + l.name().toLowerCase(Locale.ROOT), new Object[0]));
        this.overlayLockBox = new DropDownBox(this.gui.getFrame(), this.overlayLockNames.asList());
        this.overlayLockBox.setBounds(new Box(5, 0, rw, 20));
        this.overlayLockNames.setSetter(arg_0 -> this.overlayLockBox.setSelected(arg_0));
        rp.addElement(this.overlayLockBox);
        this.overlayLockBox.setAction(() -> {
            if (this.overlaysBox.getSelected() != null && ((OverlayElement)this.overlaysBox.getSelected()).overlay != null) {
                ((OverlayElement)this.overlaysBox.getSelected()).overlay.layer.setLock((OverlayLock)((Object)((Object)((NamedElement)this.overlayLockBox.getSelected()).getElem())));
            }
        });
        Panel moveBtns = new Panel(this.gui);
        moveBtns.setBounds(new Box(0, 0, rw, 20));
        Button btnMoveL = new Button(this.gui, "L", () -> {
            if (this.overlaysBox.getSelected() != null && ((OverlayElement)this.overlaysBox.getSelected()).overlay != null) {
                ((OverlayElement)this.overlaysBox.getSelected()).overlay.layer.startMovingLayer(1);
            }
        });
        btnMoveL.setTooltip(new Tooltip((Frame)this, this.gui.i18nFormat("tooltip.vivecraftcompat.overlay.moveL", new Object[]{MCVR.get().getOriginName(MCVR.get().getInputAction(VivecraftVRMod.INSTANCE.keyMenuButton).getLastOrigin())})));
        btnMoveL.setBounds(new Box(5, 0, 20, 20));
        moveBtns.addElement((GuiElement)btnMoveL);
        this.moveUpdater.add(arg_0 -> ((Button)btnMoveL).setEnabled(arg_0));
        Button btnMoveR = new Button(this.gui, "R", () -> {
            if (this.overlaysBox.getSelected() != null && ((OverlayElement)this.overlaysBox.getSelected()).overlay != null) {
                ((OverlayElement)this.overlaysBox.getSelected()).overlay.layer.startMovingLayer(0);
            }
        });
        btnMoveR.setBounds(new Box(30, 0, 20, 20));
        btnMoveR.setTooltip(new Tooltip((Frame)this, this.gui.i18nFormat("tooltip.vivecraftcompat.overlay.moveR", new Object[]{MCVR.get().getOriginName(MCVR.get().getInputAction(VivecraftVRMod.INSTANCE.keyMenuButton).getLastOrigin())})));
        moveBtns.addElement((GuiElement)btnMoveR);
        this.moveUpdater.add(arg_0 -> ((Button)btnMoveR).setEnabled(arg_0));
        rp.addElement((GuiElement)moveBtns);
        Panel movementPanel = new Panel(this.gui);
        movementPanel.setBounds(new Box(5, 0, rw, 80));
        rp.addElement((GuiElement)movementPanel);
        this.sliderScale = new Slider(this.gui, this.formatScale(1.0f));
        this.sliderScale.setValue(0.2f);
        this.sliderScale.setBounds(new Box(5, 0, rw, 20));
        rp.addElement((GuiElement)this.sliderScale);
        this.sliderScale.setAction(() -> {
            this.sliderScale.setText(this.formatScale(this.sliderScale.getValue() * 5.0f));
            if (this.overlaysBox.getSelected() != null && ((OverlayElement)this.overlaysBox.getSelected()).overlay != null) {
                HudOverlayScreen s = ((OverlayElement)this.overlaysBox.getSelected()).overlay;
                s.layer.setScale(this.sliderScale.getValue() * 5.0f);
            }
        });
        rp.addElement(new Label(this.gui, this.gui.i18nFormat("vivecraftcompat.gui.overlay.enable", new Object[0])).setBounds(new Box(5, 0, 100, 10)));
        this.overlayEnableNames = new NamedElement.NameMapper((Object[])OverlayEnable.values(), l -> this.gui.i18nFormat("vivecraftcompat.gui.overlay.enable." + l.name().toLowerCase(Locale.ROOT), new Object[0]));
        this.overlayEnableBox = new DropDownBox(this.gui.getFrame(), this.overlayEnableNames.asList());
        this.overlayEnableBox.setBounds(new Box(5, 0, rw, 20));
        this.overlayEnableNames.setSetter(arg_0 -> this.overlayEnableBox.setSelected(arg_0));
        rp.addElement(this.overlayEnableBox);
        this.overlayEnableBox.setAction(() -> {
            if (this.overlaysBox.getSelected() != null && ((OverlayElement)this.overlaysBox.getSelected()).overlay != null) {
                ((OverlayElement)this.overlaysBox.getSelected()).overlay.enable = (OverlayEnable)((Object)((Object)((NamedElement)this.overlayEnableBox.getSelected()).getElem()));
            }
        });
        this.addMoveButtons(movementPanel, "move", 0, 32, d -> {
            if (this.overlaysBox.getSelected() != null && ((OverlayElement)this.overlaysBox.getSelected()).overlay != null) {
                ((OverlayElement)this.overlaysBox.getSelected()).overlay.layer.addPos((Vector3f)d);
            }
        });
        this.addMoveButtons(movementPanel, "rot", 80, 48, d -> {
            if (this.overlaysBox.getSelected() != null && ((OverlayElement)this.overlaysBox.getSelected()).overlay != null) {
                ((OverlayElement)this.overlaysBox.getSelected()).overlay.layer.addRotation(new Vector3f(d.y, d.x, -d.z));
            }
        });
        Button btnEdit = new Button(this.gui, "E", () -> {
            if (this.overlaysBox.getSelected() != null && ((OverlayElement)this.overlaysBox.getSelected()).overlay != null) {
                this.openPopup(new OverlayPosRotEditPopup(this.gui, ((OverlayElement)this.overlaysBox.getSelected()).overlay.layer));
            }
        });
        btnEdit.setTooltip(new Tooltip((Frame)this, this.gui.i18nFormat("tooltip.vivecraftcompat.overlay.edit", new Object[0])));
        btnEdit.setBounds(new Box(60, 0, 20, 20));
        moveBtns.addElement((GuiElement)btnEdit);
        this.moveUpdater.add(arg_0 -> ((Button)btnEdit).setEnabled(arg_0));
        layout.reflow();
    }

    private void addMoveButtons(Panel panel, String name, int x, int imgX, Consumer<Vector3f> event) {
        ButtonIcon up = new ButtonIcon(this.gui, "vcc_overlay_btns", 0, 0, () -> event.accept(new Vector3f(0.0f, 1.0f, 0.0f)));
        ButtonIcon down = new ButtonIcon(this.gui, "vcc_overlay_btns", 0, 16, () -> event.accept(new Vector3f(0.0f, -1.0f, 0.0f)));
        ButtonIcon left = new ButtonIcon(this.gui, "vcc_overlay_btns", 16, 0, () -> event.accept(new Vector3f(-1.0f, 0.0f, 0.0f)));
        ButtonIcon right = new ButtonIcon(this.gui, "vcc_overlay_btns", 16, 16, () -> event.accept(new Vector3f(1.0f, 0.0f, 0.0f)));
        ButtonIcon fwd = new ButtonIcon(this.gui, "vcc_overlay_btns", imgX, 0, () -> event.accept(new Vector3f(0.0f, 0.0f, -1.0f)));
        ButtonIcon back = new ButtonIcon(this.gui, "vcc_overlay_btns", imgX, 16, () -> event.accept(new Vector3f(0.0f, 0.0f, 1.0f)));
        up.setBounds(new Box(x + 25, 10, 20, 20));
        down.setBounds(new Box(x + 25, 60, 20, 20));
        left.setBounds(new Box(x, 35, 20, 20));
        right.setBounds(new Box(x + 50, 35, 20, 20));
        fwd.setBounds(new Box(x + 50, 10, 20, 20));
        back.setBounds(new Box(x + 50, 60, 20, 20));
        panel.addElement(new Label(this.gui, this.gui.i18nFormat("vivecraftcompat.gui.overlay.move." + name, new Object[0])).setBounds(new Box(x, 0, 0, 0)));
        panel.addElement((GuiElement)up);
        panel.addElement((GuiElement)down);
        panel.addElement((GuiElement)left);
        panel.addElement((GuiElement)right);
        panel.addElement((GuiElement)fwd);
        panel.addElement((GuiElement)back);
        this.moveUpdater.add(v -> {
            up.setEnabled(v);
            down.setEnabled(v);
            left.setEnabled(v);
            right.setEnabled(v);
            fwd.setEnabled(v);
            back.setEnabled(v);
        });
    }

    private String formatScale(float def) {
        return this.gui.i18nFormat("vivecraftcompat.gui.overlay.scale", new Object[]{Float.valueOf(def)});
    }

    private void addElementToOverlay() {
        if (this.elementsBox.getSelected() != null) {
            HudOverlayScreen ov;
            if (this.overlaysBox.getSelected() != null && ((OverlayElement)this.overlaysBox.getSelected()).overlay == null) {
                OverlayManager.Layer layer;
                ov = new HudOverlayScreen(UUID.randomUUID().toString());
                ov.setName(this.gui.i18nFormat("vivecraftcompat.gui.overlay.name", new Object[]{this.overlays.size()}));
                OverlayElement el = new OverlayElement(ov);
                this.overlays.add(el);
                this.overlaysBox.setSelected((Object)el);
                ov.layer = layer = new OverlayManager.Layer(ov);
                layer.spawnOverlay(ControllerType.RIGHT);
                OverlayManager.addLayer(layer);
                this.updateOutlines(ov);
            } else {
                ov = ((OverlayElement)this.overlaysBox.getSelected()).overlay;
            }
            String select = (String)((NamedElement)this.elementsBox.getSelected()).getElem();
            ov.overlays.add(select);
            this.allElements.remove(select);
            this.elementNames.refreshValues();
            this.elementsBox.setSelected(null);
            this.updateCurrentElementsList();
        }
    }

    private void deleteOverlay() {
        if (this.overlaysBox.getSelected() != null && ((OverlayElement)this.overlaysBox.getSelected()).overlay != null) {
            HudOverlayScreen s = ((OverlayElement)this.overlaysBox.getSelected()).overlay;
            this.allElements.addAll(s.overlays);
            this.elementNames.refreshValues();
            this.currentElements.getElements().clear();
            this.currentElementsScp.setScrollY(0);
            this.overlaysBox.setSelected((Object)this.overlays.get(0));
            this.overlays.removeIf(h -> h.overlay == s);
            s.layer.remove();
            this.btnDel.setEnabled(false);
        }
    }

    private void updateOutlines(HudOverlayScreen ov) {
        OverlayManager.forEachLayer(l -> {
            Screen patt16307$temp = l.getScreen();
            if (patt16307$temp instanceof HudOverlayScreen) {
                HudOverlayScreen h = (HudOverlayScreen)patt16307$temp;
                boolean bl = h == ov;
                h.outline = bl;
            }
        });
    }

    private void updateCurrentElementsList() {
        int w = this.currentElements.getBounds().w;
        this.currentElements.getElements().clear();
        this.currentElementsScp.setScrollY(0);
        boolean en = this.overlaysBox.getSelected() != null && ((OverlayElement)this.overlaysBox.getSelected()).overlay != null;
        this.btnDel.setEnabled(en);
        this.sliderScale.setEnabled(en);
        this.overlayLockBox.setEnabled(en);
        this.overlayEnableBox.setEnabled(en);
        this.updateOutlines(null);
        this.overlayLockNames.setValue((Object)OverlayLock.FLOAT);
        this.overlayEnableNames.setValue((Object)OverlayEnable.ALWAYS);
        if (en) {
            HudOverlayScreen s = ((OverlayElement)this.overlaysBox.getSelected()).overlay;
            this.overlayLockNames.setValue((Object)s.layer.getLock());
            this.overlayEnableNames.setValue((Object)s.enable);
            this.sliderScale.setValue(s.layer.getScale() / 5.0f);
            this.sliderScale.setText(this.formatScale(s.layer.getScale()));
            s.outline = true;
            s.overlays.forEach(l -> {
                Panel pn = new Panel(this.gui);
                pn.setBounds(new Box(0, 0, w, 30));
                pn.addElement(new Label(this.gui, l).setBounds(new Box(5, 5, 0, 0)));
                Button del = new Button(this.gui, "-", () -> {
                    s.overlays.remove(l);
                    this.allElements.add((String)l);
                    this.elementNames.refreshValues();
                    this.currentElements.getElements().remove(pn);
                    this.currentElementsLayout.reflow();
                });
                del.setBounds(new Box(w - 25, 5, 20, 20));
                pn.addElement((GuiElement)del);
                this.currentElements.addElement((GuiElement)pn);
            });
            this.currentElementsLayout.reflow();
        }
    }

    public void tick() {
        boolean en = this.overlaysBox.getSelected() != null && ((OverlayElement)this.overlaysBox.getSelected()).overlay != null && !((OverlayElement)this.overlaysBox.getSelected()).overlay.layer.isMoving();
        this.moveUpdater.forEach(e -> e.accept(en));
    }

    public class OverlayElement {
        private HudOverlayScreen overlay;

        public OverlayElement(HudOverlayScreen overlay) {
            this.overlay = overlay;
        }

        public String toString() {
            return this.overlay == null ? OverlaySettingsGui.this.gui.i18nFormat("vivecraftcompat.gui.overlay.create", new Object[0]) : this.overlay.toString();
        }
    }

    private class OverlayPosRotEditPopup
    extends PopupPanel {
        public OverlayPosRotEditPopup(IGui gui, OverlayManager.Layer layer) {
            super(gui);
            Vector3f oldPos = layer.getPosRaw();
            Matrix4f oldRot = layer.getRotationRaw();
            Spinner spinnerX = new Spinner(gui);
            Spinner spinnerY = new Spinner(gui);
            Spinner spinnerZ = new Spinner(gui);
            this.addElement(new Label(gui, "X").setBounds(new Box(5, 6, 0, 0)));
            this.addElement(new Label(gui, "Y").setBounds(new Box(5, 36, 0, 0)));
            this.addElement(new Label(gui, "Z").setBounds(new Box(5, 66, 0, 0)));
            spinnerX.setBounds(new Box(5, 15, 120, 20));
            spinnerY.setBounds(new Box(5, 45, 120, 20));
            spinnerZ.setBounds(new Box(5, 75, 120, 20));
            spinnerX.setDp(5);
            spinnerY.setDp(5);
            spinnerZ.setDp(5);
            this.addElement((GuiElement)spinnerX);
            this.addElement((GuiElement)spinnerY);
            this.addElement((GuiElement)spinnerZ);
            spinnerX.setValue(layer.getPosRaw().x);
            spinnerY.setValue(layer.getPosRaw().y);
            spinnerZ.setValue(layer.getPosRaw().z);
            Spinner spinnerRX = new Spinner(gui);
            Spinner spinnerRY = new Spinner(gui);
            Spinner spinnerRZ = new Spinner(gui);
            this.addElement(new Label(gui, gui.i18nFormat("vivecraftcompat.gui.overlay.move.popup.pitch", new Object[0])).setBounds(new Box(130, 6, 0, 0)));
            this.addElement(new Label(gui, gui.i18nFormat("vivecraftcompat.gui.overlay.move.popup.yaw", new Object[0])).setBounds(new Box(130, 36, 0, 0)));
            this.addElement(new Label(gui, gui.i18nFormat("vivecraftcompat.gui.overlay.move.popup.roll", new Object[0])).setBounds(new Box(130, 66, 0, 0)));
            spinnerRX.setBounds(new Box(130, 15, 120, 20));
            spinnerRY.setBounds(new Box(130, 45, 120, 20));
            spinnerRZ.setBounds(new Box(130, 75, 120, 20));
            spinnerRX.setDp(5);
            spinnerRY.setDp(5);
            spinnerRZ.setDp(5);
            this.addElement((GuiElement)spinnerRX);
            this.addElement((GuiElement)spinnerRY);
            this.addElement((GuiElement)spinnerRZ);
            Matrix4f rotationMatrix = layer.getRotationRaw();
            Quaternionf quaternion = new Quaternionf();
            rotationMatrix.getUnnormalizedRotation(quaternion);
            Vector3f rot = quaternion.getEulerAnglesXYZ(new Vector3f());
            spinnerRX.setValue(rot.x);
            spinnerRY.setValue(rot.y);
            spinnerRZ.setValue(rot.z);
            Runnable r = () -> {
                layer.setPos(new Vector3f(spinnerX.getValue(), spinnerY.getValue(), spinnerZ.getValue()));
                Quaternionf q = new Quaternionf();
                q.rotateXYZ(spinnerRX.getValue(), spinnerRY.getValue(), spinnerRZ.getValue());
                Matrix4f mat = new Matrix4f().rotate((Quaternionfc)q);
                layer.setRotation(mat);
            };
            spinnerX.addChangeListener(r);
            spinnerY.addChangeListener(r);
            spinnerZ.addChangeListener(r);
            spinnerRX.addChangeListener(r);
            spinnerRY.addChangeListener(r);
            spinnerRZ.addChangeListener(r);
            Button btn = new Button(gui, gui.i18nFormat("button.cpm.ok", new Object[0]), () -> this.close());
            Button btnNo = new Button(gui, gui.i18nFormat("button.cpm.cancel", new Object[0]), () -> {
                this.close();
                layer.setPos(oldPos);
                layer.setRotation(oldRot);
            });
            btn.setBounds(new Box(5, 100, 40, 20));
            btnNo.setBounds(new Box(50, 100, 40, 20));
            this.addElement((GuiElement)btn);
            this.addElement((GuiElement)btnNo);
            this.setBounds(new Box(0, 0, 260, 125));
        }

        public String getTitle() {
            return this.gui.i18nFormat("vivecraftcompat.gui.overlay.move.popup", new Object[0]);
        }
    }
}

