/*
 * Decompiled with CFR 0.152.
 */
package com.tom.vivecraftcompat.overlay;

import com.mojang.logging.LogUtils;
import com.tom.vivecraftcompat.overlay.OverlayEnable;
import com.tom.vivecraftcompat.overlay.OverlayManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.GuiOverlayManager;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.NamedGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.slf4j.Logger;

public class HudOverlayScreen
extends Screen {
    public static final Logger LOGGER = LogUtils.getLogger();
    public List<ResourceLocation> overlays = new ArrayList<ResourceLocation>();
    private final String id;
    private String name;
    public boolean outline;
    public OverlayManager.Layer layer;
    public OverlayEnable enable = OverlayEnable.ALWAYS;

    public HudOverlayScreen(String id) {
        super((Component)Component.m_237113_((String)""));
        this.id = id;
    }

    public void m_88315_(GuiGraphics poseStack, int pMouseX, int pMouseY, float pPartialTick) {
        if (this.f_96541_.f_91074_ == null || this.f_96541_.f_91072_ == null || this.f_96541_.f_91073_ == null || !this.isEnabled()) {
            return;
        }
        if (this.outline) {
            poseStack.m_280509_(0, 0, this.f_96543_, 1, -65536);
            poseStack.m_280509_(0, 0, 1, this.f_96544_, -65536);
            poseStack.m_280509_(this.f_96543_ - 1, 0, this.f_96543_, this.f_96544_, -65536);
            poseStack.m_280509_(0, this.f_96544_ - 1, this.f_96543_, this.f_96544_, -65536);
            poseStack.m_280262_();
        }
        int screenWidth = this.f_96541_.m_91268_().m_85445_();
        int screenHeight = this.f_96541_.m_91268_().m_85446_();
        poseStack.m_280168_().m_85836_();
        poseStack.m_280168_().m_252880_(0.0f, 0.0f, 1.0f);
        this.overlays.forEach(id -> {
            NamedGuiOverlay entry = GuiOverlayManager.findOverlay((ResourceLocation)id);
            if (entry != null) {
                try {
                    IGuiOverlay overlay = entry.overlay();
                    if (this.pre(entry, poseStack)) {
                        return;
                    }
                    overlay.render((ForgeGui)this.f_96541_.f_91065_, poseStack, pPartialTick, screenWidth, screenHeight);
                    this.post(entry, poseStack);
                }
                catch (Exception e) {
                    LOGGER.error("Error rendering overlay '{}'", (Object)entry.id(), (Object)e);
                }
            }
        });
        poseStack.m_280168_().m_85849_();
    }

    private boolean pre(NamedGuiOverlay overlay, GuiGraphics poseStack) {
        return MinecraftForge.EVENT_BUS.post((Event)new RenderGuiOverlayEvent.Pre(this.f_96541_.m_91268_(), poseStack, this.f_96541_.m_91296_(), overlay));
    }

    private void post(NamedGuiOverlay overlay, GuiGraphics poseStack) {
        MinecraftForge.EVENT_BUS.post((Event)new RenderGuiOverlayEvent.Post(this.f_96541_.m_91268_(), poseStack, this.f_96541_.m_91296_(), overlay));
    }

    public String toString() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public boolean isEnabled() {
        return this.enable.test(this.f_96541_);
    }
}

